/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.dsw.handlers;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import org.apache.cxf.Bus;
import org.apache.cxf.aegis.databinding.AegisDatabinding;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.dosgi.dsw.OsgiUtils;
import org.apache.cxf.dosgi.dsw.handlers.AbstractPojoConfigurationTypeHandler;
import org.apache.cxf.dosgi.dsw.handlers.IntentUnsatifiedException;
import org.apache.cxf.dosgi.dsw.service.CxfDistributionProvider;
import org.apache.cxf.endpoint.AbstractEndpointFactory;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerLifeCycleListener;
import org.apache.cxf.endpoint.ServerLifeCycleManager;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.transport.servlet.CXFNonSpringServlet;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.discovery.ServiceEndpointDescription;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpServiceConfigurationTypeHandler
extends AbstractPojoConfigurationTypeHandler {
    private static final Logger LOG = Logger.getLogger(HttpServiceConfigurationTypeHandler.class.getName());
    Set<ServiceReference> httpServiceReferences = new CopyOnWriteArraySet<ServiceReference>();

    protected HttpServiceConfigurationTypeHandler(BundleContext dswBC, CxfDistributionProvider dp, Map<String, Object> handlerProps) {
        super(dswBC, dp, handlerProps);
        ServiceTracker st = new ServiceTracker(dswBC, HttpService.class.getName(), null){

            public Object addingService(ServiceReference reference) {
                HttpServiceConfigurationTypeHandler.this.httpServiceReferences.add(reference);
                return super.addingService(reference);
            }

            public void removedService(ServiceReference reference, Object service) {
                HttpServiceConfigurationTypeHandler.this.httpServiceReferences.remove(reference);
                super.removedService(reference, service);
            }
        };
        st.open();
    }

    @Override
    public Object createProxy(ServiceReference serviceReference, BundleContext dswContext, BundleContext callingContext, Class<?> iClass, ServiceEndpointDescription sd) {
        return null;
    }

    @Override
    public Server createServer(ServiceReference serviceReference, BundleContext dswContext, BundleContext callingContext, ServiceEndpointDescription sd, Class<?> iClass, Object serviceBean) {
        String contextRoot = this.getServletContextRoot(sd, iClass);
        if (contextRoot == null) {
            LOG.warning("Remote address is unavailable");
            return null;
        }
        CXFNonSpringServlet cxf = new CXFNonSpringServlet();
        HttpService httpService = this.getHttpService();
        try {
            httpService.registerServlet(contextRoot, (Servlet)cxf, new Hashtable(), null);
            LOG.info("Successfully registered CXF DOSGi servlet at " + contextRoot);
        }
        catch (Exception e) {
            throw new ServiceException("CXF DOSGi: problem registering CXF HTTP Servlet", (Throwable)e);
        }
        Bus bus = cxf.getBus();
        String dataBindingImpl = (String)serviceReference.getProperty("org.apache.cxf.ws.databinding");
        Object databinding = "jaxb".equals(dataBindingImpl) ? new JAXBDataBinding() : new AegisDatabinding();
        String frontEndImpl = (String)serviceReference.getProperty("org.apache.cxf.ws.frontend");
        ServerFactoryBean factory = this.createServerFactoryBean(frontEndImpl);
        String address = this.constructAddress(dswContext, contextRoot);
        factory.setBus(bus);
        factory.setServiceClass(iClass);
        factory.setAddress("/");
        factory.getServiceFactory().setDataBinding((DataBinding)databinding);
        factory.setServiceBean(serviceBean);
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            String[] intents = this.applyIntents(dswContext, callingContext, factory.getFeatures(), (AbstractEndpointFactory)factory, sd);
            Thread.currentThread().setContextClassLoader(ServerFactoryBean.class.getClassLoader());
            Server server = factory.create();
            this.registerStopHook(bus, httpService, server, contextRoot, "org.apache.cxf.ws.httpservice.context");
            this.getDistributionProvider().addExposedService(serviceReference, this.registerPublication(server, intents, address));
            this.addAddressProperty(sd.getProperties(), address);
            Server server2 = server;
            return server2;
        }
        catch (IntentUnsatifiedException iue) {
            this.getDistributionProvider().intentsUnsatisfied(serviceReference);
            throw iue;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    protected Map<String, String> registerPublication(Server server, String[] intents, String address) {
        Map<String, String> publicationProperties = super.registerPublication(server, intents);
        publicationProperties.put("org.apache.cxf.ws.address", address);
        return publicationProperties;
    }

    protected String constructAddress(BundleContext ctx, String contextRoot) {
        String port = null;
        boolean https = false;
        if ("true".equalsIgnoreCase(ctx.getProperty("org.osgi.service.http.secure.enabled"))) {
            https = true;
            port = ctx.getProperty("org.osgi.service.http.port.secure");
        } else {
            port = ctx.getProperty("org.osgi.service.http.port");
        }
        if (port == null) {
            port = "8080";
        }
        String hostName = null;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            hostName = "localhost";
        }
        return this.getAddress(https ? "https" : "http", hostName, port, contextRoot);
    }

    protected HttpService getHttpService() {
        for (ServiceReference sr : this.httpServiceReferences) {
            Object svc = this.bundleContext.getService(sr);
            if (!(svc instanceof HttpService)) continue;
            return (HttpService)svc;
        }
        throw new ServiceException("CXF DOSGi: No HTTP Service could be found to publish CXF endpoint in.");
    }

    protected String getServletContextRoot(ServiceEndpointDescription sd, Class<?> iClass) {
        String context = OsgiUtils.getProperty(sd, "org.apache.cxf.ws.httpservice.context");
        if (context == null) {
            context = OsgiUtils.getProperty(sd, "osgi.remote.configuration.pojo.httpservice.context");
        }
        if (context == null) {
            context = "/" + iClass.getName().replace('.', '/');
            LOG.info("Using a default address : " + context);
        }
        return context;
    }

    protected void registerStopHook(Bus bus, final HttpService httpService, Server theServer, final String contextRoot, final String propertyName) {
        if (bus != null) {
            theServer.getEndpoint().put((Object)propertyName, (Object)contextRoot);
            ServerLifeCycleListener stopHook = new ServerLifeCycleListener(){

                public void stopServer(Server s) {
                    Object contextProperty = s.getEndpoint().get((Object)propertyName);
                    if (contextProperty != null && contextProperty.equals(contextRoot)) {
                        httpService.unregister(contextRoot);
                    }
                }

                public void startServer(Server s) {
                }
            };
            ServerLifeCycleManager mgr = (ServerLifeCycleManager)bus.getExtension(ServerLifeCycleManager.class);
            if (mgr != null) {
                mgr.registerListener(stopHook);
            }
        }
    }
}

