/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.dsw.handlers;

import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.cxf.dosgi.dsw.OsgiUtils;
import org.apache.cxf.dosgi.dsw.handlers.ConfigurationTypeHandler;
import org.apache.cxf.dosgi.dsw.handlers.HttpServiceConfigurationTypeHandler;
import org.apache.cxf.dosgi.dsw.handlers.JaxRSHttpServiceConfigurationTypeHandler;
import org.apache.cxf.dosgi.dsw.handlers.JaxRSPojoConfigurationTypeHandler;
import org.apache.cxf.dosgi.dsw.handlers.PojoConfigurationTypeHandler;
import org.apache.cxf.dosgi.dsw.handlers.WsdlConfigurationTypeHandler;
import org.apache.cxf.dosgi.dsw.service.CxfDistributionProvider;
import org.osgi.framework.BundleContext;
import org.osgi.service.discovery.ServiceEndpointDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfigTypeHandlerFactory {
    private static final Logger LOG = Logger.getLogger(ConfigTypeHandlerFactory.class.getName());
    private static final ConfigTypeHandlerFactory FACTORY = new ConfigTypeHandlerFactory();

    private ConfigTypeHandlerFactory() {
    }

    public static ConfigTypeHandlerFactory getInstance() {
        return FACTORY;
    }

    public ConfigurationTypeHandler getHandler(BundleContext dswBC, ServiceEndpointDescription sd, CxfDistributionProvider dp, Map<String, Object> handlerProperties) {
        Collection<String> types = OsgiUtils.getMultiValueProperty(sd.getProperty("service.exported.configs"));
        if (types == null) {
            types = OsgiUtils.getMultiValueProperty(sd.getProperty("osgi.remote.configuration.type"));
        }
        if (types == null || types.contains("org.apache.cxf.ws") || types.contains("pojo") || types.contains("org.apache.cxf.rs")) {
            if (types == null) {
                LOG.info("Defaulting to pojo configuration type ");
            }
            boolean jaxrs = this.isJaxrsRequested(types, sd);
            if (OsgiUtils.getProperty(sd, "org.apache.cxf.ws.httpservice.context") != null || OsgiUtils.getProperty(sd, "org.apache.cxf.rs.httpservice.context") != null || OsgiUtils.getProperty(sd, "osgi.remote.configuration.pojo.httpservice.context") != null) {
                return jaxrs ? new JaxRSHttpServiceConfigurationTypeHandler(dswBC, dp, handlerProperties) : new HttpServiceConfigurationTypeHandler(dswBC, dp, handlerProperties);
            }
            return jaxrs ? new JaxRSPojoConfigurationTypeHandler(dswBC, dp, handlerProperties) : new PojoConfigurationTypeHandler(dswBC, dp, handlerProperties);
        }
        if (types.contains("wsdl")) {
            return new WsdlConfigurationTypeHandler(dswBC, dp, handlerProperties);
        }
        LOG.info("None of the configuration types in " + types + " is supported.");
        return null;
    }

    private boolean isJaxrsRequested(Collection<String> types, ServiceEndpointDescription sd) {
        if (types == null) {
            return false;
        }
        if (types.contains("org.apache.cxf.rs")) {
            String intentsProperty = OsgiUtils.getProperty(sd, "service.exported.intents");
            boolean hasHttpIntent = false;
            boolean hasSoapIntent = false;
            if (intentsProperty != null) {
                String[] intents = OsgiUtils.parseIntents(intentsProperty);
                for (int i = 0; i < intents.length; ++i) {
                    if (intents[i].indexOf("SOAP") > -1) {
                        hasSoapIntent = true;
                        break;
                    }
                    if (!"HTTP".equals(intents[i])) continue;
                    hasHttpIntent = true;
                }
            }
            if (intentsProperty != null && hasHttpIntent && !hasSoapIntent || intentsProperty == null) {
                return true;
            }
        }
        return false;
    }
}

