/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.dsw.handlers;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.dosgi.dsw.handlers.ConfigurationTypeHandler;
import org.apache.cxf.dosgi.dsw.handlers.IntentUnsatifiedException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.discovery.ServiceEndpointDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientServiceFactory
implements ServiceFactory {
    private static final Logger LOG = Logger.getLogger(ClientServiceFactory.class.getName());
    private BundleContext dswContext;
    private Class<?> iClass;
    private ServiceEndpointDescription sd;
    private ConfigurationTypeHandler handler;

    public ClientServiceFactory(BundleContext dswContext, Class<?> iClass, ServiceEndpointDescription sd, ConfigurationTypeHandler handler) {
        this.dswContext = dswContext;
        this.iClass = iClass;
        this.sd = sd;
        this.handler = handler;
    }

    public Object getService(Bundle requestingBundle, ServiceRegistration sreg) {
        String interfaceName = this.sd.getProvidedInterfaces() != null && this.sd.getProvidedInterfaces().size() > 0 ? (String)this.sd.getProvidedInterfaces().toArray()[0] : null;
        try {
            return this.handler.createProxy(sreg.getReference(), this.dswContext, requestingBundle.getBundleContext(), this.iClass, this.sd);
        }
        catch (IntentUnsatifiedException iue) {
            LOG.info("Did not create proxy for " + interfaceName + " because intent " + iue.getIntent() + " could not be satisfied");
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Problem creating a remote proxy for " + interfaceName + " from CXF FindHook: ", ex);
        }
        return null;
    }

    public void ungetService(Bundle requestingBundle, ServiceRegistration sreg, Object serviceObject) {
        StringBuilder sb = new StringBuilder();
        sb.append("Releasing a client object");
        Object objectClass = sreg.getReference().getProperty("objectClass");
        if (objectClass != null) {
            sb.append(", interfaces : ");
            for (String s : (String[])objectClass) {
                sb.append(" " + s);
            }
        }
        LOG.info(sb.toString());
    }
}

