/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.dsw.handlers;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import org.apache.cxf.dosgi.dsw.OsgiUtils;
import org.apache.cxf.dosgi.dsw.handlers.ConfigurationTypeHandler;
import org.apache.cxf.dosgi.dsw.handlers.ServiceInvocationHandler;
import org.apache.cxf.dosgi.dsw.service.CxfDistributionProvider;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConfigurationHandler
implements ConfigurationTypeHandler {
    private final CxfDistributionProvider distributionProvider;
    final Map<String, Object> handlerProps;
    protected BundleContext bundleContext;

    protected AbstractConfigurationHandler(BundleContext dswBC, CxfDistributionProvider dp, Map<String, Object> handlerProps) {
        this.bundleContext = dswBC;
        this.distributionProvider = dp;
        this.handlerProps = handlerProps;
    }

    protected String getDefaultAddress(Class<?> type) {
        String host = this.handlerProps.get("default.host").toString();
        String port = this.handlerProps.get("default.port").toString();
        return this.getAddress("http", host, port, "/" + type.getName().replace('.', '/'));
    }

    protected String getAddress(String scheme, String host, String port, String context) {
        StringBuilder buf = new StringBuilder();
        buf.append(scheme).append("://").append(host).append(':').append(port).append(context);
        return buf.toString();
    }

    protected boolean useMasterMap() {
        Object value = this.handlerProps.get("use.master.map");
        if (value == null) {
            return true;
        }
        return OsgiUtils.toBoolean(value);
    }

    protected CxfDistributionProvider getDistributionProvider() {
        return this.distributionProvider;
    }

    protected Object getProxy(Object serviceProxy, Class<?> iType) {
        return Proxy.newProxyInstance(iType.getClassLoader(), new Class[]{iType}, (InvocationHandler)new ServiceInvocationHandler(serviceProxy, iType));
    }
}

