/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.dsw;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.cxf.dosgi.dsw.OsgiUtils;
import org.apache.cxf.dosgi.dsw.decorator.ServiceDecorator;
import org.apache.cxf.dosgi.dsw.decorator.ServiceDecoratorImpl;
import org.apache.cxf.dosgi.dsw.hooks.CxfFindListenerHook;
import org.apache.cxf.dosgi.dsw.hooks.CxfPublishHook;
import org.apache.cxf.dosgi.dsw.qos.IntentMap;
import org.apache.cxf.dosgi.dsw.service.CxfDistributionProvider;
import org.apache.cxf.dosgi.dsw.service.DistributionProviderImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.service.FindHook;
import org.osgi.framework.hooks.service.ListenerHook;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.distribution.DistributionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activator
implements BundleActivator,
ServiceListener,
ManagedService {
    private static final String CONFIG_SERVICE_PID = "cxf-dsw";
    private BundleContext bc;
    private ExecutorService execService = new ThreadPoolExecutor(5, 10, 50L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    CxfDistributionProvider dpService;
    CxfFindListenerHook lHook;
    CxfPublishHook pHook;
    ServiceRegistration decoratorReg;

    public void start(BundleContext context) throws Exception {
        System.setProperty("org.apache.cxf.nofastinfoset", "true");
        this.bc = context;
        context.registerService(ManagedService.class.getName(), (Object)this, this.getDefaults());
        this.decoratorReg = context.registerService(ServiceDecorator.class.getName(), (Object)new ServiceDecoratorImpl(context), null);
        this.dpService = this.registerDistributionProviderService();
        this.pHook = new CxfPublishHook(context, this.dpService);
        this.lHook = new CxfFindListenerHook(context, this.dpService);
        context.registerService(new String[]{FindHook.class.getName(), ListenerHook.class.getName()}, (Object)this.lHook, new Hashtable());
        context.addServiceListener((ServiceListener)this);
        this.checkExistingServices();
    }

    private CxfDistributionProvider registerDistributionProviderService() {
        DistributionProviderImpl dpService = new DistributionProviderImpl(this.bc);
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        props.put("osgi.remote.distribution.product", this.getHeader("Bundle-Name"));
        props.put("osgi.remote.distribution.product.version", this.getHeader("Bundle-Version"));
        props.put("osgi.remote.distribution.vendor", this.getHeader("Bundle-Vendor"));
        String[] supportedIntents = this.getIntentMap().getIntents().keySet().toArray(new String[0]);
        String siString = OsgiUtils.formatIntents(supportedIntents);
        props.put("osgi.remote.distribition.supported_intents", siString);
        props.put("remote.intents.supported", supportedIntents);
        String[] supportedConfigs = new String[]{"org.apache.cxf.ws", "pojo", "org.apache.cxf.rs"};
        props.put("remote.configs.supported", supportedConfigs);
        this.bc.registerService(DistributionProvider.class.getName(), (Object)dpService, props);
        return dpService;
    }

    IntentMap getIntentMap() {
        return OsgiUtils.getIntentMap(this.bc);
    }

    private Object getHeader(String key) {
        Object value = this.bc.getBundle().getHeaders().get(key);
        if (value == null) {
            return "";
        }
        return value;
    }

    public void stop(BundleContext context) {
        this.dpService.shutdown();
        this.execService.shutdown();
        this.pHook.removeEndpoints();
        this.decoratorReg.unregister();
    }

    private Dictionary<String, String> getDefaults() {
        Hashtable<String, String> defaults = new Hashtable<String, String>();
        ((Dictionary)defaults).put("service.pid", CONFIG_SERVICE_PID);
        return defaults;
    }

    public void updated(Dictionary props) throws ConfigurationException {
        if (props != null && CONFIG_SERVICE_PID.equals(props.get("service.pid"))) {
            this.pHook.updateProperties(props);
            this.lHook.updateProperties(props);
        }
    }

    private void checkExistingServices() throws InvalidSyntaxException {
        ServiceReference[] references = this.bc.getServiceReferences(null, "(|(service.exported.interfaces=*)(osgi.remote.interfaces=*))");
        if (references != null) {
            for (ServiceReference sref : references) {
                this.pHook.publishEndpoint(sref);
            }
        }
    }

    public void serviceChanged(ServiceEvent event) {
        final ServiceReference sref = event.getServiceReference();
        if (event.getType() == 1) {
            this.execService.execute(new Runnable(){

                public void run() {
                    Activator.this.pHook.publishEndpoint(sref);
                }
            });
        } else if (event.getType() == 4) {
            this.pHook.removeEndpoint(sref);
        }
    }
}

