/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.dsw.service;

import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.apache.cxf.dosgi.dsw.service.CxfDistributionProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.distribution.DistributionProvider;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributionProviderImpl
implements DistributionProvider,
CxfDistributionProvider {
    private Set<EventAdmin> eventAdmins = new HashSet<EventAdmin>();
    private Map<ServiceReference, Map<String, String>> publicationProperties = new HashMap<ServiceReference, Map<String, String>>();
    private Set<ServiceReference> exposedServices = new HashSet<ServiceReference>();
    private Set<ServiceReference> remoteServices = new HashSet<ServiceReference>();
    private final ServiceTracker tracker;

    public DistributionProviderImpl(BundleContext bc) {
        this.tracker = new ServiceTracker(bc, EventAdmin.class.getName(), (ServiceTrackerCustomizer)new MyTrackerCustomizer());
        this.tracker.open();
    }

    @Override
    public void shutdown() {
        this.tracker.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getExposedProperties(ServiceReference sr) {
        Map<ServiceReference, Map<String, String>> map = this.publicationProperties;
        synchronized (map) {
            return this.publicationProperties.get(sr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection getExposedServices() {
        Set<ServiceReference> set = this.exposedServices;
        synchronized (set) {
            return new HashSet<ServiceReference>(this.exposedServices);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection getRemoteServices() {
        Set<ServiceReference> set = this.remoteServices;
        synchronized (set) {
            return new HashSet<ServiceReference>(this.remoteServices);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addExposedService(ServiceReference sr, Map<String, String> pp) {
        Object object = this.exposedServices;
        synchronized (object) {
            this.exposedServices.add(sr);
        }
        object = this.publicationProperties;
        synchronized (object) {
            if (pp == null) {
                pp = Collections.emptyMap();
            }
            this.publicationProperties.put(sr, pp);
        }
        this.postAdminEvent(DistributionProvider.class.getName().replace('.', '/') + "/service/exposed", sr);
    }

    @Override
    public void intentsUnsatisfied(ServiceReference sr) {
        this.postAdminEvent(DistributionProvider.class.getName().replace('.', '/') + "/service/unsatisfied", sr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postAdminEvent(String topic, ServiceReference serviceReference) {
        HashSet<EventAdmin> eas = null;
        Set<EventAdmin> set = this.eventAdmins;
        synchronized (set) {
            eas = new HashSet<EventAdmin>(this.eventAdmins);
        }
        for (EventAdmin eventAdmin : eas) {
            Hashtable ht = new Hashtable();
            this.addEventEntry(ht, "service", serviceReference);
            this.addEventEntry(ht, "service.id", serviceReference.getProperty("service.id"));
            this.addEventEntry(ht, "service.objectClass", serviceReference.getProperty("objectClass"));
            this.addEventEntry(ht, "service.pid", serviceReference.getProperty("service.pid"));
            eventAdmin.postEvent(new Event(topic, ht));
        }
    }

    private void addEventEntry(Dictionary ht, String key, Object value) {
        if (value != null) {
            ht.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventAdmin(EventAdmin ea) {
        Set<EventAdmin> set = this.eventAdmins;
        synchronized (set) {
            this.eventAdmins.add(ea);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRemoteService(ServiceReference sr) {
        Set<ServiceReference> set = this.remoteServices;
        synchronized (set) {
            this.remoteServices.add(sr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventAdmin(EventAdmin ea) {
        Set<EventAdmin> set = this.eventAdmins;
        synchronized (set) {
            this.eventAdmins.remove(ea);
        }
    }

    private class MyTrackerCustomizer
    implements ServiceTrackerCustomizer {
        private MyTrackerCustomizer() {
        }

        public Object addingService(ServiceReference sr) {
            Object svc = sr.getBundle().getBundleContext().getService(sr);
            if (svc instanceof EventAdmin) {
                DistributionProviderImpl.this.addEventAdmin((EventAdmin)svc);
            }
            return svc;
        }

        public void modifiedService(ServiceReference sr, Object svc) {
        }

        public void removedService(ServiceReference sr, Object svc) {
            if (svc != null) {
                DistributionProviderImpl.this.removeEventAdmin((EventAdmin)svc);
            }
        }
    }
}

