/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.dsw.hooks;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import org.apache.cxf.dosgi.dsw.ClassUtils;
import org.apache.cxf.dosgi.dsw.handlers.ConfigTypeHandlerFactory;
import org.apache.cxf.dosgi.dsw.handlers.ConfigurationTypeHandler;
import org.apache.cxf.dosgi.dsw.handlers.IntentUnsatifiedException;
import org.apache.cxf.dosgi.dsw.hooks.EndpointInfo;
import org.apache.cxf.dosgi.dsw.service.CxfDistributionProvider;
import org.apache.cxf.endpoint.Server;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.discovery.ServiceEndpointDescription;
import org.osgi.service.discovery.ServicePublication;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServiceHookUtils {
    private static final Logger LOG = Logger.getLogger(ServiceHookUtils.class.getName());

    private ServiceHookUtils() {
    }

    public static ServiceRegistration publish(BundleContext bc, final ServiceReference sr, ServiceEndpointDescription sd) {
        ServiceRegistration publication = bc.registerService(ServicePublication.class.getName(), (Object)new ServicePublication(){

            public ServiceReference getReference() {
                return sr;
            }
        }, ServiceHookUtils.getPublicationProperties(sd));
        if (publication != null) {
            LOG.info("Remote " + sd.getProvidedInterfaces().toArray()[0] + " endpoint published via Discovery service");
        }
        return publication;
    }

    public static Server createServer(ConfigurationTypeHandler handler, ServiceReference serviceReference, BundleContext dswContext, BundleContext callingContext, ServiceEndpointDescription sd, Object serviceObject) {
        if (handler == null) {
            return null;
        }
        String interfaceName = (String)sd.getProvidedInterfaces().toArray()[0];
        Class<?> interfaceClass = ClassUtils.getInterfaceClass(serviceObject, interfaceName);
        if (interfaceClass != null) {
            try {
                return handler.createServer(serviceReference, dswContext, callingContext, sd, interfaceClass, serviceObject);
            }
            catch (IntentUnsatifiedException iue) {
                LOG.info("Did not remote service " + interfaceName + " because intent " + iue.getIntent() + " could not be satisfied");
            }
            catch (Exception ex) {
                LOG.warning("WARNING : Problem creating a remote endpoint for " + interfaceName + " from CXF PublishHook, reason is " + ex.getMessage());
            }
        }
        return null;
    }

    public static void unregisterServer(ServiceRegistration publication, EndpointInfo ei) {
        try {
            Server server = ei.getServer();
            LOG.info("Stopping CXF Endpoint at " + server.getDestination().getAddress().getAddress().getValue());
            server.getDestination().shutdown();
            server.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ei.isPublished()) {
            LOG.info("Unpublishing Service Description for " + ei.getServiceDescription().getProvidedInterfaces().toArray()[0] + " from a Discovery service ");
            publication.unregister();
        }
    }

    public static ConfigurationTypeHandler getHandler(BundleContext dswBC, ServiceEndpointDescription sd, CxfDistributionProvider dp, Map<String, Object> dswProperties) {
        return ConfigTypeHandlerFactory.getInstance().getHandler(dswBC, sd, dp, dswProperties);
    }

    public static boolean isCreatedByDsw(ServiceReference sref) {
        return sref != null && sref.getProperty("org.apache.cxf.remote.dsw.client") != null;
    }

    private static Map<String, Object> getServiceProperties(ServiceEndpointDescription sd) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (Object key : sd.getPropertyKeys()) {
            props.put(key.toString(), sd.getProperty(key.toString()));
        }
        LOG.info("service properties: " + props);
        return props;
    }

    private static Dictionary getPublicationProperties(ServiceEndpointDescription sd) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("osgi.remote.service.interfaces", sd.getProvidedInterfaces());
        ((Dictionary)props).put("osgi.remote.discovery.publication.service.properties", ServiceHookUtils.getServiceProperties(sd));
        ((Dictionary)props).put("osgi.remote.endpoint.id", UUID.randomUUID().toString());
        if (sd.getLocation() != null) {
            ((Dictionary)props).put("osgi.remote.endpoint.location", sd.getLocation());
        }
        LOG.info("publication properties: " + props);
        return props;
    }
}

