/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.dsw.handlers;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.framework.ServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceInvocationHandler
implements InvocationHandler {
    private static final String REMOTE_EXCEPTION_TYPE = "REMOTE";
    private Map<Method, List<Class<?>>> exceptionsMap = new HashMap();
    private Object serviceObject;

    public ServiceInvocationHandler(Object serviceObject, Class<?> iType) {
        this.serviceObject = serviceObject;
        this.introspectType(iType);
    }

    @Override
    public Object invoke(Object proxy, Method m, Object[] params) throws Throwable {
        try {
            return m.invoke(this.serviceObject, params);
        }
        catch (Throwable ex) {
            Throwable theCause = ex.getCause() == null ? ex : ex.getCause();
            List<Class<?>> excTypes = this.exceptionsMap.get(m);
            if (excTypes != null) {
                for (Class<?> type : excTypes) {
                    if (!type.isAssignableFrom(theCause.getClass())) continue;
                    throw theCause;
                }
            }
            throw new InvocationTargetException((Throwable)new ServiceException(REMOTE_EXCEPTION_TYPE, theCause));
        }
    }

    private void introspectType(Class<?> iType) {
        for (Method m : iType.getDeclaredMethods()) {
            for (Class<?> excType : m.getExceptionTypes()) {
                if (!Exception.class.isAssignableFrom(excType)) continue;
                List<Class<?>> types = this.exceptionsMap.get(m);
                if (types == null) {
                    types = new ArrayList();
                    this.exceptionsMap.put(m, types);
                }
                types.add(excType);
            }
        }
    }
}

