/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.dsw.handlers;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.aegis.databinding.AegisDatabinding;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.dosgi.dsw.OsgiUtils;
import org.apache.cxf.dosgi.dsw.handlers.AbstractPojoConfigurationTypeHandler;
import org.apache.cxf.dosgi.dsw.handlers.IntentUnsatifiedException;
import org.apache.cxf.dosgi.dsw.service.CxfDistributionProvider;
import org.apache.cxf.endpoint.AbstractEndpointFactory;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.frontend.ClientProxyFactoryBean;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.discovery.ServiceEndpointDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PojoConfigurationTypeHandler
extends AbstractPojoConfigurationTypeHandler {
    private static final Logger LOG = Logger.getLogger(PojoConfigurationTypeHandler.class.getName());

    public PojoConfigurationTypeHandler(BundleContext dswBC, CxfDistributionProvider dp, Map<String, Object> handlerProps) {
        super(dswBC, dp, handlerProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object createProxy(ServiceReference serviceReference, BundleContext dswContext, BundleContext callingContext, Class<?> iClass, ServiceEndpointDescription sd) throws IntentUnsatifiedException {
        String address = this.getPojoAddress(sd, iClass);
        if (address == null) {
            LOG.warning("Remote address is unavailable");
            return null;
        }
        LOG.info("Creating a " + sd.getProvidedInterfaces().toArray()[0] + " client, endpoint address is " + address);
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClientProxyFactoryBean factory = this.createClientProxyFactoryBean();
            factory.setServiceClass(iClass);
            factory.setAddress(address);
            factory.getServiceFactory().setDataBinding((DataBinding)new AegisDatabinding());
            this.applyIntents(dswContext, callingContext, factory.getFeatures(), (AbstractEndpointFactory)factory.getClientFactoryBean(), sd);
            Thread.currentThread().setContextClassLoader(ClientProxyFactoryBean.class.getClassLoader());
            Object proxy = this.getProxy(factory.create(), iClass);
            this.getDistributionProvider().addRemoteService(serviceReference);
            Object object = proxy;
            return object;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "proxy creation failed", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        return null;
    }

    @Override
    public Server createServer(ServiceReference serviceReference, BundleContext dswContext, BundleContext callingContext, ServiceEndpointDescription sd, Class<?> iClass, Object serviceBean) throws IntentUnsatifiedException {
        String address = this.getPojoAddress(sd, iClass);
        if (address == null) {
            LOG.warning("Remote address is unavailable");
            return null;
        }
        LOG.info("Creating a " + sd.getProvidedInterfaces().toArray()[0] + " endpoint from CXF PublishHook, address is " + address);
        ServerFactoryBean factory = this.createServerFactoryBean();
        factory.setServiceClass(iClass);
        factory.setAddress(address);
        factory.getServiceFactory().setDataBinding((DataBinding)new AegisDatabinding());
        factory.setServiceBean(serviceBean);
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            String[] intents = this.applyIntents(dswContext, callingContext, factory.getFeatures(), (AbstractEndpointFactory)factory, sd);
            Thread.currentThread().setContextClassLoader(ServerFactoryBean.class.getClassLoader());
            Server server = factory.create();
            this.getDistributionProvider().addExposedService(serviceReference, this.registerPublication(server, intents));
            this.addAddressProperty(sd.getProperties(), address);
            Server server2 = server;
            return server2;
        }
        catch (IntentUnsatifiedException iue) {
            this.getDistributionProvider().intentsUnsatisfied(serviceReference);
            throw iue;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    @Override
    Map<String, String> registerPublication(Server server, String[] intents) {
        Map<String, String> publicationProperties = super.registerPublication(server, intents);
        publicationProperties.put("osgi.remote.configuration.pojo.address", server.getDestination().getAddress().getAddress().getValue());
        return publicationProperties;
    }

    private String getPojoAddress(ServiceEndpointDescription sd, Class<?> iClass) {
        String address = OsgiUtils.getProperty(sd, "osgi.remote.configuration.pojo.address");
        if (address == null && (address = this.getDefaultAddress(iClass)) != null) {
            LOG.info("Using a default address : " + address);
        }
        return address;
    }
}

