/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.dsw.handlers;

import java.util.Map;
import java.util.logging.Logger;
import org.apache.cxf.dosgi.dsw.OsgiUtils;
import org.apache.cxf.dosgi.dsw.handlers.ConfigurationTypeHandler;
import org.apache.cxf.dosgi.dsw.handlers.HttpServiceConfigurationTypeHandler;
import org.apache.cxf.dosgi.dsw.handlers.PojoConfigurationTypeHandler;
import org.apache.cxf.dosgi.dsw.handlers.WsdlConfigurationTypeHandler;
import org.apache.cxf.dosgi.dsw.service.CxfDistributionProvider;
import org.osgi.framework.BundleContext;
import org.osgi.service.discovery.ServiceEndpointDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfigTypeHandlerFactory {
    private static final Logger LOG = Logger.getLogger(ConfigTypeHandlerFactory.class.getName());
    private static final ConfigTypeHandlerFactory FACTORY = new ConfigTypeHandlerFactory();

    private ConfigTypeHandlerFactory() {
    }

    public static ConfigTypeHandlerFactory getInstance() {
        return FACTORY;
    }

    public ConfigurationTypeHandler getHandler(BundleContext dswBC, ServiceEndpointDescription sd, CxfDistributionProvider dp, Map<String, Object> handlerProperties) {
        String type = OsgiUtils.getProperty(sd, "osgi.remote.configuration.type");
        if (type == null || "pojo".equalsIgnoreCase(type)) {
            if (type == null) {
                LOG.info("Defaulting to pojo configuration type ");
            }
            if (OsgiUtils.getProperty(sd, "osgi.remote.configuration.pojo.httpservice.context") != null) {
                if (OsgiUtils.getProperty(sd, "osgi.remote.configuration.pojo.address") != null) {
                    return null;
                }
                return new HttpServiceConfigurationTypeHandler(dswBC, dp, handlerProperties);
            }
            return new PojoConfigurationTypeHandler(dswBC, dp, handlerProperties);
        }
        if ("wsdl".equalsIgnoreCase(type)) {
            return new WsdlConfigurationTypeHandler(dswBC, dp, handlerProperties);
        }
        LOG.info("Configuration type " + type + " is not supported");
        return null;
    }
}

