/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.dsw.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.cxf.binding.BindingConfiguration;
import org.apache.cxf.dosgi.dsw.OsgiUtils;
import org.apache.cxf.dosgi.dsw.handlers.AbstractConfigurationHandler;
import org.apache.cxf.dosgi.dsw.handlers.IntentUnsatifiedException;
import org.apache.cxf.dosgi.dsw.qos.IntentMap;
import org.apache.cxf.dosgi.dsw.service.CxfDistributionProvider;
import org.apache.cxf.endpoint.AbstractEndpointFactory;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.frontend.ClientProxyFactoryBean;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.osgi.framework.BundleContext;
import org.osgi.service.discovery.ServiceEndpointDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPojoConfigurationTypeHandler
extends AbstractConfigurationHandler {
    private static final Logger LOG = Logger.getLogger(AbstractPojoConfigurationTypeHandler.class.getName());
    private static final String PROVIDED_INTENT_VALUE = "PROVIDED";
    private IntentMap masterMap;

    public AbstractPojoConfigurationTypeHandler(BundleContext dswBC, CxfDistributionProvider dp, Map<String, Object> handlerProps) {
        super(dswBC, dp, handlerProps);
    }

    ClientProxyFactoryBean createClientProxyFactoryBean() {
        return new ClientProxyFactoryBean();
    }

    ServerFactoryBean createServerFactoryBean() {
        return new ServerFactoryBean();
    }

    Map<String, String> registerPublication(Server server, String[] intents) {
        HashMap<String, String> publicationProperties = new HashMap<String, String>();
        publicationProperties.put("osgi.remote.configuration.type", "pojo");
        String intentsValue = OsgiUtils.formatIntents(intents);
        if (intentsValue.length() > 0) {
            publicationProperties.put("osgi.deployment.intents", intentsValue);
        }
        return publicationProperties;
    }

    String[] applyIntents(BundleContext dswContext, BundleContext callingContext, List<AbstractFeature> features, AbstractEndpointFactory factory, ServiceEndpointDescription sd) throws IntentUnsatifiedException {
        String[] requestedIntents = AbstractPojoConfigurationTypeHandler.getRequestedIntents(sd);
        HashSet<String> appliedIntents = new HashSet<String>(Arrays.asList(requestedIntents));
        IntentMap intentMap = this.getIntentMap(callingContext);
        if (this.useMasterMap()) {
            intentMap = this.mergeWithMaster(dswContext, intentMap);
        }
        appliedIntents.addAll(this.reverseLookup(intentMap, PROVIDED_INTENT_VALUE));
        boolean bindingConfigAdded = false;
        for (String requestedName : requestedIntents) {
            bindingConfigAdded |= this.processIntent(appliedIntents, features, factory, requestedName, intentMap);
        }
        if (!bindingConfigAdded && this.getDefaultBindingIntent() != null) {
            this.processIntent(appliedIntents, features, factory, this.getDefaultBindingIntent(), intentMap);
        }
        appliedIntents.addAll(this.addSynonymIntents(appliedIntents, intentMap));
        return appliedIntents.toArray(new String[0]);
    }

    private boolean processIntent(Set<String> appliedIntents, List<AbstractFeature> features, AbstractEndpointFactory factory, String intentName, IntentMap intentMap) throws IntentUnsatifiedException {
        boolean rc = this.processIntent(features, factory, intentName, intentMap);
        appliedIntents.add(intentName);
        return rc;
    }

    private boolean processIntent(List<AbstractFeature> features, AbstractEndpointFactory factory, String intentName, IntentMap intentMap) throws IntentUnsatifiedException {
        Object intent = intentMap.get(intentName);
        if (intent instanceof String) {
            if (PROVIDED_INTENT_VALUE.equalsIgnoreCase((String)intent)) {
                return false;
            }
        } else {
            if (intent instanceof AbstractFeature) {
                AbstractFeature feature = (AbstractFeature)intent;
                LOG.info("Applying intent: " + intentName + " via feature: " + feature);
                features.add(feature);
                return false;
            }
            if (intent instanceof BindingConfiguration) {
                BindingConfiguration bindingCfg = (BindingConfiguration)intent;
                LOG.info("Applying intent: " + intentName + " via binding config: " + bindingCfg);
                factory.setBindingConfig(bindingCfg);
                return true;
            }
            LOG.info("No mapping for intent: " + intentName);
            throw new IntentUnsatifiedException(intentName);
        }
        return false;
    }

    private Collection<String> addSynonymIntents(Collection<String> appliedIntents, IntentMap intentMap) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (String key : appliedIntents) {
            values.add(intentMap.get(key));
        }
        return this.reverseLookup(intentMap, values);
    }

    private Collection<String> reverseLookup(IntentMap intentMap, Object obj) {
        return this.reverseLookup(intentMap, Collections.singleton(obj));
    }

    private Collection<String> reverseLookup(IntentMap intentMap, Collection<? extends Object> objs) {
        HashSet<String> intentsFound = new HashSet<String>();
        for (Map.Entry<String, Object> entry : intentMap.getIntents().entrySet()) {
            if (!objs.contains(entry.getValue())) continue;
            intentsFound.add(entry.getKey());
        }
        return intentsFound;
    }

    String getDefaultBindingIntent() {
        return "SOAP";
    }

    IntentMap getIntentMap(BundleContext callingContext) {
        return OsgiUtils.getIntentMap(callingContext);
    }

    private static String[] getRequestedIntents(ServiceEndpointDescription sd) {
        String property = OsgiUtils.getProperty(sd, "osgi.remote.requires.intents");
        String[] intents = OsgiUtils.parseIntents(property);
        for (int i = 0; i < intents.length; ++i) {
            LOG.fine("Intent asserted: " + intents[i]);
        }
        return intents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IntentMap mergeWithMaster(BundleContext dswContext, IntentMap intentMap) {
        AbstractPojoConfigurationTypeHandler abstractPojoConfigurationTypeHandler = this;
        synchronized (abstractPojoConfigurationTypeHandler) {
            if (this.masterMap == null) {
                LOG.fine("Loading master intent map");
                this.masterMap = this.getIntentMap(dswContext);
            }
        }
        if (this.masterMap != null) {
            for (String masterKey : this.masterMap.getIntents().keySet()) {
                if (intentMap.get(masterKey) == null) {
                    LOG.fine("Merging in master intent map entry: " + masterKey);
                    intentMap.getIntents().put(masterKey, this.masterMap.get(masterKey));
                    continue;
                }
                LOG.fine("Overridden master intent map entry: " + masterKey);
            }
        }
        return intentMap;
    }

    protected void addAddressProperty(Map props, String address) {
        if (props != null) {
            props.put("osgi.remote.endpoint.location", address);
        }
    }
}

