/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.dsw;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.dosgi.dsw.OsgiService;
import org.apache.cxf.dosgi.dsw.qos.IntentMap;
import org.apache.cxf.dosgi.dsw.service.ServiceEndpointDescriptionImpl;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.discovery.ServiceEndpointDescription;
import org.springframework.osgi.context.support.OsgiBundleXmlApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OsgiUtils {
    private static final Logger LOG = Logger.getLogger(OsgiUtils.class.getName());
    private static final String REMOTE_SERVICES_HEADER_NAME = "Remote-Service";
    private static final String REMOTE_SERVICES_DIRECTORY = "OSGI-INF/remote-service";
    private static final String REMOTE_SERVICES_NS = "http://www.osgi.org/xmlns/sd/v1.0.0";
    static final String[] INTENT_MAP = new String[]{"/OSGI-INF/cxf/intents/intent-map.xml"};
    private static final String SERVICE_DESCRIPTION_ELEMENT = "service-description";
    private static final String PROVIDE_INTERFACE_ELEMENT = "provide";
    private static final String PROVIDE_INTERFACE_NAME_ATTRIBUTE = "interface";
    private static final String PROPERTY_ELEMENT = "property";
    private static final String PROPERTY_NAME_ATTRIBUTE = "name";
    private static final String PROPERTY_VALUE_ATTRIBUTE = "value";
    private static final String PROPERTY_INTERFACE_ATTRIBUTE = "interface";
    private static final String INTERFACE_WILDCARD = "*";
    private static final String INTERFACE_SEPARATOR = ":";

    private OsgiUtils() {
    }

    public static ServiceEndpointDescription getRemoteReference(ServiceReference sref, boolean matchAllNames) {
        String[] names = (String[])sref.getProperty("objectClass");
        if (names == null || names.length == 0) {
            return null;
        }
        HashMap<String, Object> userProperties = new HashMap<String, Object>();
        for (String key : sref.getPropertyKeys()) {
            if (!key.startsWith("osgi.remote")) continue;
            userProperties.put(key, sref.getProperty(key));
        }
        List<ServiceEndpointDescription> srefs = OsgiUtils.getRemoteReferences(sref.getBundle(), names, userProperties, matchAllNames);
        if (srefs.isEmpty()) {
            return new ServiceEndpointDescriptionImpl(Arrays.asList(names), userProperties);
        }
        return srefs.get(0);
    }

    public static List<ServiceEndpointDescription> getRemoteReferences(Bundle b, String[] names, Map<String, Object> userProperties, boolean matchAllNames) {
        List<Element> references = OsgiUtils.getAllDescriptionElements(b);
        ArrayList<ServiceEndpointDescription> srefs = new ArrayList<ServiceEndpointDescription>();
        Namespace ns = Namespace.getNamespace((String)REMOTE_SERVICES_NS);
        for (Element ref : references) {
            List<String> iNames = OsgiUtils.getProvidedInterfaces(ref.getChildren(PROVIDE_INTERFACE_ELEMENT, ns));
            if (!OsgiUtils.serviceNamesMatch(names, iNames, matchAllNames)) continue;
            Map<String, Object> remoteProps = OsgiUtils.getProperties(ref.getChildren(PROPERTY_ELEMENT, ns));
            remoteProps.putAll(userProperties);
            srefs.add(new ServiceEndpointDescriptionImpl(iNames, remoteProps));
        }
        return srefs;
    }

    public static List<ServiceEndpointDescription> getAllRemoteReferences(Bundle b) {
        List<Element> references = OsgiUtils.getAllDescriptionElements(b);
        ArrayList<ServiceEndpointDescription> srefs = new ArrayList<ServiceEndpointDescription>();
        Namespace ns = Namespace.getNamespace((String)REMOTE_SERVICES_NS);
        for (Element ref : references) {
            List<String> iNames = OsgiUtils.getProvidedInterfaces(ref.getChildren(PROVIDE_INTERFACE_ELEMENT, ns));
            Map<String, Object> remoteProps = OsgiUtils.getProperties(ref.getChildren(PROPERTY_ELEMENT, ns));
            srefs.add(new ServiceEndpointDescriptionImpl(iNames, remoteProps));
        }
        return srefs;
    }

    public static ServiceEndpointDescription[] flattenServiceDescription(ServiceEndpointDescription sd) {
        ServiceEndpointDescription[] list = null;
        int interfaceNameCount = sd.getProvidedInterfaces().size();
        if (sd.getProvidedInterfaces() == null || interfaceNameCount <= 1) {
            list = new ServiceEndpointDescription[]{sd};
        } else {
            String[] iNames = sd.getProvidedInterfaces().toArray(new String[interfaceNameCount]);
            list = new ServiceEndpointDescription[iNames.length];
            for (int i = 0; i < iNames.length; ++i) {
                Map<String, Object> props = OsgiUtils.excludeProperty(sd.getProperties(), "osgi.remote.interfaces");
                String[] keys = props.keySet().toArray(new String[props.size()]);
                for (int j = 0; j < keys.length; ++j) {
                    String iface;
                    int sep = keys[j].indexOf(INTERFACE_SEPARATOR);
                    if (sep <= -1) continue;
                    String value = (String)props.remove(keys[j]);
                    String root = keys[j].substring(0, sep);
                    String string = iface = sep + INTERFACE_SEPARATOR.length() < keys[j].length() ? keys[j].substring(sep + INTERFACE_SEPARATOR.length()) : "";
                    if (!iNames[i].equals(iface)) continue;
                    props.put(root, value);
                }
                list[i] = new ServiceEndpointDescriptionImpl(iNames[i], props);
            }
        }
        return list;
    }

    private static Map<String, Object> excludeProperty(Map properties, String exclude) {
        HashMap<String, Object> pruned = new HashMap<String, Object>();
        for (Object key : properties.keySet()) {
            if (key.equals(exclude)) continue;
            pruned.put((String)key, properties.get(key));
        }
        return pruned;
    }

    public static List<Element> getAllDescriptionElements(Bundle b) {
        Enumeration urls;
        String directory = null;
        Dictionary headers = b.getHeaders();
        if (headers != null) {
            directory = (String)headers.get(REMOTE_SERVICES_HEADER_NAME);
        }
        if (directory == null) {
            directory = REMOTE_SERVICES_DIRECTORY;
        }
        if ((urls = b.findEntries(directory.toString(), "*.xml", false)) == null) {
            return Collections.emptyList();
        }
        ArrayList<Element> elements = new ArrayList<Element>();
        while (urls.hasMoreElements()) {
            URL resourceURL = (URL)urls.nextElement();
            try {
                Document d = new SAXBuilder().build(resourceURL.openStream());
                Namespace ns = Namespace.getNamespace((String)REMOTE_SERVICES_NS);
                elements.addAll(d.getRootElement().getChildren(SERVICE_DESCRIPTION_ELEMENT, ns));
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "Problem parsing: " + resourceURL, ex);
            }
        }
        return elements;
    }

    private static boolean serviceNamesMatch(String[] names, List<String> iNames, boolean matchAllNames) {
        if (names == null || names.length == 0) {
            return false;
        }
        if (matchAllNames) {
            for (String name : names) {
                if (iNames.contains(name)) continue;
                return false;
            }
            return true;
        }
        for (String name : names) {
            if (!iNames.contains(name)) continue;
            return true;
        }
        return false;
    }

    public static void matchServiceDescriptions(List<ServiceEndpointDescription> sds, String interfaceName, Filter filter, boolean matchAll) {
        Iterator<ServiceEndpointDescription> it = sds.iterator();
        while (it.hasNext()) {
            ServiceEndpointDescription sd = it.next();
            if (filter == null || OsgiUtils.matchAgainstFilter(sd, interfaceName, filter, matchAll)) continue;
            it.remove();
        }
    }

    public static boolean matchAgainstFilter(ServiceEndpointDescription sd, String interfaceName, Filter filter, boolean matchAll) {
        Hashtable<Object, Object> props = new Hashtable<Object, Object>();
        for (Object key : sd.getPropertyKeys()) {
            if (!matchAll && !key.toString().startsWith("osgi.remote")) continue;
            ((Dictionary)props).put(key, sd.getProperty(key.toString()));
        }
        String[] interfaceNames = OsgiUtils.getProvidedInterfaces(sd, interfaceName);
        if (interfaceNames != null) {
            ((Dictionary)props).put("objectClass", interfaceNames);
        }
        return filter.match(props);
    }

    public static String[] getProvidedInterfaces(ServiceEndpointDescription sd, String interfaceName) {
        int interfaceNameCount = sd.getProvidedInterfaces().size();
        String[] interfaceNames = sd.getProvidedInterfaces().toArray(new String[interfaceNameCount]);
        if (interfaceName == null) {
            return interfaceNames;
        }
        for (String s : interfaceNames) {
            if (!s.equals(interfaceName)) continue;
            return new String[]{s};
        }
        return null;
    }

    public static Filter createFilter(BundleContext bc, String filterValue) {
        if (filterValue == null) {
            return null;
        }
        try {
            return bc.createFilter(filterValue);
        }
        catch (InvalidSyntaxException ex) {
            System.out.println("Invalid filter expression " + filterValue);
        }
        catch (Exception ex) {
            System.out.println("Problem creating a Filter from " + filterValue);
        }
        return null;
    }

    public static String[] parseIntents(String intentsSequence) {
        return intentsSequence == null ? new String[]{} : intentsSequence.split(" ");
    }

    public static String formatIntents(String[] intents) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String intent : intents) {
            if (first) {
                first = false;
            } else {
                sb.append(' ');
            }
            sb.append(intent);
        }
        return sb.toString();
    }

    private static Map<String, Object> getProperties(List<Element> elements) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (Element p : elements) {
            String key = p.getAttributeValue(PROPERTY_NAME_ATTRIBUTE);
            String value = p.getAttributeValue(PROPERTY_VALUE_ATTRIBUTE);
            if (value == null) {
                value = p.getTextTrim();
            }
            String iface = p.getAttributeValue("interface");
            if (key == null) continue;
            props.put(iface == null || iface.length() == 0 ? key : key + INTERFACE_SEPARATOR + iface, value);
        }
        return props;
    }

    private static List<String> getProvidedInterfaces(List<Element> elements) {
        ArrayList<String> names = new ArrayList<String>();
        for (Element p : elements) {
            String name = p.getAttributeValue("interface");
            if (name == null) continue;
            names.add(name);
        }
        return names;
    }

    public static <T> OsgiService<T> getOsgiService(BundleContext bc, Class<T> serviceClass) {
        block3: {
            try {
                Object o;
                ServiceReference sr = bc.getServiceReference(serviceClass.getName());
                if (sr != null && (o = bc.getService(sr)) != null && serviceClass.isAssignableFrom(o.getClass())) {
                    return new OsgiService<Object>(sr, o);
                }
            }
            catch (Exception ex) {
                if (!LOG.isLoggable(Level.FINE)) break block3;
                LOG.fine("Problem retrieving an OSGI service " + serviceClass.getName() + ", exception : " + ex.getMessage());
            }
        }
        return null;
    }

    public static IntentMap getIntentMap(BundleContext bundleContext) {
        IntentMap im = OsgiUtils.readIntentMap(bundleContext);
        if (im == null) {
            LOG.log(Level.FINE, "Using default intent map");
            im = new IntentMap();
            im.setIntents(new HashMap<String, Object>());
        }
        return im;
    }

    static IntentMap readIntentMap(BundleContext bundleContext) {
        ArrayList<String> springIntentLocations = new ArrayList<String>();
        for (String mapFile : INTENT_MAP) {
            if (bundleContext.getBundle().getResource(mapFile) == null) {
                LOG.info("Could not find intent map file " + mapFile);
                return null;
            }
            springIntentLocations.add("classpath:" + mapFile);
        }
        try {
            OsgiBundleXmlApplicationContext ctx = new OsgiBundleXmlApplicationContext(springIntentLocations.toArray(new String[0]));
            ctx.setPublishContextAsService(false);
            ctx.setBundleContext(bundleContext);
            ctx.refresh();
            LOG.fine("application context: " + ctx);
            IntentMap im = (IntentMap)ctx.getBean("intentMap");
            LOG.fine("retrieved intent map: " + im);
            return im;
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Intent map load failed: ", t);
            return null;
        }
    }

    public static Filter createFilterFromProperties(BundleContext bc, Dictionary properties) {
        if (properties == null || properties.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(&");
        Enumeration keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            String value = properties.get(key).toString();
            sb.append('(').append(key).append('=').append(value).append(')');
        }
        sb.append(')');
        return OsgiUtils.createFilter(bc, sb.toString());
    }

    public static boolean getBooleanProperty(ServiceEndpointDescription sd, String name) {
        Object value = sd.getProperty(name);
        return OsgiUtils.toBoolean(value);
    }

    public static boolean toBoolean(Object value) {
        return value instanceof Boolean && (Boolean)value != false || value instanceof String && Boolean.parseBoolean((String)value);
    }

    public static String getProperty(ServiceEndpointDescription sd, String name) {
        return OsgiUtils.getProperty(sd, name, String.class, null);
    }

    public static <T> T getProperty(ServiceEndpointDescription sd, String name, Class<T> type, T defaultValue) {
        Object o = sd.getProperty(name);
        if (o == null) {
            return defaultValue;
        }
        return (T)(type.isAssignableFrom(o.getClass()) ? o : null);
    }

    public static String[] getPublishableInterfaces(ServiceEndpointDescription sd, ServiceReference sref) {
        Object publishProperty = sd.getProperty("osgi.remote.interfaces");
        String[] actualInterfaces = (String[])sref.getProperty("objectClass");
        String[] publishableInterfaces = null;
        if (actualInterfaces != null && actualInterfaces.length > 0 && publishProperty != null) {
            if (INTERFACE_WILDCARD.equals(publishProperty)) {
                publishableInterfaces = actualInterfaces;
            } else {
                String[] requestedInterfaces = publishProperty instanceof String ? OsgiUtils.tokenize((String)publishProperty, ",") : (publishProperty instanceof String[] ? (String[])publishProperty : (publishProperty instanceof Collection ? ((Collection)publishProperty).toArray(new String[((Collection)publishProperty).size()]) : null));
                ArrayList<String> publishableList = new ArrayList<String>();
                for (int i = 0; requestedInterfaces != null && i < requestedInterfaces.length; ++i) {
                    if (OsgiUtils.contains(actualInterfaces, requestedInterfaces[i])) {
                        publishableList.add(requestedInterfaces[i]);
                        continue;
                    }
                    LOG.warning("ignoring publish interface, " + requestedInterfaces[i] + ", not exposed by service");
                }
                if (publishableList.size() > 0) {
                    publishableInterfaces = publishableList.toArray(new String[publishableList.size()]);
                }
            }
        }
        return publishableInterfaces;
    }

    private static String[] tokenize(String str, String delim) {
        StringTokenizer tokenizer = new StringTokenizer(str, delim);
        String[] tokens = new String[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            tokens[i] = tokenizer.nextToken();
            ++i;
        }
        return tokens;
    }

    private static boolean contains(String[] list, String member) {
        boolean found = false;
        for (int i = 0; i < list.length && !found; ++i) {
            found = member.equals(list[i]);
        }
        return found;
    }
}

