/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.xsdvalidation;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.cxf.common.logging.LogUtils;
import org.w3c.dom.Document;
import org.w3c.dom.ls.LSInput;

class DOMLSInput
implements LSInput {
    private static final Logger LOG = LogUtils.getL7dLogger(DOMLSInput.class);
    private String systemId;
    private String data;

    DOMLSInput(Document doc, String systemId) throws TransformerException {
        this.systemId = systemId;
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        DOMSource source = new DOMSource(doc);
        source.setSystemId(systemId);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        transformer.transform(source, result);
        this.data = writer.toString();
        LOG.fine(systemId + ": " + this.data);
    }

    public String getBaseURI() {
        return null;
    }

    public InputStream getByteStream() {
        return null;
    }

    public boolean getCertifiedText() {
        return false;
    }

    public Reader getCharacterStream() {
        return null;
    }

    public String getEncoding() {
        return "utf-8";
    }

    public String getPublicId() {
        return null;
    }

    public String getStringData() {
        return this.data;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setBaseURI(String baseURI) {
    }

    public void setByteStream(InputStream byteStream) {
    }

    public void setCertifiedText(boolean certifiedText) {
    }

    public void setCharacterStream(Reader characterStream) {
    }

    public void setEncoding(String encoding) {
    }

    public void setPublicId(String publicId) {
    }

    public void setStringData(String stringData) {
    }

    public void setSystemId(String systemId) {
    }
}

