/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wadlto.jaxrs;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.ext.codegen.SourceGenerator;
import org.apache.cxf.tools.common.AbstractCXFToolContainer;
import org.apache.cxf.tools.common.ClassUtils;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.toolspec.ToolSpec;
import org.apache.cxf.tools.common.toolspec.parser.BadUsageException;
import org.apache.cxf.tools.util.ClassCollector;
import org.apache.cxf.tools.util.URIParserUtil;
import org.apache.cxf.tools.wadlto.jaxb.CustomizationParser;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXRSContainer
extends AbstractCXFToolContainer {
    private static final Map<String, String> DEFAULT_JAVA_TYPE_MAP = Collections.singletonMap("org.w3._2005._08.addressing.EndpointReference", "javax.xml.ws.wsaddressing.W3CEndpointReference");
    private static final String TOOL_NAME = "wadl2java";
    private static final String EPR_TYPE_KEY = "org.w3._2005._08.addressing.EndpointReference";

    public JAXRSContainer(ToolSpec toolspec) throws Exception {
        super(TOOL_NAME, toolspec);
    }

    public void execute() throws ToolException {
        if (this.hasInfoOption()) {
            return;
        }
        this.buildToolContext();
        this.processWadl();
    }

    public void execute(boolean exitOnFinish) throws ToolException {
        try {
            if (this.getArgument() != null) {
                super.execute(exitOnFinish);
            }
            this.execute();
        }
        catch (ToolException ex) {
            if (ex.getCause() instanceof BadUsageException) {
                this.printUsageException(TOOL_NAME, (BadUsageException)ex.getCause());
            }
            throw ex;
        }
        catch (Exception ex) {
            throw new ToolException((Throwable)ex);
        }
        finally {
            this.tearDown();
        }
    }

    public void buildToolContext() {
        this.getContext();
        this.context.addParameters(this.getParametersMap(this.getArrayKeys()));
        if (this.context.get("outputdir") == null) {
            this.context.put("outputdir", (Object)".");
        }
        this.setPackageAndNamespaces();
    }

    public Set<String> getArrayKeys() {
        HashSet<String> set = new HashSet<String>();
        set.add("binding");
        set.add("schemaPackagename");
        set.add("schemaTypeMap");
        set.add("mediaTypeMap");
        return set;
    }

    private void processWadl() {
        File outDir = new File((String)this.context.get("outputdir"));
        String wadlURL = this.getAbsoluteWadlURL();
        String wadl = this.readWadl(wadlURL);
        SourceGenerator sg = new SourceGenerator();
        sg.setBus(this.getBus());
        boolean generateImpl = this.context.optionSet("impl");
        sg.setGenerateImplementation(generateImpl);
        if (generateImpl) {
            sg.setGenerateInterfaces(this.context.optionSet("interface"));
        }
        sg.setPackageName((String)this.context.get("packagename"));
        sg.setResourceName((String)this.context.get("resourcename"));
        String wadlNs = (String)this.context.get("wadlNamespace");
        if (wadlNs != null) {
            sg.setWadlNamespace(wadlNs);
        }
        sg.setSupportMultipleXmlReps(this.context.optionSet("supportMultipleXmlReps"));
        sg.setWadlPath(wadlURL);
        CustomizationParser parser = new CustomizationParser(this.context);
        parser.parse(this.context);
        List<InputSource> bindingFiles = parser.getJaxbBindings();
        sg.setBindingFiles(bindingFiles);
        sg.setCompilerArgs(parser.getCompilerArgs());
        List<InputSource> schemaPackageFiles = parser.getSchemaPackageFiles();
        sg.setSchemaPackageFiles(schemaPackageFiles);
        sg.setSchemaPackageMap(this.context.getNamespacePackageMap());
        sg.setJavaTypeMap(DEFAULT_JAVA_TYPE_MAP);
        sg.setSchemaTypeMap(this.getSchemaTypeMap());
        sg.setMediaTypeMap(this.getMediaTypeMap());
        sg.setGenerateEnums(this.context.optionSet("generateEnums"));
        sg.setInheritResourceParams(this.context.optionSet("inheritResourceParams"));
        sg.setSkipSchemaGeneration(this.context.optionSet("notypes"));
        boolean noVoidForEmptyResponses = this.context.optionSet("noVoidForEmptyResponses");
        if (noVoidForEmptyResponses) {
            sg.setUseVoidForEmptyResponses(false);
        }
        String codeType = this.context.optionSet("types") ? "grammar" : "proxy";
        sg.generateSource(wadl, outDir, codeType);
        if (this.context.optionSet("compile")) {
            ClassCollector collector = this.createClassCollector();
            List generatedServiceClasses = sg.getGeneratedServiceClasses();
            for (String className : generatedServiceClasses) {
                int index = className.lastIndexOf(".");
                collector.addServiceClassName(className.substring(0, index), className.substring(index + 1), className);
            }
            List generatedTypeClasses = sg.getGeneratedTypeClasses();
            for (String className : generatedTypeClasses) {
                int index = className.lastIndexOf(".");
                collector.addTypesClassName(className.substring(0, index), className.substring(index + 1), className);
            }
            this.context.put(ClassCollector.class, (Object)collector);
            new ClassUtils().compile(this.context);
        }
    }

    protected String readWadl(String wadlURI) {
        try {
            URL url = new URL(wadlURI);
            InputStreamReader reader = new InputStreamReader(url.openStream(), "UTF-8");
            return IOUtils.toString((Reader)reader);
        }
        catch (IOException e) {
            throw new ToolException((Throwable)e);
        }
    }

    protected String getAbsoluteWadlURL() {
        String wadlURL = (String)this.context.get("wadl");
        String absoluteWadlURL = URIParserUtil.getAbsoluteURI((String)wadlURL);
        this.context.put("wadl", (Object)absoluteWadlURL);
        return absoluteWadlURL;
    }

    private void setPackageAndNamespaces() {
        String[] schemaPackageNamespaces = new String[]{};
        Object value = this.context.get("schemaPackagename");
        if (value != null) {
            String[] stringArray;
            if (value instanceof String) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = (String)value;
            } else {
                stringArray = (String[])value;
            }
            schemaPackageNamespaces = stringArray;
        }
        for (int i = 0; i < schemaPackageNamespaces.length; ++i) {
            int pos = schemaPackageNamespaces[i].indexOf("=");
            String packagename = schemaPackageNamespaces[i];
            if (pos != -1) {
                String ns = schemaPackageNamespaces[i].substring(0, pos);
                packagename = schemaPackageNamespaces[i].substring(pos + 1);
                this.context.addNamespacePackageMap(ns, packagename);
                continue;
            }
            this.context.put("schemaPackagename", (Object)packagename);
        }
    }

    private Map<String, String> getSchemaTypeMap() {
        return this.getMap("schemaTypeMap");
    }

    private Map<String, String> getMediaTypeMap() {
        return this.getMap("mediaTypeMap");
    }

    private Map<String, String> getMap(String parameterName) {
        String[] typeToClasses = new String[]{};
        Object value = this.context.get(parameterName);
        if (value != null) {
            String[] stringArray;
            if (value instanceof String) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = (String)value;
            } else {
                stringArray = (String[])value;
            }
            typeToClasses = stringArray;
        }
        HashMap<String, String> typeMap = new HashMap<String, String>();
        for (int i = 0; i < typeToClasses.length; ++i) {
            int pos = typeToClasses[i].indexOf("=");
            if (pos == -1) continue;
            String type = typeToClasses[i].substring(0, pos);
            String clsName = typeToClasses[i].substring(pos + 1);
            typeMap.put(type, clsName);
        }
        return typeMap;
    }
}

