/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.asyncclient.hc5;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.SystemPropertyAction;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.HTTPConduitFactory;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.apache.cxf.transport.http.asyncclient.hc5.AsyncHTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.SystemDefaultDnsResolver;
import org.apache.hc.client5.http.cookie.BasicCookieStore;
import org.apache.hc.client5.http.cookie.Cookie;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.impl.DefaultSchemePortResolver;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.protocol.RedirectStrategy;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.pool.PoolConcurrencyPolicy;
import org.apache.hc.core5.pool.PoolReusePolicy;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.IOReactorStatus;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

@NoJSR250Annotations
public class AsyncHTTPConduitFactory
implements HTTPConduitFactory {
    public static final String TCP_NODELAY = "org.apache.cxf.transport.http.async.TCP_NODELAY";
    public static final String SO_KEEPALIVE = "org.apache.cxf.transport.http.async.SO_KEEPALIVE";
    public static final String SO_LINGER = "org.apache.cxf.transport.http.async.SO_LINGER";
    public static final String SO_TIMEOUT = "org.apache.cxf.transport.http.async.SO_TIMEOUT";
    public static final String MAX_CONNECTIONS = "org.apache.cxf.transport.http.async.MAX_CONNECTIONS";
    public static final String MAX_PER_HOST_CONNECTIONS = "org.apache.cxf.transport.http.async.MAX_PER_HOST_CONNECTIONS";
    public static final String CONNECTION_TTL = "org.apache.cxf.transport.http.async.CONNECTION_TTL";
    public static final String CONNECTION_MAX_IDLE = "org.apache.cxf.transport.http.async.CONNECTION_MAX_IDLE";
    public static final String THREAD_COUNT = "org.apache.cxf.transport.http.async.ioThreadCount";
    public static final String SELECT_INTERVAL = "org.apache.cxf.transport.http.async.selectInterval";
    public static final String USE_POLICY = "org.apache.cxf.transport.http.async.usePolicy";
    private static final Logger LOG = LogUtils.getL7dLogger(AsyncHTTPConduitFactory.class);
    private volatile Map<HTTPClientPolicy, AsyncClient> clients = new ConcurrentHashMap<HTTPClientPolicy, AsyncClient>();
    private boolean isShutdown;
    private UseAsyncPolicy policy;
    private int maxConnections = 5000;
    private int maxPerRoute = 1000;
    private int connectionTTL = 60000;
    private int connectionMaxIdle = 60000;
    private int ioThreadCount = IOReactorConfig.DEFAULT.getIoThreadCount();
    private long selectInterval = IOReactorConfig.DEFAULT.getSelectInterval().toMilliseconds();
    private int soLinger = IOReactorConfig.DEFAULT.getSoLinger().toMillisecondsIntBound();
    private int soTimeout = IOReactorConfig.DEFAULT.getSoTimeout().toMillisecondsIntBound();
    private boolean soKeepalive = IOReactorConfig.DEFAULT.isSoKeepalive();
    private boolean tcpNoDelay = true;

    AsyncHTTPConduitFactory() {
    }

    public AsyncHTTPConduitFactory(Map<String, Object> conf) {
        this();
        this.setProperties(conf);
    }

    public AsyncHTTPConduitFactory(Bus b) {
        this();
        this.addListener(b);
        this.setProperties(b.getProperties());
    }

    public UseAsyncPolicy getUseAsyncPolicy() {
        return this.policy;
    }

    public void update(Map<String, Object> props) {
        if (this.setProperties(props) && !this.clients.isEmpty()) {
            this.restartReactor();
        }
    }

    private void restartReactor() {
        Map<HTTPClientPolicy, AsyncClient> clients2 = this.clients;
        this.clients = new ConcurrentHashMap<HTTPClientPolicy, AsyncClient>();
        AsyncHTTPConduitFactory.shutdown(clients2);
    }

    private boolean setProperties(Map<String, Object> s) {
        if (s == null) {
            return false;
        }
        Object st = s.get(USE_POLICY);
        if (st == null) {
            st = SystemPropertyAction.getPropertyOrNull((String)USE_POLICY);
        }
        this.policy = UseAsyncPolicy.getPolicy(st);
        this.maxConnections = this.getInt(s.get(MAX_CONNECTIONS), this.maxConnections);
        this.connectionTTL = this.getInt(s.get(CONNECTION_TTL), this.connectionTTL);
        this.connectionMaxIdle = this.getInt(s.get(CONNECTION_MAX_IDLE), this.connectionMaxIdle);
        this.maxPerRoute = this.getInt(s.get(MAX_PER_HOST_CONNECTIONS), this.maxPerRoute);
        if (!this.clients.isEmpty()) {
            for (Map.Entry<HTTPClientPolicy, AsyncClient> entry : this.clients.entrySet()) {
                PoolingAsyncClientConnectionManager connectionManager = entry.getValue().getConnectionManager();
                connectionManager.setMaxTotal(this.maxConnections);
                connectionManager.setDefaultMaxPerRoute(this.maxPerRoute);
            }
        }
        boolean changed = false;
        int i = this.ioThreadCount;
        this.ioThreadCount = this.getInt(s.get(THREAD_COUNT), Runtime.getRuntime().availableProcessors());
        changed |= i != this.ioThreadCount;
        long l = this.selectInterval;
        this.selectInterval = this.getInt(s.get(SELECT_INTERVAL), 1000);
        changed |= l != this.selectInterval;
        i = this.soLinger;
        this.soLinger = this.getInt(s.get(SO_LINGER), -1);
        changed |= i != this.soLinger;
        i = this.soTimeout;
        this.soTimeout = this.getInt(s.get(SO_TIMEOUT), 0);
        changed |= i != this.soTimeout;
        boolean b = this.tcpNoDelay;
        this.tcpNoDelay = this.getBoolean(s.get(TCP_NODELAY), true);
        changed |= b != this.tcpNoDelay;
        b = this.soKeepalive;
        this.soKeepalive = this.getBoolean(s.get(SO_KEEPALIVE), false);
        return changed |= b != this.soKeepalive;
    }

    private int getInt(Object s, int defaultv) {
        int i = defaultv;
        if (s instanceof String) {
            i = Integer.parseInt((String)s);
        } else if (s instanceof Number) {
            i = ((Number)s).intValue();
        }
        if (i == -1) {
            i = defaultv;
        }
        return i;
    }

    private boolean getBoolean(Object s, boolean defaultv) {
        if (s instanceof String) {
            return Boolean.parseBoolean((String)s);
        }
        if (s instanceof Boolean) {
            return (Boolean)s;
        }
        return defaultv;
    }

    public boolean isShutdown() {
        return this.isShutdown;
    }

    public HTTPConduit createConduit(HTTPTransportFactory f, Bus bus, EndpointInfo localInfo, EndpointReferenceType target) throws IOException {
        return this.createConduit(bus, localInfo, target);
    }

    public HTTPConduit createConduit(Bus bus, EndpointInfo localInfo, EndpointReferenceType target) throws IOException {
        if (this.isShutdown) {
            return null;
        }
        return new AsyncHTTPConduit(bus, localInfo, target, this);
    }

    public void shutdown() {
        AsyncHTTPConduitFactory.shutdown(this.clients);
        this.clients.clear();
        this.isShutdown = true;
    }

    private static void shutdown(Map<HTTPClientPolicy, AsyncClient> clients) {
        if (!clients.isEmpty()) {
            for (Map.Entry<HTTPClientPolicy, AsyncClient> entry : clients.entrySet()) {
                AsyncHTTPConduitFactory.shutdown(entry.getValue().getClient());
                entry.getValue().getConnectionManager().close();
            }
        }
    }

    private static void shutdown(CloseableHttpAsyncClient client) {
        try {
            client.close();
        }
        catch (IOException ex) {
            LOG.warning(ex.getMessage());
        }
    }

    private void addListener(Bus b) {
        BusLifeCycleManager manager = (BusLifeCycleManager)b.getExtension(BusLifeCycleManager.class);
        if (manager != null) {
            manager.registerLifeCycleListener(new BusLifeCycleListener(){

                public void initComplete() {
                }

                public void preShutdown() {
                    AsyncHTTPConduitFactory.this.shutdown();
                }

                public void postShutdown() {
                }
            });
        }
    }

    public synchronized void setupNIOClient(HTTPClientPolicy clientPolicy, TlsStrategy tlsStrategy) {
        AsyncClient client = this.clients.get(clientPolicy);
        if (client != null) {
            return;
        }
        this.clients.computeIfAbsent(clientPolicy, key -> this.createNIOClient((HTTPClientPolicy)key, tlsStrategy));
    }

    private AsyncClient createNIOClient(HTTPClientPolicy clientPolicy, TlsStrategy tlsStrategy) {
        IOReactorConfig config = IOReactorConfig.custom().setIoThreadCount(this.ioThreadCount).setSelectInterval(TimeValue.ofMilliseconds((long)this.selectInterval)).setSoLinger(TimeValue.ofMilliseconds((long)this.soLinger)).setSoTimeout(Timeout.ofMilliseconds((long)this.soTimeout)).setSoKeepAlive(this.soKeepalive).setTcpNoDelay(this.tcpNoDelay).build();
        Registry tlsLookupStrategy = RegistryBuilder.create().register("https", (Object)(tlsStrategy != null ? tlsStrategy : DefaultClientTlsStrategy.getSystemDefault())).build();
        PoolingAsyncClientConnectionManager connectionManager = new PoolingAsyncClientConnectionManager((Lookup)tlsLookupStrategy, PoolConcurrencyPolicy.STRICT, PoolReusePolicy.LIFO, TimeValue.ofMilliseconds((long)this.connectionTTL), (SchemePortResolver)DefaultSchemePortResolver.INSTANCE, (DnsResolver)SystemDefaultDnsResolver.INSTANCE);
        connectionManager.setDefaultMaxPerRoute(this.maxPerRoute);
        connectionManager.setMaxTotal(this.maxConnections);
        RedirectStrategy redirectStrategy = new RedirectStrategy(){

            public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
                return false;
            }

            public URI getLocationURI(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
                return null;
            }
        };
        HttpAsyncClientBuilder httpAsyncClientBuilder = HttpAsyncClients.custom().setConnectionManager((AsyncClientConnectionManager)connectionManager).setRedirectStrategy(redirectStrategy).setDefaultCookieStore((CookieStore)new BasicCookieStore(){
            private static final long serialVersionUID = 1L;

            public void addCookie(Cookie cookie) {
            }
        });
        this.adaptClientBuilder(httpAsyncClientBuilder);
        CloseableHttpAsyncClient client = httpAsyncClientBuilder.setIOReactorConfig(config).build();
        client.start();
        new CloseIdleConnectionThread(connectionManager, client).start();
        return new AsyncClient(connectionManager, client);
    }

    protected void adaptClientBuilder(HttpAsyncClientBuilder httpAsyncClientBuilder) {
    }

    public CloseableHttpAsyncClient createClient(AsyncHTTPConduit c, TlsStrategy tlsStrategy) throws IOException {
        return this.clients.computeIfAbsent(c.getClient(), key -> this.createNIOClient((HTTPClientPolicy)key, tlsStrategy)).getClient();
    }

    int getMaxConnections() {
        return this.maxConnections;
    }

    public void close(HTTPClientPolicy clientPolicy) {
        AsyncClient client = this.clients.remove(clientPolicy);
        if (client != null) {
            AsyncHTTPConduitFactory.shutdown(client.getClient());
            client.getConnectionManager().close();
        }
    }

    public static enum UseAsyncPolicy {
        ALWAYS,
        ASYNC_ONLY,
        NEVER;


        public static UseAsyncPolicy getPolicy(Object st) {
            if (st instanceof UseAsyncPolicy) {
                return (UseAsyncPolicy)((Object)st);
            }
            if (st instanceof String) {
                String s = ((String)st).toUpperCase();
                if ("ALWAYS".equals(s)) {
                    return ALWAYS;
                }
                if ("NEVER".equals(s)) {
                    return NEVER;
                }
                if ("ASYNC_ONLY".equals(s)) {
                    return ASYNC_ONLY;
                }
                st = Boolean.parseBoolean(s);
            }
            if (st instanceof Boolean) {
                return (Boolean)st != false ? ALWAYS : NEVER;
            }
            return ASYNC_ONLY;
        }
    }

    private static class AsyncClient {
        private final PoolingAsyncClientConnectionManager connectionManager;
        private final CloseableHttpAsyncClient client;

        AsyncClient(PoolingAsyncClientConnectionManager connectionManager, CloseableHttpAsyncClient client) {
            this.connectionManager = connectionManager;
            this.client = client;
        }

        public CloseableHttpAsyncClient getClient() {
            return this.client;
        }

        public PoolingAsyncClientConnectionManager getConnectionManager() {
            return this.connectionManager;
        }
    }

    public class CloseIdleConnectionThread
    extends Thread {
        private final PoolingAsyncClientConnectionManager connMgr;
        private final CloseableHttpAsyncClient client;

        public CloseIdleConnectionThread(PoolingAsyncClientConnectionManager connMgr, CloseableHttpAsyncClient client) {
            super("CXFCloseIdleConnectionThread");
            this.connMgr = connMgr;
            this.client = client;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            long nextIdleCheck = System.currentTimeMillis() + (long)AsyncHTTPConduitFactory.this.connectionMaxIdle;
            try {
                while (this.client.getStatus() == IOReactorStatus.ACTIVE) {
                    CloseIdleConnectionThread closeIdleConnectionThread = this;
                    synchronized (closeIdleConnectionThread) {
                        CloseIdleConnectionThread.sleep(AsyncHTTPConduitFactory.this.selectInterval);
                        if (AsyncHTTPConduitFactory.this.connectionTTL == 0 && AsyncHTTPConduitFactory.this.connectionMaxIdle > 0 && System.currentTimeMillis() >= nextIdleCheck) {
                            nextIdleCheck += (long)AsyncHTTPConduitFactory.this.connectionMaxIdle;
                            this.connMgr.closeIdle(TimeValue.ofMilliseconds((long)AsyncHTTPConduitFactory.this.connectionMaxIdle));
                        }
                    }
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

