/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.x.discovery.details;

import java.io.IOException;
import java.util.concurrent.ThreadFactory;
import org.apache.curator.x.discovery.ProviderStrategy;
import org.apache.curator.x.discovery.ServiceCache;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.ServiceProvider;
import org.apache.curator.x.discovery.details.ServiceDiscoveryImpl;

public class ServiceProviderImpl<T>
implements ServiceProvider<T> {
    private final ServiceCache<T> cache;
    private final ServiceDiscoveryImpl<T> discovery;
    private final ProviderStrategy<T> providerStrategy;

    public ServiceProviderImpl(ServiceDiscoveryImpl<T> discovery, String serviceName, ProviderStrategy<T> providerStrategy, ThreadFactory threadFactory) {
        this.discovery = discovery;
        this.providerStrategy = providerStrategy;
        this.cache = discovery.serviceCacheBuilder().name(serviceName).threadFactory(threadFactory).build();
    }

    @Override
    public void start() throws Exception {
        this.cache.start();
        this.discovery.providerOpened(this);
    }

    @Override
    public void close() throws IOException {
        this.discovery.providerClosed(this);
        this.cache.close();
    }

    @Override
    public ServiceInstance<T> getInstance() throws Exception {
        return this.providerStrategy.getInstance(this.cache);
    }
}

