/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.x.async.modeled.details;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.curator.x.async.modeled.NodeName;
import org.apache.curator.x.async.modeled.ZPath;
import org.apache.zookeeper.common.PathUtils;

public class ZPathImpl
implements ZPath {
    public static final ZPath root = new ZPathImpl(Collections.singletonList("/"), null);
    private final List<String> nodes;
    private final boolean isResolved;
    private volatile String fullPath = null;
    private volatile ZPath parent = null;
    private volatile Pattern schema = null;

    public static ZPath parse(String fullPath, UnaryOperator<String> nameFilter) {
        return ZPathImpl.parseInternal(fullPath, nameFilter);
    }

    private static ZPathImpl parseInternal(String fullPath, UnaryOperator<String> nameFilter) {
        ImmutableList nodes = ImmutableList.builder().add((Object)"/").addAll((Iterable)Splitter.on((String)"/").omitEmptyStrings().splitToList((CharSequence)fullPath).stream().map(nameFilter).collect(Collectors.toList())).build();
        nodes.forEach(ZPathImpl::validate);
        return new ZPathImpl((List<String>)nodes, null);
    }

    public static ZPath from(String[] names) {
        return ZPathImpl.from(null, Arrays.asList(names));
    }

    public static ZPath from(List<String> names) {
        return ZPathImpl.from(null, names);
    }

    public static ZPath from(ZPath base, String[] names) {
        return ZPathImpl.from(base, Arrays.asList(names));
    }

    public static ZPath from(ZPath base, List<String> names) {
        names = Objects.requireNonNull(names, "names cannot be null");
        names.forEach(ZPathImpl::validate);
        ImmutableList.Builder builder = ImmutableList.builder();
        if (base != null) {
            if (base instanceof ZPathImpl) {
                builder.addAll(((ZPathImpl)base).nodes);
            } else {
                builder.addAll((Iterable)Splitter.on((String)"/").omitEmptyStrings().splitToList((CharSequence)base.fullPath()));
            }
        } else {
            builder.add((Object)"/");
        }
        ImmutableList nodes = builder.addAll(names).build();
        return new ZPathImpl((List<String>)nodes, null);
    }

    @Override
    public ZPath child(Object child) {
        return new ZPathImpl(this.nodes, NodeName.nameFrom(child));
    }

    @Override
    public ZPath parent() {
        this.checkRootAccess();
        if (this.parent == null) {
            this.parent = new ZPathImpl(this.nodes.subList(0, this.nodes.size() - 1), null);
        }
        return this.parent;
    }

    @Override
    public boolean isRoot() {
        return this.nodes.size() == 1;
    }

    @Override
    public boolean startsWith(ZPath path) {
        ZPathImpl rhs = path instanceof ZPathImpl ? (ZPathImpl)path : ZPathImpl.parseInternal(path.fullPath(), s -> s);
        return this.nodes.size() >= rhs.nodes.size() && this.nodes.subList(0, rhs.nodes.size()).equals(rhs.nodes);
    }

    @Override
    public Pattern toSchemaPathPattern() {
        if (this.schema == null) {
            this.schema = Pattern.compile(this.buildFullPath(s -> ZPathImpl.isParameter(s) ? ".*" : s));
        }
        return this.schema;
    }

    @Override
    public String fullPath() {
        this.checkResolved();
        if (this.fullPath == null) {
            this.fullPath = this.buildFullPath(s -> s);
        }
        return this.fullPath;
    }

    @Override
    public String nodeName() {
        return this.nodes.get(this.nodes.size() - 1);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZPathImpl zPaths = (ZPathImpl)o;
        return this.nodes.equals(zPaths.nodes);
    }

    public int hashCode() {
        return this.nodes.hashCode();
    }

    public String toString() {
        return this.nodes.subList(1, this.nodes.size()).stream().map(name -> ZPathImpl.isParameter(name) ? name.substring(1) : name).collect(Collectors.joining("/", "/", ""));
    }

    @Override
    public ZPath resolved(List<Object> parameters) {
        Iterator<Object> iterator = parameters.iterator();
        List<String> nodeNames = this.nodes.stream().map(name -> {
            if (ZPathImpl.isParameter(name) && iterator.hasNext()) {
                return NodeName.nameFrom(iterator.next());
            }
            return name;
        }).collect(Collectors.toList());
        return new ZPathImpl(nodeNames, null);
    }

    @Override
    public boolean isResolved() {
        return this.isResolved;
    }

    private static boolean isParameter(String name) {
        return name.length() > 1 && name.startsWith("/");
    }

    private ZPathImpl(List<String> nodes, String child) {
        ImmutableList.Builder builder = ImmutableList.builder().addAll(nodes);
        if (child != null) {
            ZPathImpl.validate(child);
            builder.add((Object)child);
        }
        this.nodes = builder.build();
        this.isResolved = this.nodes.stream().noneMatch(ZPathImpl::isParameter);
    }

    private void checkRootAccess() {
        if (this.isRoot()) {
            throw new NoSuchElementException("The root has no parent");
        }
    }

    private void checkResolved() {
        if (!this.isResolved) {
            throw new IllegalStateException("This ZPath has not been resolved: " + this.toString());
        }
    }

    private static void validate(String nodeName) {
        if (ZPathImpl.isParameter(Objects.requireNonNull(nodeName, "nodeName cannot be null"))) {
            return;
        }
        if (nodeName.equals("/")) {
            return;
        }
        PathUtils.validatePath((String)("/" + nodeName));
    }

    private String buildFullPath(UnaryOperator<String> filter) {
        boolean addSeparator = false;
        StringBuilder str = new StringBuilder();
        int size = this.nodes.size();
        boolean parameterIndex = false;
        for (int i = 0; i < size; ++i) {
            if (i > 1) {
                str.append("/");
            }
            str.append((String)filter.apply(this.nodes.get(i)));
        }
        return str.toString();
    }
}

