/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.x.async.modeled;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.apache.curator.framework.api.CuratorEvent;
import org.apache.curator.framework.api.UnhandledErrorListener;
import org.apache.curator.x.async.AsyncCuratorFramework;
import org.apache.curator.x.async.WatchMode;
import org.apache.curator.x.async.modeled.ModelSpec;
import org.apache.curator.x.async.modeled.ModeledFramework;
import org.apache.curator.x.async.modeled.ModeledOptions;
import org.apache.curator.x.async.modeled.details.ModeledFrameworkImpl;
import org.apache.zookeeper.WatchedEvent;

public class ModeledFrameworkBuilder<T> {
    private AsyncCuratorFramework client;
    private ModelSpec<T> modelSpec;
    private WatchMode watchMode;
    private UnaryOperator<WatchedEvent> watcherFilter;
    private UnhandledErrorListener unhandledErrorListener;
    private UnaryOperator<CuratorEvent> resultFilter;
    private Set<ModeledOptions> modeledOptions;

    public ModeledFramework<T> build() {
        return ModeledFrameworkImpl.build(this.client, this.modelSpec, this.watchMode, this.watcherFilter, this.unhandledErrorListener, this.resultFilter, this.modeledOptions);
    }

    public ModeledFrameworkBuilder<T> watched() {
        this.watchMode = WatchMode.stateChangeAndSuccess;
        return this;
    }

    public ModeledFrameworkBuilder<T> watched(WatchMode watchMode) {
        this.watchMode = watchMode;
        return this;
    }

    public ModeledFrameworkBuilder<T> watched(WatchMode watchMode, UnaryOperator<WatchedEvent> watcherFilter) {
        this.watchMode = watchMode;
        this.watcherFilter = watcherFilter;
        return this;
    }

    public ModeledFrameworkBuilder<T> withUnhandledErrorListener(UnhandledErrorListener unhandledErrorListener) {
        this.unhandledErrorListener = unhandledErrorListener;
        return this;
    }

    public ModeledFrameworkBuilder<T> withResultFilter(UnaryOperator<CuratorEvent> resultFilter) {
        this.resultFilter = resultFilter;
        return this;
    }

    public ModeledFrameworkBuilder<T> withModelSpec(ModelSpec<T> modelSpec) {
        this.modelSpec = Objects.requireNonNull(modelSpec, "modelSpec cannot be null");
        return this;
    }

    public ModeledFrameworkBuilder<T> withClient(AsyncCuratorFramework client) {
        this.client = Objects.requireNonNull(client, "client cannot be null");
        return this;
    }

    public ModeledFrameworkBuilder<T> withOptions(Set<ModeledOptions> modeledOptions) {
        this.modeledOptions = ImmutableSet.copyOf((Collection)Objects.requireNonNull(modeledOptions, "client cannot be null"));
        return this;
    }

    ModeledFrameworkBuilder() {
        this.modeledOptions = Collections.singleton(ModeledOptions.ignoreMissingNodesForChildren);
    }

    ModeledFrameworkBuilder(AsyncCuratorFramework client, ModelSpec<T> modelSpec) {
        this.client = Objects.requireNonNull(client, "client cannot be null");
        this.modelSpec = Objects.requireNonNull(modelSpec, "modelSpec cannot be null");
        this.modeledOptions = Collections.singleton(ModeledOptions.ignoreMissingNodesForChildren);
    }
}

