/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.x.async.details;

import com.google.common.base.Preconditions;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.UnaryOperator;
import org.apache.curator.x.async.AsyncEventException;
import org.apache.curator.x.async.WatchMode;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;

class InternalWatcher
implements Watcher {
    private final WatchMode watchMode;
    private final UnaryOperator<WatchedEvent> watcherFilter;
    private volatile CompletableFuture<WatchedEvent> future = new CompletableFuture();

    InternalWatcher(WatchMode watchMode, UnaryOperator<WatchedEvent> watcherFilter) {
        this.watchMode = watchMode;
        this.watcherFilter = watcherFilter;
    }

    CompletableFuture<WatchedEvent> getFuture() {
        return this.future;
    }

    public void process(WatchedEvent event) {
        final WatchedEvent localEvent = this.watcherFilter != null ? (WatchedEvent)this.watcherFilter.apply(event) : event;
        switch (localEvent.getState()) {
            default: {
                if (this.watchMode == WatchMode.stateChangeOnly || localEvent.getType() == Watcher.Event.EventType.None || this.future.complete(localEvent)) break;
                this.future.obtrudeValue(localEvent);
                break;
            }
            case Disconnected: 
            case AuthFailed: 
            case Expired: {
                if (this.watchMode == WatchMode.successOnly) break;
                AsyncEventException exception = new AsyncEventException(){
                    private final AtomicBoolean isReset = new AtomicBoolean(false);

                    @Override
                    public Watcher.Event.KeeperState getKeeperState() {
                        return localEvent.getState();
                    }

                    @Override
                    public CompletionStage<WatchedEvent> reset() {
                        Preconditions.checkState((boolean)this.isReset.compareAndSet(false, true), (Object)"Already reset");
                        InternalWatcher.this.future = new CompletableFuture();
                        return InternalWatcher.this.future;
                    }
                };
                this.future.completeExceptionally(exception);
            }
        }
    }
}

