/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dependency.parser.util;

import com.googlecode.clearnlp.dependency.DEPNode;
import com.googlecode.clearnlp.dependency.DEPTree;
import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.dependency.parser.util.DependencyUtility;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.syntax.ConllDependencyNode;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.log4j.Logger;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public class ClearDependencyUtility
extends DependencyUtility {
    public Logger logger = Logger.getLogger((String)this.getClass().getName());

    public static ArrayList<ConllDependencyNode> convert(JCas jcas, DEPTree clearTree, Sentence sentence, List<BaseToken> tokens) {
        int i;
        ArrayList<ConllDependencyNode> uimaNodes = new ArrayList<ConllDependencyNode>(tokens.size() + 1);
        int rootBegin = tokens.get(0).getBegin();
        int rootEnd = tokens.get(tokens.size() - 1).getEnd();
        uimaNodes.add(0, new ConllDependencyNode(jcas, rootBegin, rootEnd));
        for (i = 1; i < clearTree.size(); ++i) {
            int nodeBegin = tokens.get(i - 1).getBegin();
            int nodeEnd = tokens.get(i - 1).getEnd();
            ConllDependencyNode uimaNode = new ConllDependencyNode(jcas, nodeBegin, nodeEnd);
            uimaNodes.add(i, uimaNode);
        }
        for (i = 1; i < clearTree.size(); ++i) {
            DEPNode clearNode = clearTree.get(i);
            ConllDependencyNode uimaNode = uimaNodes.get(i);
            uimaNode.setId(clearNode.id);
            uimaNode.setForm(clearNode.form);
            uimaNode.setLemma(clearNode.lemma);
            uimaNode.setCpostag(clearNode.pos);
            uimaNode.setPostag(clearNode.pos);
            uimaNode.setFeats("_");
            uimaNode.setHead(uimaNodes.get(clearNode.getHead().id));
            uimaNode.setDeprel(clearNode.getLabel());
            uimaNode.setPhead(null);
            uimaNode.setPdeprel("_");
        }
        return uimaNodes;
    }

    public static boolean equalCoverage(Annotation annot1, Annotation annot2) {
        return annot1.getBegin() == annot2.getBegin() && annot1.getEnd() == annot2.getEnd() && annot1.getCoveredText() == annot2.getCoveredText();
    }
}

