/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dependency.parser.ae;

import com.googlecode.clearnlp.component.AbstractComponent;
import com.googlecode.clearnlp.dependency.DEPFeat;
import com.googlecode.clearnlp.dependency.DEPNode;
import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.engine.EngineGetter;
import com.googlecode.clearnlp.morphology.AbstractMPAnalyzer;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.core.resource.FileLocator;
import org.apache.ctakes.dependency.parser.util.ClearDependencyUtility;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.syntax.ConllDependencyNode;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.uimafit.component.JCasAnnotator_ImplBase;
import org.uimafit.descriptor.ConfigurationParameter;
import org.uimafit.descriptor.TypeCapability;
import org.uimafit.util.JCasUtil;

@TypeCapability(inputs={"org.apache.ctakes.typesystem.type.syntax.BaseToken:partOfSpeech", "org.apache.ctakes.typesystem.type.syntax.BaseToken:normalizedForm", "org.apache.ctakes.typesystem.type.syntax.BaseToken:tokenNumber", "org.apache.ctakes.typesystem.type.syntax.BaseToken:end", "org.apache.ctakes.typesystem.type.syntax.BaseToken:begin"})
public class ClearNLPDependencyParserAE
extends JCasAnnotator_ImplBase {
    final String language = "en";
    public Logger logger = Logger.getLogger((String)((Object)((Object)this)).getClass().getName());
    public static final String DEFAULT_MODEL_FILE_NAME = "org/apache/ctakes/dependency/parser/models/dependency/mayo-en-dep-1.3.0.jar";
    public static final String ENG_LEMMATIZER_DATA_FILE = "org/apache/ctakes/dependency/parser/models/lemmatizer/dictionary-1.3.1.jar";
    public static final String PARAM_PARSER_MODEL_FILE_NAME = "ParserModelFileName";
    @ConfigurationParameter(name="ParserModelFileName", description="This parameter provides the file name of the dependency parser model required by the factory method provided by ClearNLPUtil.  If not specified, this analysis engine will use a default model from the resources directory")
    protected URI parserModelUri;
    public static final String PARAM_LEMMATIZER_DATA_FILE = "LemmatizerDataFile";
    @ConfigurationParameter(name="LemmatizerDataFile", description="This parameter provides the data file required for the MorphEnAnalyzer. If not specified, this analysis engine will use a default model from the resources directory")
    protected URI lemmatizerDataFile;
    public static final String PARAM_USE_LEMMATIZER = "UseLemmatizer";
    @ConfigurationParameter(name="UseLemmatizer", defaultValue={"true"}, description="If true, use the default ClearNLP lemmatizer, otherwise use lemmas from the BaseToken normalizedToken field")
    protected boolean useLemmatizer;
    protected AbstractComponent parser;
    protected AbstractMPAnalyzer lemmatizer;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.logger.info((Object)("using Morphy analysis? " + this.useLemmatizer));
        try {
            if (this.useLemmatizer) {
                InputStream lemmatizerModel = this.lemmatizerDataFile == null ? FileLocator.getAsStream((String)ENG_LEMMATIZER_DATA_FILE) : FileLocator.getAsStream((String)this.lemmatizerDataFile.getPath());
                this.lemmatizer = EngineGetter.getMPAnalyzer((String)"en", (InputStream)lemmatizerModel);
            }
            InputStream parserModel = this.parserModelUri == null ? FileLocator.getAsStream((String)DEFAULT_MODEL_FILE_NAME) : FileLocator.getAsStream((String)this.parserModelUri.getPath());
            this.parser = EngineGetter.getComponent((InputStream)parserModel, (String)this.language, (String)"dep");
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        for (Sentence sentence : JCasUtil.select((JCas)jCas, Sentence.class)) {
            List tokens = JCasUtil.selectCovered((JCas)jCas, BaseToken.class, (AnnotationFS)sentence);
            DEPTree tree = new DEPTree();
            for (int i = 0; i < tokens.size(); ++i) {
                BaseToken token = (BaseToken)tokens.get(i);
                String lemma = this.useLemmatizer ? this.lemmatizer.getLemma(token.getCoveredText(), token.getPartOfSpeech()) : token.getNormalizedForm();
                DEPNode node = new DEPNode(i + 1, token.getCoveredText(), lemma, token.getPartOfSpeech(), new DEPFeat());
                tree.add((Object)node);
            }
            this.parser.process(tree);
            ArrayList<ConllDependencyNode> nodes = ClearDependencyUtility.convert(jCas, tree, sentence, tokens);
            ClearDependencyUtility.addToIndexes(jCas, nodes);
        }
    }
}

