/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dependency.parser;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import org.apache.ctakes.core.util.DocumentIDAnnotationUtil;
import org.apache.ctakes.typesystem.type.syntax.ConllDependencyNode;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.log4j.Logger;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;

public class DependencyNodeWriter
extends CasConsumer_ImplBase {
    private Logger iv_logger = Logger.getLogger((String)((Object)((Object)this)).getClass().getName());
    private String iv_outputDir = null;
    private String iv_outputFormat = null;
    private int iv_procCount = 0;

    public void initialize() throws ResourceInitializationException {
        this.iv_outputDir = (String)this.getConfigParameterValue("outputDir");
        this.iv_outputFormat = (String)this.getConfigParameterValue("outputFormat");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processView(JCas jCas) throws Exception {
        String docName = DocumentIDAnnotationUtil.getDocumentID((JCas)jCas);
        docName = docName == null ? "doc" + this.iv_procCount + "." + this.iv_outputFormat.toLowerCase() : docName + "." + this.iv_outputFormat.toLowerCase();
        try {
            File outputDir = new File(this.iv_outputDir);
            outputDir.mkdirs();
            File outputFile = new File(this.iv_outputDir + File.separatorChar + docName);
            outputFile.createNewFile();
            BufferedWriter bw = new BufferedWriter(new FileWriter(outputFile));
            AnnotationIndex nodeIndex = jCas.getAnnotationIndex(ConllDependencyNode.type);
            for (Sentence sentence : jCas.getAnnotationIndex(Sentence.type)) {
                ConllDependencyNode node = null;
                FSIterator nodeIterator = nodeIndex.subiterator((AnnotationFS)sentence);
                while (nodeIterator.hasNext()) {
                    node = (ConllDependencyNode)nodeIterator.next();
                    if (node.getId() == 0) continue;
                    if (this.iv_outputFormat.toLowerCase().contains("min")) {
                        bw.write(node.getId() + "\t");
                        bw.write(node.getForm() + "\t");
                        bw.write((node.getHead() == null ? "_" : Integer.valueOf(node.getHead().getId())) + "\t");
                        bw.write(node.getDeprel() + "\n");
                        continue;
                    }
                    if (this.iv_outputFormat.toLowerCase().contains("mpos")) {
                        bw.write(node.getId() + "\t");
                        bw.write(node.getForm() + "\t");
                        bw.write(node.getPostag() + "\t");
                        bw.write((node.getHead() == null ? "_" : Integer.valueOf(node.getHead().getId())) + "\t");
                        bw.write(node.getDeprel() + "\n");
                        continue;
                    }
                    if (this.iv_outputFormat.toLowerCase().contains("mlem")) {
                        bw.write(node.getId() + "\t");
                        bw.write(node.getForm() + "\t");
                        bw.write(node.getLemma() + "\t");
                        bw.write((node.getHead() == null ? "_" : Integer.valueOf(node.getHead().getId())) + "\t");
                        bw.write(node.getDeprel() + "\n");
                        continue;
                    }
                    if (this.iv_outputFormat.toLowerCase().contains("dep")) {
                        bw.write(node.getId() + "\t");
                        bw.write(node.getForm() + "\t");
                        bw.write(node.getLemma() + "\t");
                        bw.write(node.getPostag() + "\t");
                        bw.write((node.getHead() == null ? "_" : Integer.valueOf(node.getHead().getId())) + "\t");
                        bw.write(node.getDeprel() + "\n");
                        continue;
                    }
                    bw.write(node.getId() + "\t");
                    bw.write(node.getForm() + "\t");
                    bw.write(node.getLemma() + "\t");
                    bw.write(node.getCpostag() + "\t");
                    bw.write(node.getPostag() + "\t");
                    bw.write(node.getFeats() + "\t");
                    bw.write((node.getHead() == null ? "_" : Integer.valueOf(node.getHead().getId())) + "\t");
                    bw.write(node.getDeprel() + "\t");
                    bw.write((node.getPhead() == null ? "_" : Integer.valueOf(node.getPhead().getId())) + "\t");
                    bw.write(node.getPdeprel() + "\n");
                }
                bw.write("\n");
            }
            bw.flush();
        }
        finally {
            ++this.iv_procCount;
        }
    }

    public void processCas(CAS cas) throws ResourceProcessException {
        this.iv_logger.info((Object)"Started");
        try {
            JCas currentView = cas.getCurrentView().getJCas();
            this.processView(currentView);
        }
        catch (Exception e) {
            throw new ResourceProcessException((Throwable)e);
        }
    }
}

