/*
 * $Id$
 */

package org.codehaus.plexus.security.user.jdo.v0_9_0;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * 
 *         @plexus.component
 * role="org.codehaus.plexus.security.user.User"
 *         role-hint="jdo"
 *       .
 * 
 * @version $Revision$ $Date$
 */
public class JdoUser 
implements org.codehaus.plexus.security.user.User, java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field username.
     */
    private String username;

    /**
     * Field password.
     */
    private String password;

    /**
     * Field encodedPassword.
     */
    private String encodedPassword;

    /**
     * Field fullName.
     */
    private String fullName;

    /**
     * Field email.
     */
    private String email;

    /**
     * Field lastPasswordChange.
     */
    private java.util.Date lastPasswordChange;

    /**
     * Field lastLoginDate.
     */
    private java.util.Date lastLoginDate;

    /**
     * Field countFailedLoginAttempts.
     */
    private int countFailedLoginAttempts = 0;

    /**
     * Field locked.
     */
    private boolean locked = false;

    /**
     * Field permanent.
     */
    private boolean permanent = false;

    /**
     * Field validated.
     */
    private boolean validated = false;

    /**
     * Field passwordChangeRequired.
     */
    private boolean passwordChangeRequired = false;

    /**
     * Field previousEncodedPasswords.
     */
    private java.util.List previousEncodedPasswords;

    /**
     * Field accountCreationDate.
     */
    private java.util.Date accountCreationDate;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addPreviousEncodedPassword.
     * 
     * @param string
     */
    public void addPreviousEncodedPassword(String string)
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "JdoUser.addPreviousEncodedPasswords(string) parameter must be instanceof " + String.class.getName() );
        }
        getPreviousEncodedPasswords().add( string );
    } //-- void addPreviousEncodedPassword(String) 

    /**
     * Method equals.
     * 
     * @param other
     * @return boolean
     */
    public boolean equals(Object other)
    {
        if ( this == other)
        {
            return true;
        }
        
        if ( !(other instanceof JdoUser) )
        {
            return false;
        }
        
        JdoUser that = (JdoUser) other;
        boolean result = true;
        
        result = result && ( getUsername() == null ? that.getUsername() == null : getUsername().equals( that.getUsername() ) );
        result = result && ( getPassword() == null ? that.getPassword() == null : getPassword().equals( that.getPassword() ) );
        result = result && ( getEncodedPassword() == null ? that.getEncodedPassword() == null : getEncodedPassword().equals( that.getEncodedPassword() ) );
        result = result && ( getFullName() == null ? that.getFullName() == null : getFullName().equals( that.getFullName() ) );
        result = result && ( getEmail() == null ? that.getEmail() == null : getEmail().equals( that.getEmail() ) );
        result = result && locked == that.locked;
        result = result && permanent == that.permanent;
        result = result && validated == that.validated;
        result = result && passwordChangeRequired == that.passwordChangeRequired;
        
        return result;
    } //-- boolean equals(Object) 

    /**
     * Get the accountCreationDate field.
     * 
     * @return java.util.Date
     */
    public java.util.Date getAccountCreationDate()
    {
        return this.accountCreationDate;
    } //-- java.util.Date getAccountCreationDate() 

    /**
     * Get the countFailedLoginAttempts field.
     * 
     * @return int
     */
    public int getCountFailedLoginAttempts()
    {
        return this.countFailedLoginAttempts;
    } //-- int getCountFailedLoginAttempts() 

    /**
     * Get the email field.
     * 
     * @return String
     */
    public String getEmail()
    {
        return this.email;
    } //-- String getEmail() 

    /**
     * Get the encodedPassword field.
     * 
     * @return String
     */
    public String getEncodedPassword()
    {
        return this.encodedPassword;
    } //-- String getEncodedPassword() 

    /**
     * Get the fullName field.
     * 
     * @return String
     */
    public String getFullName()
    {
        return this.fullName;
    } //-- String getFullName() 

    /**
     * Get the lastLoginDate field.
     * 
     * @return java.util.Date
     */
    public java.util.Date getLastLoginDate()
    {
        return this.lastLoginDate;
    } //-- java.util.Date getLastLoginDate() 

    /**
     * Get the lastPasswordChange field.
     * 
     * @return java.util.Date
     */
    public java.util.Date getLastPasswordChange()
    {
        return this.lastPasswordChange;
    } //-- java.util.Date getLastPasswordChange() 

    /**
     * Get the password field.
     * 
     * @return String
     */
    public String getPassword()
    {
        return this.password;
    } //-- String getPassword() 

    /**
     * Method getPreviousEncodedPasswords.
     * 
     * @return java.util.List
     */
    public java.util.List getPreviousEncodedPasswords()
    {
        if ( this.previousEncodedPasswords == null )
        {
            this.previousEncodedPasswords = new java.util.ArrayList();
        }
        
        return this.previousEncodedPasswords;
    } //-- java.util.List getPreviousEncodedPasswords() 

    /**
     * Get the username field.
     * 
     * @return String
     */
    public String getUsername()
    {
        return this.username;
    } //-- String getUsername() 

    /**
     * Method hashCode.
     * 
     * @return int
     */
    public int hashCode()
    {
        int result = 17;
        
        result = 37 * result + ( username != null ? username.hashCode() : 0 );
        result = 37 * result + ( password != null ? password.hashCode() : 0 );
        result = 37 * result + ( encodedPassword != null ? encodedPassword.hashCode() : 0 );
        result = 37 * result + ( fullName != null ? fullName.hashCode() : 0 );
        result = 37 * result + ( email != null ? email.hashCode() : 0 );
        result = 37 * result + ( locked ? 0 : 1 );
        result = 37 * result + ( permanent ? 0 : 1 );
        result = 37 * result + ( validated ? 0 : 1 );
        result = 37 * result + ( passwordChangeRequired ? 0 : 1 );
        
        return result;
    } //-- int hashCode() 

    /**
     * Get the locked field.
     * 
     * @return boolean
     */
    public boolean isLocked()
    {
        return this.locked;
    } //-- boolean isLocked() 

    /**
     * Get the passwordChangeRequired field.
     * 
     * @return boolean
     */
    public boolean isPasswordChangeRequired()
    {
        return this.passwordChangeRequired;
    } //-- boolean isPasswordChangeRequired() 

    /**
     * Get the permanent field.
     * 
     * @return boolean
     */
    public boolean isPermanent()
    {
        return this.permanent;
    } //-- boolean isPermanent() 

    /**
     * Get the validated field.
     * 
     * @return boolean
     */
    public boolean isValidated()
    {
        return this.validated;
    } //-- boolean isValidated() 

    /**
     * Method removePreviousEncodedPassword.
     * 
     * @param string
     */
    public void removePreviousEncodedPassword(String string)
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "JdoUser.removePreviousEncodedPasswords(string) parameter must be instanceof " + String.class.getName() );
        }
        getPreviousEncodedPasswords().remove( string );
    } //-- void removePreviousEncodedPassword(String) 

    /**
     * Set the accountCreationDate field.
     * 
     * @param accountCreationDate
     */
    public void setAccountCreationDate(java.util.Date accountCreationDate)
    {
        this.accountCreationDate = accountCreationDate;
    } //-- void setAccountCreationDate(java.util.Date) 

    /**
     * Set the countFailedLoginAttempts field.
     * 
     * @param countFailedLoginAttempts
     */
    public void setCountFailedLoginAttempts(int countFailedLoginAttempts)
    {
        this.countFailedLoginAttempts = countFailedLoginAttempts;
    } //-- void setCountFailedLoginAttempts(int) 

    /**
     * Set the email field.
     * 
     * @param email
     */
    public void setEmail(String email)
    {
        this.email = email;
    } //-- void setEmail(String) 

    /**
     * Set the encodedPassword field.
     * 
     * @param encodedPassword
     */
    public void setEncodedPassword(String encodedPassword)
    {
        this.encodedPassword = encodedPassword;
    } //-- void setEncodedPassword(String) 

    /**
     * Set the fullName field.
     * 
     * @param fullName
     */
    public void setFullName(String fullName)
    {
        this.fullName = fullName;
    } //-- void setFullName(String) 

    /**
     * Set the lastLoginDate field.
     * 
     * @param lastLoginDate
     */
    public void setLastLoginDate(java.util.Date lastLoginDate)
    {
        this.lastLoginDate = lastLoginDate;
    } //-- void setLastLoginDate(java.util.Date) 

    /**
     * Set the lastPasswordChange field.
     * 
     * @param lastPasswordChange
     */
    public void setLastPasswordChange(java.util.Date lastPasswordChange)
    {
        this.lastPasswordChange = lastPasswordChange;
    } //-- void setLastPasswordChange(java.util.Date) 

    /**
     * Set the locked field.
     * 
     * @param locked
     */
    public void setLocked(boolean locked)
    {
        this.locked = locked;
    } //-- void setLocked(boolean) 

    /**
     * Set the password field.
     * 
     * @param password
     */
    public void setPassword(String password)
    {
        this.password = password;
    } //-- void setPassword(String) 

    /**
     * Set the passwordChangeRequired field.
     * 
     * @param passwordChangeRequired
     */
    public void setPasswordChangeRequired(boolean passwordChangeRequired)
    {
        this.passwordChangeRequired = passwordChangeRequired;
    } //-- void setPasswordChangeRequired(boolean) 

    /**
     * Set the permanent field.
     * 
     * @param permanent
     */
    public void setPermanent(boolean permanent)
    {
        this.permanent = permanent;
    } //-- void setPermanent(boolean) 

    /**
     * Set the previousEncodedPasswords field.
     * 
     * @param previousEncodedPasswords
     */
    public void setPreviousEncodedPasswords(java.util.List previousEncodedPasswords)
    {
        this.previousEncodedPasswords = previousEncodedPasswords;
    } //-- void setPreviousEncodedPasswords(java.util.List) 

    /**
     * Set the username field.
     * 
     * @param username
     */
    public void setUsername(String username)
    {
        this.username = username;
    } //-- void setUsername(String) 

    /**
     * Set the validated field.
     * 
     * @param validated
     */
    public void setValidated(boolean validated)
    {
        this.validated = validated;
    } //-- void setValidated(boolean) 

    /**
     * Method toString.
     * 
     * @return java.lang.String
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();
        
        buf.append( "username = '" );
        buf.append( getUsername() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "password = '" );
        buf.append( getPassword() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "encodedPassword = '" );
        buf.append( getEncodedPassword() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "fullName = '" );
        buf.append( getFullName() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "email = '" );
        buf.append( getEmail() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "locked = '" );
        buf.append( isLocked() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "permanent = '" );
        buf.append( isPermanent() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "validated = '" );
        buf.append( isValidated() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "passwordChangeRequired = '" );
        buf.append( isPasswordChangeRequired() );
        buf.append( "'" );
        
        return buf.toString();
    } //-- java.lang.String toString() 


              public JdoUser()
              {
                 // Intentionally initialize List to avoid JPOX NullPointerException Issues.
              	 previousEncodedPasswords = new java.util.ArrayList();
              }

              public Object getPrincipal()
              {
                 return username;
              }
          
    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
