/*
 * $Id$
 */

package org.codehaus.plexus.security.keys.jdo.v0_9_0.io.stax;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Iterator;
import java.util.Locale;
import java.util.jar.Manifest;
import javanet.staxutils.IndentingXMLStreamWriter;
import javax.xml.stream.*;
import org.codehaus.plexus.security.keys.jdo.v0_9_0.AuthenticationKeyDatabase;
import org.codehaus.plexus.security.keys.jdo.v0_9_0.JdoAuthenticationKey;
import org.codehaus.plexus.util.xml.Xpp3Dom;

/**
 * Class PlexusSecurityKeyManagementJdoStaxWriter.
 * 
 * @version $Revision$ $Date$
 */
public class PlexusSecurityKeyManagementJdoStaxWriter {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field curId.
     */
    private int curId;

    /**
     * Field idMap.
     */
    private java.util.Map idMap;


      //----------------/
     //- Constructors -/
    //----------------/

    public PlexusSecurityKeyManagementJdoStaxWriter() {
        idMap = new java.util.HashMap();
    } //-- org.codehaus.plexus.security.keys.jdo.v0_9_0.io.stax.PlexusSecurityKeyManagementJdoStaxWriter()


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method write.
     * 
     * @param writer
     * @param authenticationKeyDatabase
     * @throws java.io.IOException
     * @throws XMLStreamException
     */
    public void write(Writer writer, AuthenticationKeyDatabase authenticationKeyDatabase)
        throws java.io.IOException, XMLStreamException
    {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        boolean supportWindowsLineEndings = false;
        if ( factory.isPropertySupported( "com.ctc.wstx.outputEscapeCr" ) )
        {
            factory.setProperty( "com.ctc.wstx.outputEscapeCr", Boolean.FALSE );
            supportWindowsLineEndings = true;
        }
        if ( factory.isPropertySupported( "org.codehaus.stax2.automaticEmptyElements" ) )
        {
            factory.setProperty( "org.codehaus.stax2.automaticEmptyElements", Boolean.FALSE );
        }
        IndentingXMLStreamWriter serializer = new IndentingXMLStreamWriter( factory.createXMLStreamWriter( writer ) );
        if ( supportWindowsLineEndings )
        {
            serializer.setNewLine( serializer.getLineSeparator() );
        }
        serializer.writeStartDocument( authenticationKeyDatabase.getModelEncoding(), "1.0" );
        writeAuthenticationKeyDatabase( authenticationKeyDatabase, "authenticationKeyDatabase", serializer );
        serializer.writeEndDocument();
    } //-- void write(Writer, AuthenticationKeyDatabase) 

    /**
     * Method writeAuthenticationKeyDatabase.
     * 
     * @param authenticationKeyDatabase
     * @param serializer
     * @param tagName
     * @throws java.io.IOException
     * @throws XMLStreamException
     */
    private void writeAuthenticationKeyDatabase(AuthenticationKeyDatabase authenticationKeyDatabase, String tagName, XMLStreamWriter serializer)
        throws java.io.IOException, XMLStreamException
    {
        if ( authenticationKeyDatabase != null )
        {
            serializer.writeStartElement( tagName );
            if ( authenticationKeyDatabase.getKeys() != null && authenticationKeyDatabase.getKeys().size() > 0 )
            {
                serializer.writeStartElement( "keys" );
                for ( Iterator iter = authenticationKeyDatabase.getKeys().iterator(); iter.hasNext(); )
                {
                    JdoAuthenticationKey o = (JdoAuthenticationKey) iter.next();
                    writeJdoAuthenticationKey( o, "key", serializer );
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    } //-- void writeAuthenticationKeyDatabase(AuthenticationKeyDatabase, String, XMLStreamWriter) 

    /**
     * Method writeDom.
     * 
     * @param dom
     * @param serializer
     * @throws XMLStreamException
     */
    public void writeDom(Xpp3Dom dom, XMLStreamWriter serializer)
        throws XMLStreamException
    {
        serializer.writeStartElement( dom.getName() );
        String[] attributeNames = dom.getAttributeNames();
        for ( int i = 0; i < attributeNames.length; i++ )
        {
            String attributeName = attributeNames[i];
            serializer.writeAttribute( attributeName, dom.getAttribute( attributeName ) );
        }
        Xpp3Dom[] children = dom.getChildren();
        for ( int i = 0; i < children.length; i++ )
        {
            writeDom( children[i], serializer );
        }
        String value = dom.getValue();
        if ( value != null )
        {
            serializer.writeCharacters( value );
        }
        serializer.writeEndElement();
    } //-- void writeDom(Xpp3Dom, XMLStreamWriter) 

    /**
     * Method writeJdoAuthenticationKey.
     * 
     * @param jdoAuthenticationKey
     * @param serializer
     * @param tagName
     * @throws java.io.IOException
     * @throws XMLStreamException
     */
    private void writeJdoAuthenticationKey(JdoAuthenticationKey jdoAuthenticationKey, String tagName, XMLStreamWriter serializer)
        throws java.io.IOException, XMLStreamException
    {
        if ( jdoAuthenticationKey != null )
        {
            serializer.writeStartElement( tagName );
            if ( jdoAuthenticationKey.getKey() != null )
            {
                serializer.writeStartElement( "key" );
                serializer.writeCharacters( jdoAuthenticationKey.getKey() );
                serializer.writeEndElement();
            }
            if ( jdoAuthenticationKey.getForPrincipal() != null )
            {
                serializer.writeStartElement( "forPrincipal" );
                serializer.writeCharacters( jdoAuthenticationKey.getForPrincipal() );
                serializer.writeEndElement();
            }
            if ( jdoAuthenticationKey.getPurpose() != null )
            {
                serializer.writeStartElement( "purpose" );
                serializer.writeCharacters( jdoAuthenticationKey.getPurpose() );
                serializer.writeEndElement();
            }
            if ( jdoAuthenticationKey.getDateCreated() != null )
            {
                serializer.writeStartElement( "dateCreated" );
                serializer.writeCharacters( Long.toString( jdoAuthenticationKey.getDateCreated().getTime() ) );
                serializer.writeEndElement();
            }
            if ( jdoAuthenticationKey.getDateExpires() != null )
            {
                serializer.writeStartElement( "dateExpires" );
                serializer.writeCharacters( Long.toString( jdoAuthenticationKey.getDateExpires().getTime() ) );
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    } //-- void writeJdoAuthenticationKey(JdoAuthenticationKey, String, XMLStreamWriter) 


}
