/*
 * $Id$
 */

package org.codehaus.plexus.security.keys.jdo.v0_9_0.io.stax;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.*;
import org.codehaus.plexus.security.keys.jdo.v0_9_0.AuthenticationKeyDatabase;
import org.codehaus.plexus.security.keys.jdo.v0_9_0.JdoAuthenticationKey;
import org.codehaus.plexus.util.xml.Xpp3Dom;

/**
 * Class PlexusSecurityKeyManagementJdoStaxReader.
 * 
 * @version $Revision$ $Date$
 */
public class PlexusSecurityKeyManagementJdoStaxReader {


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method buildDom.
     * 
     * @param xmlStreamReader
     * @throws XMLStreamException
     * @return Xpp3Dom
     */
    public Xpp3Dom buildDom(XMLStreamReader xmlStreamReader)
        throws XMLStreamException
    {
        java.util.List elements = new java.util.ArrayList();
        java.util.List values = new java.util.ArrayList();
        int eventType = xmlStreamReader.getEventType();
        while ( xmlStreamReader.hasNext() )
        {
            if ( eventType == XMLStreamConstants.START_ELEMENT )
            {
                String rawName = xmlStreamReader.getLocalName();
                Xpp3Dom childConfiguration = new Xpp3Dom( rawName );
                int depth = elements.size();
                if ( depth > 0 )
                {
                    Xpp3Dom parent = (Xpp3Dom) elements.get( depth - 1 );
                    parent.addChild( childConfiguration );
                }
                elements.add( childConfiguration );
                if ( xmlStreamReader.isEndElement() )
                {
                    values.add( null );
                }
                else
                {
                    values.add( new StringBuffer() );
                }
                int attributesSize = xmlStreamReader.getAttributeCount();
                for ( int i = 0; i < attributesSize; i++ )
                {
                    String name = xmlStreamReader.getAttributeLocalName( i );
                    String value = xmlStreamReader.getAttributeValue( i );
                    childConfiguration.setAttribute( name, value );
                }
            }
            else if ( eventType == XMLStreamConstants.CHARACTERS )
            {
                int depth = values.size() - 1;
                StringBuffer valueBuffer = (StringBuffer) values.get( depth );
                String text = xmlStreamReader.getText();
                text = text.trim();
                valueBuffer.append( text );
            }
            else if ( eventType == XMLStreamConstants.END_ELEMENT )
            {
                int depth = elements.size() - 1;
                Xpp3Dom finishedConfiguration = (Xpp3Dom) elements.remove( depth );
                // this Object could be null if it is a singleton tag
                Object accumulatedValue = values.remove( depth );
                if ( finishedConfiguration.getChildCount() == 0 )
                {
                    if ( accumulatedValue == null )
                    {
                        finishedConfiguration.setValue( null );
                    }
                    else
                    {
                        finishedConfiguration.setValue( accumulatedValue.toString() );
                    }
                }
                if ( depth == 0 )
                {
                    return finishedConfiguration;
                }
            }
            eventType = xmlStreamReader.next();
        }
        throw new IllegalStateException( "End of document found before returning to 0 depth" );
    } //-- Xpp3Dom buildDom(XMLStreamReader) 

    /**
     * Method getBooleanValue.
     * 
     * @param s
     * @param xmlStreamReader
     * @param attribute
     * @throws XMLStreamException
     * @return boolean
     */
    public boolean getBooleanValue(String s, String attribute, XMLStreamReader xmlStreamReader)
        throws XMLStreamException
    {
        if ( s != null )
        {
            return Boolean.valueOf( s ).booleanValue();
        }
        return false;
    } //-- boolean getBooleanValue(String, String, XMLStreamReader) 

    /**
     * Method getCharacterValue.
     * 
     * @param s
     * @param xmlStreamReader
     * @param attribute
     * @throws XMLStreamException
     * @return char
     */
    public char getCharacterValue(String s, String attribute, XMLStreamReader xmlStreamReader)
        throws XMLStreamException
    {
        if ( s != null )
        {
            return s.charAt( 0 );
        }
        return 0;
    } //-- char getCharacterValue(String, String, XMLStreamReader) 

    /**
     * Method getDateValue.
     * 
     * @param s
     * @param xmlStreamReader
     * @param dateFormat
     * @param attribute
     * @throws XMLStreamException
     * @return java.util.Date
     */
    public java.util.Date getDateValue(String s, String attribute, String dateFormat, XMLStreamReader xmlStreamReader)
        throws XMLStreamException
    {
        if ( s != null )
        {
            if ( dateFormat == null )
            {
                return new java.util.Date( Long.valueOf( s ).longValue() );
            }
            else
            {
                DateFormat dateParser = new java.text.SimpleDateFormat( dateFormat, Locale.US );
                try
                {
                    return dateParser.parse( s );
                }
                catch ( java.text.ParseException e )
                {
                    throw new XMLStreamException( e.getMessage() );
                }
            }
        }
        return null;
    } //-- java.util.Date getDateValue(String, String, String, XMLStreamReader) 

    /**
     * Method getDoubleValue.
     * 
     * @param s
     * @param strict
     * @param xmlStreamReader
     * @param attribute
     * @throws XMLStreamException
     * @return double
     */
    public double getDoubleValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict)
        throws XMLStreamException
    {
        if ( s != null )
        {
            try
            {
                return Double.valueOf( s ).doubleValue();
            }
            catch ( NumberFormatException e )
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unable to parse element '" + attribute + "', must be a floating point number but was '" + s + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        return 0;
    } //-- double getDoubleValue(String, String, XMLStreamReader, boolean) 

    /**
     * Method getFloatValue.
     * 
     * @param s
     * @param strict
     * @param xmlStreamReader
     * @param attribute
     * @throws XMLStreamException
     * @return float
     */
    public float getFloatValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict)
        throws XMLStreamException
    {
        if ( s != null )
        {
            try
            {
                return Float.valueOf( s ).floatValue();
            }
            catch ( NumberFormatException e )
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unable to parse element '" + attribute + "', must be a floating point number but was '" + s + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        return 0;
    } //-- float getFloatValue(String, String, XMLStreamReader, boolean) 

    /**
     * Method getIntegerValue.
     * 
     * @param s
     * @param strict
     * @param xmlStreamReader
     * @param attribute
     * @throws XMLStreamException
     * @return int
     */
    public int getIntegerValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict)
        throws XMLStreamException
    {
        if ( s != null )
        {
            try
            {
                return Integer.valueOf( s ).intValue();
            }
            catch ( NumberFormatException e )
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unable to parse element '" + attribute + "', must be an integer but was '" + s + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        return 0;
    } //-- int getIntegerValue(String, String, XMLStreamReader, boolean) 

    /**
     * Method getLongValue.
     * 
     * @param s
     * @param strict
     * @param xmlStreamReader
     * @param attribute
     * @throws XMLStreamException
     * @return long
     */
    public long getLongValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict)
        throws XMLStreamException
    {
        if ( s != null )
        {
            try
            {
                return Long.valueOf( s ).longValue();
            }
            catch ( NumberFormatException e )
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unable to parse element '" + attribute + "', must be a long integer but was '" + s + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        return 0;
    } //-- long getLongValue(String, String, XMLStreamReader, boolean) 

    /**
     * Method getRequiredAttributeValue.
     * 
     * @param s
     * @param strict
     * @param xmlStreamReader
     * @param attribute
     * @throws XMLStreamException
     * @return String
     */
    public String getRequiredAttributeValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict)
        throws XMLStreamException
    {
        if ( s == null )
        {
            if ( strict )
            {
                throw new XMLStreamException( "Missing required value for attribute '" + attribute + "'", xmlStreamReader.getLocation() );
            }
        }
        return s;
    } //-- String getRequiredAttributeValue(String, String, XMLStreamReader, boolean) 

    /**
     * Method getShortValue.
     * 
     * @param s
     * @param strict
     * @param xmlStreamReader
     * @param attribute
     * @throws XMLStreamException
     * @return short
     */
    public short getShortValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict)
        throws XMLStreamException
    {
        if ( s != null )
        {
            try
            {
                return Short.valueOf( s ).shortValue();
            }
            catch ( NumberFormatException e )
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unable to parse element '" + attribute + "', must be a short integer but was '" + s + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        return 0;
    } //-- short getShortValue(String, String, XMLStreamReader, boolean) 

    /**
     * Method getTrimmedValue.
     * 
     * @param s
     * @return String
     */
    public String getTrimmedValue(String s)
    {
        if ( s != null )
        {
            s = s.trim();
        }
        return s;
    } //-- String getTrimmedValue(String) 

    /**
     * Method parseAuthenticationKeyDatabase.
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param xmlStreamReader
     * @throws IOException
     * @throws XMLStreamException
     * @return AuthenticationKeyDatabase
     */
    private AuthenticationKeyDatabase parseAuthenticationKeyDatabase(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding)
        throws IOException, XMLStreamException
    {
        AuthenticationKeyDatabase authenticationKeyDatabase = new AuthenticationKeyDatabase();
        authenticationKeyDatabase.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        boolean foundRoot = false;
        while ( xmlStreamReader.hasNext() )
        {
            int eventType = xmlStreamReader.next();
            if ( eventType == XMLStreamConstants.START_ELEMENT )
            {
                if ( xmlStreamReader.getLocalName().equals( tagName ) )
                {
                    foundRoot = true;
                }
                else if ( xmlStreamReader.getLocalName().equals( "keys" )  )
                {
                    if ( parsed.contains( "keys" ) )
                    {
                        throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                    parsed.add( "keys" );
                    java.util.List keys = new java.util.ArrayList();
                    authenticationKeyDatabase.setKeys( keys );
                    while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                    {
                        if ( xmlStreamReader.getLocalName().equals( "key" ) )
                        {
                            authenticationKeyDatabase.addKey( parseJdoAuthenticationKey( "key", xmlStreamReader, strict, encoding ) );
                        }
                        else
                        {
                            throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                        }
                    }
                }
                else
                {
                    if ( foundRoot )
                    {
                        if ( strict )
                        {
                            throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                        }
                    }
                }
            }
        }
        return authenticationKeyDatabase;
    } //-- AuthenticationKeyDatabase parseAuthenticationKeyDatabase(String, XMLStreamReader, boolean, String) 

    /**
     * Method parseJdoAuthenticationKey.
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param xmlStreamReader
     * @throws IOException
     * @throws XMLStreamException
     * @return JdoAuthenticationKey
     */
    private JdoAuthenticationKey parseJdoAuthenticationKey(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding)
        throws IOException, XMLStreamException
    {
        JdoAuthenticationKey jdoAuthenticationKey = new JdoAuthenticationKey();
        jdoAuthenticationKey.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
        {
            if ( xmlStreamReader.getLocalName().equals( "key" )  )
            {
                if ( parsed.contains( "key" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "key" );
                jdoAuthenticationKey.setKey( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "forPrincipal" )  )
            {
                if ( parsed.contains( "forPrincipal" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "forPrincipal" );
                jdoAuthenticationKey.setForPrincipal( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "purpose" )  )
            {
                if ( parsed.contains( "purpose" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "purpose" );
                jdoAuthenticationKey.setPurpose( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "dateCreated" )  )
            {
                if ( parsed.contains( "dateCreated" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "dateCreated" );
                String dateFormat = null;
                jdoAuthenticationKey.setDateCreated( getDateValue( getTrimmedValue( xmlStreamReader.getElementText()), "dateCreated", dateFormat, xmlStreamReader ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "dateExpires" )  )
            {
                if ( parsed.contains( "dateExpires" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "dateExpires" );
                String dateFormat = null;
                jdoAuthenticationKey.setDateExpires( getDateValue( getTrimmedValue( xmlStreamReader.getElementText()), "dateExpires", dateFormat, xmlStreamReader ) );
            }
            else
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        return jdoAuthenticationKey;
    } //-- JdoAuthenticationKey parseJdoAuthenticationKey(String, XMLStreamReader, boolean, String) 

    /**
     * Method read.
     * 
     * @param reader
     * @param strict
     * @throws IOException
     * @throws XMLStreamException
     * @return AuthenticationKeyDatabase
     */
    public AuthenticationKeyDatabase read(Reader reader, boolean strict)
        throws IOException, XMLStreamException
    {
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader( reader );
        
        String encoding = xmlStreamReader.getCharacterEncodingScheme();
        AuthenticationKeyDatabase value = parseAuthenticationKeyDatabase( "authenticationKeyDatabase", xmlStreamReader, strict, encoding );
        resolveReferences( value );
        return value;
    } //-- AuthenticationKeyDatabase read(Reader, boolean) 

    /**
     * Method read.
     * 
     * @param reader
     * @throws IOException
     * @throws XMLStreamException
     * @return AuthenticationKeyDatabase
     */
    public AuthenticationKeyDatabase read(Reader reader)
        throws IOException, XMLStreamException
    {
        return read( reader, true );
    } //-- AuthenticationKeyDatabase read(Reader) 

    /**
     * Method read.
     * 
     * @param filePath
     * @param strict
     * @throws IOException
     * @throws XMLStreamException
     * @return AuthenticationKeyDatabase
     */
    public AuthenticationKeyDatabase read(String filePath, boolean strict)
        throws IOException, XMLStreamException
    {
        File file = new File(filePath);
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader( file.toURL().toExternalForm(), new FileInputStream(file) );
        
        String encoding = xmlStreamReader.getCharacterEncodingScheme();
        AuthenticationKeyDatabase value = parseAuthenticationKeyDatabase( "authenticationKeyDatabase", xmlStreamReader, strict, encoding );
        resolveReferences( value );
        return value;
    } //-- AuthenticationKeyDatabase read(String, boolean) 

    /**
     * Method read.
     * 
     * @param filePath
     * @throws IOException
     * @throws XMLStreamException
     * @return AuthenticationKeyDatabase
     */
    public AuthenticationKeyDatabase read(String filePath)
        throws IOException, XMLStreamException
    {
        return read( filePath, true );
    } //-- AuthenticationKeyDatabase read(String) 

    /**
     * Method resolveReferences.
     * 
     * @param value
     */
    private void resolveReferences(AuthenticationKeyDatabase value)
    {
        java.util.Map refs;
    } //-- void resolveReferences(AuthenticationKeyDatabase) 


}
