/*
 * $Id$
 */

package org.codehaus.plexus.security.authorization.rbac.jdo.v0_9_0.io.stax;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Iterator;
import java.util.Locale;
import java.util.jar.Manifest;
import javanet.staxutils.IndentingXMLStreamWriter;
import javax.xml.stream.*;
import org.codehaus.plexus.security.authorization.rbac.jdo.v0_9_0.JdoOperation;
import org.codehaus.plexus.security.authorization.rbac.jdo.v0_9_0.JdoPermission;
import org.codehaus.plexus.security.authorization.rbac.jdo.v0_9_0.JdoResource;
import org.codehaus.plexus.security.authorization.rbac.jdo.v0_9_0.JdoRole;
import org.codehaus.plexus.security.authorization.rbac.jdo.v0_9_0.JdoUserAssignment;
import org.codehaus.plexus.security.authorization.rbac.jdo.v0_9_0.RbacDatabase;
import org.codehaus.plexus.util.xml.Xpp3Dom;

/**
 * Class RbacJdoModelStaxWriter.
 * 
 * @version $Revision$ $Date$
 */
public class RbacJdoModelStaxWriter {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field curId.
     */
    private int curId;

    /**
     * Field idMap.
     */
    private java.util.Map idMap;


      //----------------/
     //- Constructors -/
    //----------------/

    public RbacJdoModelStaxWriter() {
        idMap = new java.util.HashMap();
    } //-- org.codehaus.plexus.security.authorization.rbac.jdo.v0_9_0.io.stax.RbacJdoModelStaxWriter()


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method write.
     * 
     * @param writer
     * @param rbacDatabase
     * @throws java.io.IOException
     * @throws XMLStreamException
     */
    public void write(Writer writer, RbacDatabase rbacDatabase)
        throws java.io.IOException, XMLStreamException
    {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        boolean supportWindowsLineEndings = false;
        if ( factory.isPropertySupported( "com.ctc.wstx.outputEscapeCr" ) )
        {
            factory.setProperty( "com.ctc.wstx.outputEscapeCr", Boolean.FALSE );
            supportWindowsLineEndings = true;
        }
        if ( factory.isPropertySupported( "org.codehaus.stax2.automaticEmptyElements" ) )
        {
            factory.setProperty( "org.codehaus.stax2.automaticEmptyElements", Boolean.FALSE );
        }
        IndentingXMLStreamWriter serializer = new IndentingXMLStreamWriter( factory.createXMLStreamWriter( writer ) );
        if ( supportWindowsLineEndings )
        {
            serializer.setNewLine( serializer.getLineSeparator() );
        }
        serializer.writeStartDocument( rbacDatabase.getModelEncoding(), "1.0" );
        writeRbacDatabase( rbacDatabase, "rbacDatabase", serializer );
        serializer.writeEndDocument();
    } //-- void write(Writer, RbacDatabase) 

    /**
     * Method writeDom.
     * 
     * @param dom
     * @param serializer
     * @throws XMLStreamException
     */
    public void writeDom(Xpp3Dom dom, XMLStreamWriter serializer)
        throws XMLStreamException
    {
        serializer.writeStartElement( dom.getName() );
        String[] attributeNames = dom.getAttributeNames();
        for ( int i = 0; i < attributeNames.length; i++ )
        {
            String attributeName = attributeNames[i];
            serializer.writeAttribute( attributeName, dom.getAttribute( attributeName ) );
        }
        Xpp3Dom[] children = dom.getChildren();
        for ( int i = 0; i < children.length; i++ )
        {
            writeDom( children[i], serializer );
        }
        String value = dom.getValue();
        if ( value != null )
        {
            serializer.writeCharacters( value );
        }
        serializer.writeEndElement();
    } //-- void writeDom(Xpp3Dom, XMLStreamWriter) 

    /**
     * Method writeJdoOperation.
     * 
     * @param jdoOperation
     * @param serializer
     * @param tagName
     * @throws java.io.IOException
     * @throws XMLStreamException
     */
    private void writeJdoOperation(JdoOperation jdoOperation, String tagName, XMLStreamWriter serializer)
        throws java.io.IOException, XMLStreamException
    {
        if ( jdoOperation != null )
        {
            serializer.writeStartElement( tagName );
            if ( jdoOperation.getName() != null )
            {
                serializer.writeStartElement( "name" );
                serializer.writeCharacters( jdoOperation.getName() );
                serializer.writeEndElement();
            }
            if ( jdoOperation.getDescription() != null )
            {
                serializer.writeStartElement( "description" );
                serializer.writeCharacters( jdoOperation.getDescription() );
                serializer.writeEndElement();
            }
            if ( jdoOperation.isPermanent() != false )
            {
                serializer.writeStartElement( "permanent" );
                serializer.writeCharacters( String.valueOf( jdoOperation.isPermanent() ) );
                serializer.writeEndElement();
            }
            if ( jdoOperation.isResourceRequired() != false )
            {
                serializer.writeStartElement( "resourceRequired" );
                serializer.writeCharacters( String.valueOf( jdoOperation.isResourceRequired() ) );
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    } //-- void writeJdoOperation(JdoOperation, String, XMLStreamWriter) 

    /**
     * Method writeJdoPermission.
     * 
     * @param jdoPermission
     * @param serializer
     * @param tagName
     * @throws java.io.IOException
     * @throws XMLStreamException
     */
    private void writeJdoPermission(JdoPermission jdoPermission, String tagName, XMLStreamWriter serializer)
        throws java.io.IOException, XMLStreamException
    {
        if ( jdoPermission != null )
        {
            serializer.writeStartElement( tagName );
            if ( jdoPermission.getName() != null )
            {
                serializer.writeStartElement( "name" );
                serializer.writeCharacters( jdoPermission.getName() );
                serializer.writeEndElement();
            }
            if ( jdoPermission.getDescription() != null )
            {
                serializer.writeStartElement( "description" );
                serializer.writeCharacters( jdoPermission.getDescription() );
                serializer.writeEndElement();
            }
            if ( jdoPermission.isPermanent() != false )
            {
                serializer.writeStartElement( "permanent" );
                serializer.writeCharacters( String.valueOf( jdoPermission.isPermanent() ) );
                serializer.writeEndElement();
            }
            if ( jdoPermission.getOperation() != null )
            {
                serializer.writeStartElement( "operation" );
                serializer.writeAttribute( "name", jdoPermission.getOperation().getName() );
                serializer.writeEndElement();
            }
            if ( jdoPermission.getResource() != null )
            {
                serializer.writeStartElement( "resource" );
                serializer.writeAttribute( "identifier", jdoPermission.getResource().getIdentifier() );
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    } //-- void writeJdoPermission(JdoPermission, String, XMLStreamWriter) 

    /**
     * Method writeJdoResource.
     * 
     * @param jdoResource
     * @param serializer
     * @param tagName
     * @throws java.io.IOException
     * @throws XMLStreamException
     */
    private void writeJdoResource(JdoResource jdoResource, String tagName, XMLStreamWriter serializer)
        throws java.io.IOException, XMLStreamException
    {
        if ( jdoResource != null )
        {
            serializer.writeStartElement( tagName );
            if ( jdoResource.getIdentifier() != null )
            {
                serializer.writeStartElement( "identifier" );
                serializer.writeCharacters( jdoResource.getIdentifier() );
                serializer.writeEndElement();
            }
            if ( jdoResource.isPattern() != false )
            {
                serializer.writeStartElement( "pattern" );
                serializer.writeCharacters( String.valueOf( jdoResource.isPattern() ) );
                serializer.writeEndElement();
            }
            if ( jdoResource.isPermanent() != false )
            {
                serializer.writeStartElement( "permanent" );
                serializer.writeCharacters( String.valueOf( jdoResource.isPermanent() ) );
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    } //-- void writeJdoResource(JdoResource, String, XMLStreamWriter) 

    /**
     * Method writeJdoRole.
     * 
     * @param jdoRole
     * @param serializer
     * @param tagName
     * @throws java.io.IOException
     * @throws XMLStreamException
     */
    private void writeJdoRole(JdoRole jdoRole, String tagName, XMLStreamWriter serializer)
        throws java.io.IOException, XMLStreamException
    {
        if ( jdoRole != null )
        {
            serializer.writeStartElement( tagName );
            if ( jdoRole.getName() != null )
            {
                serializer.writeStartElement( "name" );
                serializer.writeCharacters( jdoRole.getName() );
                serializer.writeEndElement();
            }
            if ( jdoRole.getDescription() != null )
            {
                serializer.writeStartElement( "description" );
                serializer.writeCharacters( jdoRole.getDescription() );
                serializer.writeEndElement();
            }
            if ( jdoRole.isAssignable() != false )
            {
                serializer.writeStartElement( "assignable" );
                serializer.writeCharacters( String.valueOf( jdoRole.isAssignable() ) );
                serializer.writeEndElement();
            }
            if ( jdoRole.isPermanent() != false )
            {
                serializer.writeStartElement( "permanent" );
                serializer.writeCharacters( String.valueOf( jdoRole.isPermanent() ) );
                serializer.writeEndElement();
            }
            if ( jdoRole.getChildRoleNames() != null && jdoRole.getChildRoleNames().size() > 0 )
            {
                serializer.writeStartElement( "childRoleNames" );
                for ( Iterator iter = jdoRole.getChildRoleNames().iterator(); iter.hasNext(); )
                {
                    String childRoleName = (String) iter.next();
                    serializer.writeStartElement( "childRoleName" );
                    serializer.writeCharacters( childRoleName );
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            if ( jdoRole.getPermissions() != null && jdoRole.getPermissions().size() > 0 )
            {
                serializer.writeStartElement( "permissions" );
                for ( Iterator iter = jdoRole.getPermissions().iterator(); iter.hasNext(); )
                {
                    JdoPermission o = (JdoPermission) iter.next();
                    serializer.writeStartElement( "permission" );
                    serializer.writeAttribute( "name", o.getName() );
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    } //-- void writeJdoRole(JdoRole, String, XMLStreamWriter) 

    /**
     * Method writeJdoUserAssignment.
     * 
     * @param jdoUserAssignment
     * @param serializer
     * @param tagName
     * @throws java.io.IOException
     * @throws XMLStreamException
     */
    private void writeJdoUserAssignment(JdoUserAssignment jdoUserAssignment, String tagName, XMLStreamWriter serializer)
        throws java.io.IOException, XMLStreamException
    {
        if ( jdoUserAssignment != null )
        {
            serializer.writeStartElement( tagName );
            if ( jdoUserAssignment.getPrincipal() != null )
            {
                serializer.writeStartElement( "principal" );
                serializer.writeCharacters( jdoUserAssignment.getPrincipal() );
                serializer.writeEndElement();
            }
            if ( jdoUserAssignment.getTimestamp() != null )
            {
                serializer.writeStartElement( "timestamp" );
                serializer.writeCharacters( Long.toString( jdoUserAssignment.getTimestamp().getTime() ) );
                serializer.writeEndElement();
            }
            if ( jdoUserAssignment.isPermanent() != false )
            {
                serializer.writeStartElement( "permanent" );
                serializer.writeCharacters( String.valueOf( jdoUserAssignment.isPermanent() ) );
                serializer.writeEndElement();
            }
            if ( jdoUserAssignment.getRoleNames() != null && jdoUserAssignment.getRoleNames().size() > 0 )
            {
                serializer.writeStartElement( "roleNames" );
                for ( Iterator iter = jdoUserAssignment.getRoleNames().iterator(); iter.hasNext(); )
                {
                    String roleName = (String) iter.next();
                    serializer.writeStartElement( "roleName" );
                    serializer.writeCharacters( roleName );
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    } //-- void writeJdoUserAssignment(JdoUserAssignment, String, XMLStreamWriter) 

    /**
     * Method writeRbacDatabase.
     * 
     * @param rbacDatabase
     * @param serializer
     * @param tagName
     * @throws java.io.IOException
     * @throws XMLStreamException
     */
    private void writeRbacDatabase(RbacDatabase rbacDatabase, String tagName, XMLStreamWriter serializer)
        throws java.io.IOException, XMLStreamException
    {
        if ( rbacDatabase != null )
        {
            serializer.writeStartElement( tagName );
            if ( rbacDatabase.getRoles() != null && rbacDatabase.getRoles().size() > 0 )
            {
                serializer.writeStartElement( "roles" );
                for ( Iterator iter = rbacDatabase.getRoles().iterator(); iter.hasNext(); )
                {
                    JdoRole o = (JdoRole) iter.next();
                    writeJdoRole( o, "role", serializer );
                }
                serializer.writeEndElement();
            }
            if ( rbacDatabase.getPermissions() != null && rbacDatabase.getPermissions().size() > 0 )
            {
                serializer.writeStartElement( "permissions" );
                for ( Iterator iter = rbacDatabase.getPermissions().iterator(); iter.hasNext(); )
                {
                    JdoPermission o = (JdoPermission) iter.next();
                    writeJdoPermission( o, "permission", serializer );
                }
                serializer.writeEndElement();
            }
            if ( rbacDatabase.getOperations() != null && rbacDatabase.getOperations().size() > 0 )
            {
                serializer.writeStartElement( "operations" );
                for ( Iterator iter = rbacDatabase.getOperations().iterator(); iter.hasNext(); )
                {
                    JdoOperation o = (JdoOperation) iter.next();
                    writeJdoOperation( o, "operation", serializer );
                }
                serializer.writeEndElement();
            }
            if ( rbacDatabase.getResources() != null && rbacDatabase.getResources().size() > 0 )
            {
                serializer.writeStartElement( "resources" );
                for ( Iterator iter = rbacDatabase.getResources().iterator(); iter.hasNext(); )
                {
                    JdoResource o = (JdoResource) iter.next();
                    writeJdoResource( o, "resource", serializer );
                }
                serializer.writeEndElement();
            }
            if ( rbacDatabase.getUserAssignments() != null && rbacDatabase.getUserAssignments().size() > 0 )
            {
                serializer.writeStartElement( "userAssignments" );
                for ( Iterator iter = rbacDatabase.getUserAssignments().iterator(); iter.hasNext(); )
                {
                    JdoUserAssignment o = (JdoUserAssignment) iter.next();
                    writeJdoUserAssignment( o, "userAssignment", serializer );
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    } //-- void writeRbacDatabase(RbacDatabase, String, XMLStreamWriter) 


}
