/*
 * $Id$
 */

package org.codehaus.plexus.security.authorization.rbac.jdo.v0_9_0.io.stax;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.*;
import org.codehaus.plexus.security.authorization.rbac.jdo.v0_9_0.JdoOperation;
import org.codehaus.plexus.security.authorization.rbac.jdo.v0_9_0.JdoPermission;
import org.codehaus.plexus.security.authorization.rbac.jdo.v0_9_0.JdoResource;
import org.codehaus.plexus.security.authorization.rbac.jdo.v0_9_0.JdoRole;
import org.codehaus.plexus.security.authorization.rbac.jdo.v0_9_0.JdoUserAssignment;
import org.codehaus.plexus.security.authorization.rbac.jdo.v0_9_0.RbacDatabase;
import org.codehaus.plexus.util.xml.Xpp3Dom;

/**
 * Class RbacJdoModelStaxReader.
 * 
 * @version $Revision$ $Date$
 */
public class RbacJdoModelStaxReader {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field jdoPermissionReferences.
     */
    private java.util.Map jdoPermissionReferences;

    /**
     * Field jdoPermissionInstances.
     */
    private java.util.Map jdoPermissionInstances;

    /**
     * Field jdoOperationReferences.
     */
    private java.util.Map jdoOperationReferences;

    /**
     * Field jdoResourceReferences.
     */
    private java.util.Map jdoResourceReferences;

    /**
     * Field jdoOperationInstances.
     */
    private java.util.Map jdoOperationInstances;

    /**
     * Field jdoResourceInstances.
     */
    private java.util.Map jdoResourceInstances;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method buildDom.
     * 
     * @param xmlStreamReader
     * @throws XMLStreamException
     * @return Xpp3Dom
     */
    public Xpp3Dom buildDom(XMLStreamReader xmlStreamReader)
        throws XMLStreamException
    {
        java.util.List elements = new java.util.ArrayList();
        java.util.List values = new java.util.ArrayList();
        int eventType = xmlStreamReader.getEventType();
        while ( xmlStreamReader.hasNext() )
        {
            if ( eventType == XMLStreamConstants.START_ELEMENT )
            {
                String rawName = xmlStreamReader.getLocalName();
                Xpp3Dom childConfiguration = new Xpp3Dom( rawName );
                int depth = elements.size();
                if ( depth > 0 )
                {
                    Xpp3Dom parent = (Xpp3Dom) elements.get( depth - 1 );
                    parent.addChild( childConfiguration );
                }
                elements.add( childConfiguration );
                if ( xmlStreamReader.isEndElement() )
                {
                    values.add( null );
                }
                else
                {
                    values.add( new StringBuffer() );
                }
                int attributesSize = xmlStreamReader.getAttributeCount();
                for ( int i = 0; i < attributesSize; i++ )
                {
                    String name = xmlStreamReader.getAttributeLocalName( i );
                    String value = xmlStreamReader.getAttributeValue( i );
                    childConfiguration.setAttribute( name, value );
                }
            }
            else if ( eventType == XMLStreamConstants.CHARACTERS )
            {
                int depth = values.size() - 1;
                StringBuffer valueBuffer = (StringBuffer) values.get( depth );
                String text = xmlStreamReader.getText();
                text = text.trim();
                valueBuffer.append( text );
            }
            else if ( eventType == XMLStreamConstants.END_ELEMENT )
            {
                int depth = elements.size() - 1;
                Xpp3Dom finishedConfiguration = (Xpp3Dom) elements.remove( depth );
                // this Object could be null if it is a singleton tag
                Object accumulatedValue = values.remove( depth );
                if ( finishedConfiguration.getChildCount() == 0 )
                {
                    if ( accumulatedValue == null )
                    {
                        finishedConfiguration.setValue( null );
                    }
                    else
                    {
                        finishedConfiguration.setValue( accumulatedValue.toString() );
                    }
                }
                if ( depth == 0 )
                {
                    return finishedConfiguration;
                }
            }
            eventType = xmlStreamReader.next();
        }
        throw new IllegalStateException( "End of document found before returning to 0 depth" );
    } //-- Xpp3Dom buildDom(XMLStreamReader) 

    /**
     * Method getBooleanValue.
     * 
     * @param s
     * @param xmlStreamReader
     * @param attribute
     * @throws XMLStreamException
     * @return boolean
     */
    public boolean getBooleanValue(String s, String attribute, XMLStreamReader xmlStreamReader)
        throws XMLStreamException
    {
        if ( s != null )
        {
            return Boolean.valueOf( s ).booleanValue();
        }
        return false;
    } //-- boolean getBooleanValue(String, String, XMLStreamReader) 

    /**
     * Method getCharacterValue.
     * 
     * @param s
     * @param xmlStreamReader
     * @param attribute
     * @throws XMLStreamException
     * @return char
     */
    public char getCharacterValue(String s, String attribute, XMLStreamReader xmlStreamReader)
        throws XMLStreamException
    {
        if ( s != null )
        {
            return s.charAt( 0 );
        }
        return 0;
    } //-- char getCharacterValue(String, String, XMLStreamReader) 

    /**
     * Method getDateValue.
     * 
     * @param s
     * @param xmlStreamReader
     * @param dateFormat
     * @param attribute
     * @throws XMLStreamException
     * @return java.util.Date
     */
    public java.util.Date getDateValue(String s, String attribute, String dateFormat, XMLStreamReader xmlStreamReader)
        throws XMLStreamException
    {
        if ( s != null )
        {
            if ( dateFormat == null )
            {
                return new java.util.Date( Long.valueOf( s ).longValue() );
            }
            else
            {
                DateFormat dateParser = new java.text.SimpleDateFormat( dateFormat, Locale.US );
                try
                {
                    return dateParser.parse( s );
                }
                catch ( java.text.ParseException e )
                {
                    throw new XMLStreamException( e.getMessage() );
                }
            }
        }
        return null;
    } //-- java.util.Date getDateValue(String, String, String, XMLStreamReader) 

    /**
     * Method getDoubleValue.
     * 
     * @param s
     * @param strict
     * @param xmlStreamReader
     * @param attribute
     * @throws XMLStreamException
     * @return double
     */
    public double getDoubleValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict)
        throws XMLStreamException
    {
        if ( s != null )
        {
            try
            {
                return Double.valueOf( s ).doubleValue();
            }
            catch ( NumberFormatException e )
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unable to parse element '" + attribute + "', must be a floating point number but was '" + s + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        return 0;
    } //-- double getDoubleValue(String, String, XMLStreamReader, boolean) 

    /**
     * Method getFloatValue.
     * 
     * @param s
     * @param strict
     * @param xmlStreamReader
     * @param attribute
     * @throws XMLStreamException
     * @return float
     */
    public float getFloatValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict)
        throws XMLStreamException
    {
        if ( s != null )
        {
            try
            {
                return Float.valueOf( s ).floatValue();
            }
            catch ( NumberFormatException e )
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unable to parse element '" + attribute + "', must be a floating point number but was '" + s + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        return 0;
    } //-- float getFloatValue(String, String, XMLStreamReader, boolean) 

    /**
     * Method getIntegerValue.
     * 
     * @param s
     * @param strict
     * @param xmlStreamReader
     * @param attribute
     * @throws XMLStreamException
     * @return int
     */
    public int getIntegerValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict)
        throws XMLStreamException
    {
        if ( s != null )
        {
            try
            {
                return Integer.valueOf( s ).intValue();
            }
            catch ( NumberFormatException e )
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unable to parse element '" + attribute + "', must be an integer but was '" + s + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        return 0;
    } //-- int getIntegerValue(String, String, XMLStreamReader, boolean) 

    /**
     * Method getLongValue.
     * 
     * @param s
     * @param strict
     * @param xmlStreamReader
     * @param attribute
     * @throws XMLStreamException
     * @return long
     */
    public long getLongValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict)
        throws XMLStreamException
    {
        if ( s != null )
        {
            try
            {
                return Long.valueOf( s ).longValue();
            }
            catch ( NumberFormatException e )
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unable to parse element '" + attribute + "', must be a long integer but was '" + s + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        return 0;
    } //-- long getLongValue(String, String, XMLStreamReader, boolean) 

    /**
     * Method getRequiredAttributeValue.
     * 
     * @param s
     * @param strict
     * @param xmlStreamReader
     * @param attribute
     * @throws XMLStreamException
     * @return String
     */
    public String getRequiredAttributeValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict)
        throws XMLStreamException
    {
        if ( s == null )
        {
            if ( strict )
            {
                throw new XMLStreamException( "Missing required value for attribute '" + attribute + "'", xmlStreamReader.getLocation() );
            }
        }
        return s;
    } //-- String getRequiredAttributeValue(String, String, XMLStreamReader, boolean) 

    /**
     * Method getShortValue.
     * 
     * @param s
     * @param strict
     * @param xmlStreamReader
     * @param attribute
     * @throws XMLStreamException
     * @return short
     */
    public short getShortValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict)
        throws XMLStreamException
    {
        if ( s != null )
        {
            try
            {
                return Short.valueOf( s ).shortValue();
            }
            catch ( NumberFormatException e )
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unable to parse element '" + attribute + "', must be a short integer but was '" + s + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        return 0;
    } //-- short getShortValue(String, String, XMLStreamReader, boolean) 

    /**
     * Method getTrimmedValue.
     * 
     * @param s
     * @return String
     */
    public String getTrimmedValue(String s)
    {
        if ( s != null )
        {
            s = s.trim();
        }
        return s;
    } //-- String getTrimmedValue(String) 

    /**
     * Method parseJdoOperation.
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param xmlStreamReader
     * @throws IOException
     * @throws XMLStreamException
     * @return JdoOperation
     */
    private JdoOperation parseJdoOperation(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding)
        throws IOException, XMLStreamException
    {
        JdoOperation jdoOperation = new JdoOperation();
        jdoOperation.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        if ( jdoOperationInstances == null )
        {
            jdoOperationInstances = new java.util.HashMap();
        }
        String v = xmlStreamReader.getAttributeValue( null, "modello.id" );
        if ( v != null )
        {
            jdoOperationInstances.put( v, jdoOperation);
        }
        while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
        {
            if ( xmlStreamReader.getLocalName().equals( "name" )  )
            {
                if ( parsed.contains( "name" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "name" );
                jdoOperation.setName( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "description" )  )
            {
                if ( parsed.contains( "description" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "description" );
                jdoOperation.setDescription( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "permanent" )  )
            {
                if ( parsed.contains( "permanent" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "permanent" );
                jdoOperation.setPermanent( getBooleanValue( getTrimmedValue( xmlStreamReader.getElementText()), "permanent", xmlStreamReader ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "resourceRequired" )  )
            {
                if ( parsed.contains( "resourceRequired" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "resourceRequired" );
                jdoOperation.setResourceRequired( getBooleanValue( getTrimmedValue( xmlStreamReader.getElementText()), "resourceRequired", xmlStreamReader ) );
            }
            else
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        jdoOperationInstances.put( jdoOperation.getName(), jdoOperation);
        return jdoOperation;
    } //-- JdoOperation parseJdoOperation(String, XMLStreamReader, boolean, String) 

    /**
     * Method parseJdoPermission.
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param xmlStreamReader
     * @throws IOException
     * @throws XMLStreamException
     * @return JdoPermission
     */
    private JdoPermission parseJdoPermission(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding)
        throws IOException, XMLStreamException
    {
        JdoPermission jdoPermission = new JdoPermission();
        jdoPermission.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        if ( jdoPermissionInstances == null )
        {
            jdoPermissionInstances = new java.util.HashMap();
        }
        String v = xmlStreamReader.getAttributeValue( null, "modello.id" );
        if ( v != null )
        {
            jdoPermissionInstances.put( v, jdoPermission);
        }
        while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
        {
            if ( xmlStreamReader.getLocalName().equals( "name" )  )
            {
                if ( parsed.contains( "name" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "name" );
                jdoPermission.setName( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "description" )  )
            {
                if ( parsed.contains( "description" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "description" );
                jdoPermission.setDescription( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "permanent" )  )
            {
                if ( parsed.contains( "permanent" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "permanent" );
                jdoPermission.setPermanent( getBooleanValue( getTrimmedValue( xmlStreamReader.getElementText()), "permanent", xmlStreamReader ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "operation" )  )
            {
                if ( parsed.contains( "operation" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "operation" );
                String value = xmlStreamReader.getAttributeValue( null, "name" );
                if ( value != null )
                {
                    // This is a reference to an element elsewhere in the model
                    if ( jdoOperationReferences == null )
                    {
                        jdoOperationReferences = new java.util.HashMap();
                    }
                    java.util.Map refs = (java.util.Map) jdoOperationReferences.get( jdoPermission );
                    if ( refs == null )
                    {
                        refs = new java.util.HashMap();
                        jdoOperationReferences.put( jdoPermission, refs );
                    }
                    refs.put( "operation", value );
                }
                while ( xmlStreamReader.getEventType() != XMLStreamConstants.END_ELEMENT )
                {
                    xmlStreamReader.next();
                }
            }
            else if ( xmlStreamReader.getLocalName().equals( "resource" )  )
            {
                if ( parsed.contains( "resource" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "resource" );
                String value = xmlStreamReader.getAttributeValue( null, "identifier" );
                if ( value != null )
                {
                    // This is a reference to an element elsewhere in the model
                    if ( jdoResourceReferences == null )
                    {
                        jdoResourceReferences = new java.util.HashMap();
                    }
                    java.util.Map refs = (java.util.Map) jdoResourceReferences.get( jdoPermission );
                    if ( refs == null )
                    {
                        refs = new java.util.HashMap();
                        jdoResourceReferences.put( jdoPermission, refs );
                    }
                    refs.put( "resource", value );
                }
                while ( xmlStreamReader.getEventType() != XMLStreamConstants.END_ELEMENT )
                {
                    xmlStreamReader.next();
                }
            }
            else
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        jdoPermissionInstances.put( jdoPermission.getName(), jdoPermission);
        return jdoPermission;
    } //-- JdoPermission parseJdoPermission(String, XMLStreamReader, boolean, String) 

    /**
     * Method parseJdoResource.
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param xmlStreamReader
     * @throws IOException
     * @throws XMLStreamException
     * @return JdoResource
     */
    private JdoResource parseJdoResource(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding)
        throws IOException, XMLStreamException
    {
        JdoResource jdoResource = new JdoResource();
        jdoResource.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        if ( jdoResourceInstances == null )
        {
            jdoResourceInstances = new java.util.HashMap();
        }
        String v = xmlStreamReader.getAttributeValue( null, "modello.id" );
        if ( v != null )
        {
            jdoResourceInstances.put( v, jdoResource);
        }
        while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
        {
            if ( xmlStreamReader.getLocalName().equals( "identifier" )  )
            {
                if ( parsed.contains( "identifier" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "identifier" );
                jdoResource.setIdentifier( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "pattern" )  )
            {
                if ( parsed.contains( "pattern" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "pattern" );
                jdoResource.setPattern( getBooleanValue( getTrimmedValue( xmlStreamReader.getElementText()), "pattern", xmlStreamReader ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "permanent" )  )
            {
                if ( parsed.contains( "permanent" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "permanent" );
                jdoResource.setPermanent( getBooleanValue( getTrimmedValue( xmlStreamReader.getElementText()), "permanent", xmlStreamReader ) );
            }
            else
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        jdoResourceInstances.put( jdoResource.getIdentifier(), jdoResource);
        return jdoResource;
    } //-- JdoResource parseJdoResource(String, XMLStreamReader, boolean, String) 

    /**
     * Method parseJdoRole.
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param xmlStreamReader
     * @throws IOException
     * @throws XMLStreamException
     * @return JdoRole
     */
    private JdoRole parseJdoRole(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding)
        throws IOException, XMLStreamException
    {
        JdoRole jdoRole = new JdoRole();
        jdoRole.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
        {
            if ( xmlStreamReader.getLocalName().equals( "name" )  )
            {
                if ( parsed.contains( "name" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "name" );
                jdoRole.setName( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "description" )  )
            {
                if ( parsed.contains( "description" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "description" );
                jdoRole.setDescription( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "assignable" )  )
            {
                if ( parsed.contains( "assignable" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "assignable" );
                jdoRole.setAssignable( getBooleanValue( getTrimmedValue( xmlStreamReader.getElementText()), "assignable", xmlStreamReader ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "permanent" )  )
            {
                if ( parsed.contains( "permanent" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "permanent" );
                jdoRole.setPermanent( getBooleanValue( getTrimmedValue( xmlStreamReader.getElementText()), "permanent", xmlStreamReader ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "childRoleNames" )  )
            {
                if ( parsed.contains( "childRoleNames" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "childRoleNames" );
                java.util.List childRoleNames = new java.util.ArrayList();
                jdoRole.setChildRoleNames( childRoleNames );
                while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                {
                    if ( xmlStreamReader.getLocalName().equals( "childRoleName" ) )
                    {
                        childRoleNames.add( getTrimmedValue( xmlStreamReader.getElementText()) );
                    }
                    else
                    {
                        throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                }
            }
            else if ( xmlStreamReader.getLocalName().equals( "permissions" )  )
            {
                if ( parsed.contains( "permissions" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "permissions" );
                java.util.List permissions = new java.util.ArrayList();
                jdoRole.setPermissions( permissions );
                while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                {
                    if ( xmlStreamReader.getLocalName().equals( "permission" ) )
                    {
                        String value = xmlStreamReader.getAttributeValue( null, "name" );
                        if ( value != null )
                        {
                            // This is a reference to an element elsewhere in the model
                            if ( jdoPermissionReferences == null )
                            {
                                jdoPermissionReferences = new java.util.HashMap();
                            }
                            java.util.Map refs = (java.util.Map) jdoPermissionReferences.get( jdoRole );
                            if ( refs == null )
                            {
                                refs = new java.util.HashMap();
                                jdoPermissionReferences.put( jdoRole, refs );
                            }
                            refs.put( "permissions." + permissions.size(), value );
                        }
                        jdoRole.addPermission( parseJdoPermission( "permission", xmlStreamReader, strict, encoding ) );
                    }
                    else
                    {
                        throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                }
            }
            else
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        return jdoRole;
    } //-- JdoRole parseJdoRole(String, XMLStreamReader, boolean, String) 

    /**
     * Method parseJdoUserAssignment.
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param xmlStreamReader
     * @throws IOException
     * @throws XMLStreamException
     * @return JdoUserAssignment
     */
    private JdoUserAssignment parseJdoUserAssignment(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding)
        throws IOException, XMLStreamException
    {
        JdoUserAssignment jdoUserAssignment = new JdoUserAssignment();
        jdoUserAssignment.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
        {
            if ( xmlStreamReader.getLocalName().equals( "principal" )  )
            {
                if ( parsed.contains( "principal" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "principal" );
                jdoUserAssignment.setPrincipal( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "timestamp" )  )
            {
                if ( parsed.contains( "timestamp" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "timestamp" );
                String dateFormat = null;
                jdoUserAssignment.setTimestamp( getDateValue( getTrimmedValue( xmlStreamReader.getElementText()), "timestamp", dateFormat, xmlStreamReader ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "permanent" )  )
            {
                if ( parsed.contains( "permanent" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "permanent" );
                jdoUserAssignment.setPermanent( getBooleanValue( getTrimmedValue( xmlStreamReader.getElementText()), "permanent", xmlStreamReader ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "roleNames" )  )
            {
                if ( parsed.contains( "roleNames" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "roleNames" );
                java.util.List roleNames = new java.util.ArrayList();
                jdoUserAssignment.setRoleNames( roleNames );
                while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                {
                    if ( xmlStreamReader.getLocalName().equals( "roleName" ) )
                    {
                        roleNames.add( getTrimmedValue( xmlStreamReader.getElementText()) );
                    }
                    else
                    {
                        throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                }
            }
            else
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        return jdoUserAssignment;
    } //-- JdoUserAssignment parseJdoUserAssignment(String, XMLStreamReader, boolean, String) 

    /**
     * Method parseRbacDatabase.
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param xmlStreamReader
     * @throws IOException
     * @throws XMLStreamException
     * @return RbacDatabase
     */
    private RbacDatabase parseRbacDatabase(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding)
        throws IOException, XMLStreamException
    {
        RbacDatabase rbacDatabase = new RbacDatabase();
        rbacDatabase.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        boolean foundRoot = false;
        while ( xmlStreamReader.hasNext() )
        {
            int eventType = xmlStreamReader.next();
            if ( eventType == XMLStreamConstants.START_ELEMENT )
            {
                if ( xmlStreamReader.getLocalName().equals( tagName ) )
                {
                    foundRoot = true;
                }
                else if ( xmlStreamReader.getLocalName().equals( "roles" )  )
                {
                    if ( parsed.contains( "roles" ) )
                    {
                        throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                    parsed.add( "roles" );
                    java.util.List roles = new java.util.ArrayList();
                    rbacDatabase.setRoles( roles );
                    while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                    {
                        if ( xmlStreamReader.getLocalName().equals( "role" ) )
                        {
                            rbacDatabase.addRole( parseJdoRole( "role", xmlStreamReader, strict, encoding ) );
                        }
                        else
                        {
                            throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                        }
                    }
                }
                else if ( xmlStreamReader.getLocalName().equals( "permissions" )  )
                {
                    if ( parsed.contains( "permissions" ) )
                    {
                        throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                    parsed.add( "permissions" );
                    java.util.List permissions = new java.util.ArrayList();
                    rbacDatabase.setPermissions( permissions );
                    while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                    {
                        if ( xmlStreamReader.getLocalName().equals( "permission" ) )
                        {
                            rbacDatabase.addPermission( parseJdoPermission( "permission", xmlStreamReader, strict, encoding ) );
                        }
                        else
                        {
                            throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                        }
                    }
                }
                else if ( xmlStreamReader.getLocalName().equals( "operations" )  )
                {
                    if ( parsed.contains( "operations" ) )
                    {
                        throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                    parsed.add( "operations" );
                    java.util.List operations = new java.util.ArrayList();
                    rbacDatabase.setOperations( operations );
                    while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                    {
                        if ( xmlStreamReader.getLocalName().equals( "operation" ) )
                        {
                            rbacDatabase.addOperation( parseJdoOperation( "operation", xmlStreamReader, strict, encoding ) );
                        }
                        else
                        {
                            throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                        }
                    }
                }
                else if ( xmlStreamReader.getLocalName().equals( "resources" )  )
                {
                    if ( parsed.contains( "resources" ) )
                    {
                        throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                    parsed.add( "resources" );
                    java.util.List resources = new java.util.ArrayList();
                    rbacDatabase.setResources( resources );
                    while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                    {
                        if ( xmlStreamReader.getLocalName().equals( "resource" ) )
                        {
                            rbacDatabase.addResource( parseJdoResource( "resource", xmlStreamReader, strict, encoding ) );
                        }
                        else
                        {
                            throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                        }
                    }
                }
                else if ( xmlStreamReader.getLocalName().equals( "userAssignments" )  )
                {
                    if ( parsed.contains( "userAssignments" ) )
                    {
                        throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                    parsed.add( "userAssignments" );
                    java.util.List userAssignments = new java.util.ArrayList();
                    rbacDatabase.setUserAssignments( userAssignments );
                    while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                    {
                        if ( xmlStreamReader.getLocalName().equals( "userAssignment" ) )
                        {
                            rbacDatabase.addUserAssignment( parseJdoUserAssignment( "userAssignment", xmlStreamReader, strict, encoding ) );
                        }
                        else
                        {
                            throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                        }
                    }
                }
                else
                {
                    if ( foundRoot )
                    {
                        if ( strict )
                        {
                            throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                        }
                    }
                }
            }
        }
        return rbacDatabase;
    } //-- RbacDatabase parseRbacDatabase(String, XMLStreamReader, boolean, String) 

    /**
     * Method read.
     * 
     * @param reader
     * @param strict
     * @throws IOException
     * @throws XMLStreamException
     * @return RbacDatabase
     */
    public RbacDatabase read(Reader reader, boolean strict)
        throws IOException, XMLStreamException
    {
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader( reader );
        
        String encoding = xmlStreamReader.getCharacterEncodingScheme();
        RbacDatabase value = parseRbacDatabase( "rbacDatabase", xmlStreamReader, strict, encoding );
        resolveReferences( value );
        return value;
    } //-- RbacDatabase read(Reader, boolean) 

    /**
     * Method read.
     * 
     * @param reader
     * @throws IOException
     * @throws XMLStreamException
     * @return RbacDatabase
     */
    public RbacDatabase read(Reader reader)
        throws IOException, XMLStreamException
    {
        return read( reader, true );
    } //-- RbacDatabase read(Reader) 

    /**
     * Method read.
     * 
     * @param filePath
     * @param strict
     * @throws IOException
     * @throws XMLStreamException
     * @return RbacDatabase
     */
    public RbacDatabase read(String filePath, boolean strict)
        throws IOException, XMLStreamException
    {
        File file = new File(filePath);
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader( file.toURL().toExternalForm(), new FileInputStream(file) );
        
        String encoding = xmlStreamReader.getCharacterEncodingScheme();
        RbacDatabase value = parseRbacDatabase( "rbacDatabase", xmlStreamReader, strict, encoding );
        resolveReferences( value );
        return value;
    } //-- RbacDatabase read(String, boolean) 

    /**
     * Method read.
     * 
     * @param filePath
     * @throws IOException
     * @throws XMLStreamException
     * @return RbacDatabase
     */
    public RbacDatabase read(String filePath)
        throws IOException, XMLStreamException
    {
        return read( filePath, true );
    } //-- RbacDatabase read(String) 

    /**
     * Method resolveReferences.
     * 
     * @param value
     */
    private void resolveReferences(RbacDatabase value)
    {
        java.util.Map refs;
        for ( java.util.Iterator i = value.getRoles().iterator(); i.hasNext(); )
        {
            resolveReferences( (JdoRole) i.next() );
        }
        for ( java.util.Iterator i = value.getPermissions().iterator(); i.hasNext(); )
        {
            resolveReferences( (JdoPermission) i.next() );
        }
    } //-- void resolveReferences(RbacDatabase) 

    /**
     * Method resolveReferences.
     * 
     * @param value
     */
    private void resolveReferences(JdoRole value)
    {
        java.util.Map refs;
        if ( jdoPermissionReferences != null )
        {
            refs = (java.util.Map) jdoPermissionReferences.get( value );
            if ( refs != null )
            {
                for ( int i = 0; i < value.getPermissions().size(); i++ )
                {
                    String id = (String) refs.get( "permissions." + i );
                    JdoPermission ref = (JdoPermission) jdoPermissionInstances.get( id );
                    if ( ref != null )
                    {
                        value.getPermissions().set( i, ref );
                    }
                }
            }
        }
    } //-- void resolveReferences(JdoRole) 

    /**
     * Method resolveReferences.
     * 
     * @param value
     */
    private void resolveReferences(JdoPermission value)
    {
        java.util.Map refs;
        if ( jdoOperationReferences != null )
        {
            refs = (java.util.Map) jdoOperationReferences.get( value );
            if ( refs != null )
            {
                String id = (String) refs.get( "operation" );
                JdoOperation ref = (JdoOperation) jdoOperationInstances.get( id );
                if ( ref != null && !ref.equals( value.getOperation() ) )
                {
                    value.setOperation( ref );
                }
            }
        }
        if ( jdoResourceReferences != null )
        {
            refs = (java.util.Map) jdoResourceReferences.get( value );
            if ( refs != null )
            {
                String id = (String) refs.get( "resource" );
                JdoResource ref = (JdoResource) jdoResourceInstances.get( id );
                if ( ref != null && !ref.equals( value.getResource() ) )
                {
                    value.setResource( ref );
                }
            }
        }
    } //-- void resolveReferences(JdoPermission) 


}
