/*
 * $Id$
 */

package org.codehaus.plexus.security.authorization.rbac.jdo.v0_9_0;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Class RbacDatabase.
 * 
 * @version $Revision$ $Date$
 */
public class RbacDatabase implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field roles.
     */
    private java.util.List roles;

    /**
     * Field permissions.
     */
    private java.util.List permissions;

    /**
     * Field operations.
     */
    private java.util.List operations;

    /**
     * Field resources.
     */
    private java.util.List resources;

    /**
     * Field userAssignments.
     */
    private java.util.List userAssignments;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addOperation.
     * 
     * @param jdoOperation
     */
    public void addOperation(JdoOperation jdoOperation)
    {
        if ( !(jdoOperation instanceof JdoOperation) )
        {
            throw new ClassCastException( "RbacDatabase.addOperations(jdoOperation) parameter must be instanceof " + JdoOperation.class.getName() );
        }
        getOperations().add( jdoOperation );
    } //-- void addOperation(JdoOperation) 

    /**
     * Method addPermission.
     * 
     * @param jdoPermission
     */
    public void addPermission(JdoPermission jdoPermission)
    {
        if ( !(jdoPermission instanceof JdoPermission) )
        {
            throw new ClassCastException( "RbacDatabase.addPermissions(jdoPermission) parameter must be instanceof " + JdoPermission.class.getName() );
        }
        getPermissions().add( jdoPermission );
    } //-- void addPermission(JdoPermission) 

    /**
     * Method addResource.
     * 
     * @param jdoResource
     */
    public void addResource(JdoResource jdoResource)
    {
        if ( !(jdoResource instanceof JdoResource) )
        {
            throw new ClassCastException( "RbacDatabase.addResources(jdoResource) parameter must be instanceof " + JdoResource.class.getName() );
        }
        getResources().add( jdoResource );
    } //-- void addResource(JdoResource) 

    /**
     * Method addRole.
     * 
     * @param jdoRole
     */
    public void addRole(JdoRole jdoRole)
    {
        if ( !(jdoRole instanceof JdoRole) )
        {
            throw new ClassCastException( "RbacDatabase.addRoles(jdoRole) parameter must be instanceof " + JdoRole.class.getName() );
        }
        getRoles().add( jdoRole );
    } //-- void addRole(JdoRole) 

    /**
     * Method addUserAssignment.
     * 
     * @param jdoUserAssignment
     */
    public void addUserAssignment(JdoUserAssignment jdoUserAssignment)
    {
        if ( !(jdoUserAssignment instanceof JdoUserAssignment) )
        {
            throw new ClassCastException( "RbacDatabase.addUserAssignments(jdoUserAssignment) parameter must be instanceof " + JdoUserAssignment.class.getName() );
        }
        getUserAssignments().add( jdoUserAssignment );
    } //-- void addUserAssignment(JdoUserAssignment) 

    /**
     * Method getOperations.
     * 
     * @return java.util.List
     */
    public java.util.List getOperations()
    {
        if ( this.operations == null )
        {
            this.operations = new java.util.ArrayList();
        }
        
        return this.operations;
    } //-- java.util.List getOperations() 

    /**
     * Method getPermissions.
     * 
     * @return java.util.List
     */
    public java.util.List getPermissions()
    {
        if ( this.permissions == null )
        {
            this.permissions = new java.util.ArrayList();
        }
        
        return this.permissions;
    } //-- java.util.List getPermissions() 

    /**
     * Method getResources.
     * 
     * @return java.util.List
     */
    public java.util.List getResources()
    {
        if ( this.resources == null )
        {
            this.resources = new java.util.ArrayList();
        }
        
        return this.resources;
    } //-- java.util.List getResources() 

    /**
     * Method getRoles.
     * 
     * @return java.util.List
     */
    public java.util.List getRoles()
    {
        if ( this.roles == null )
        {
            this.roles = new java.util.ArrayList();
        }
        
        return this.roles;
    } //-- java.util.List getRoles() 

    /**
     * Method getUserAssignments.
     * 
     * @return java.util.List
     */
    public java.util.List getUserAssignments()
    {
        if ( this.userAssignments == null )
        {
            this.userAssignments = new java.util.ArrayList();
        }
        
        return this.userAssignments;
    } //-- java.util.List getUserAssignments() 

    /**
     * Method removeOperation.
     * 
     * @param jdoOperation
     */
    public void removeOperation(JdoOperation jdoOperation)
    {
        if ( !(jdoOperation instanceof JdoOperation) )
        {
            throw new ClassCastException( "RbacDatabase.removeOperations(jdoOperation) parameter must be instanceof " + JdoOperation.class.getName() );
        }
        getOperations().remove( jdoOperation );
    } //-- void removeOperation(JdoOperation) 

    /**
     * Method removePermission.
     * 
     * @param jdoPermission
     */
    public void removePermission(JdoPermission jdoPermission)
    {
        if ( !(jdoPermission instanceof JdoPermission) )
        {
            throw new ClassCastException( "RbacDatabase.removePermissions(jdoPermission) parameter must be instanceof " + JdoPermission.class.getName() );
        }
        getPermissions().remove( jdoPermission );
    } //-- void removePermission(JdoPermission) 

    /**
     * Method removeResource.
     * 
     * @param jdoResource
     */
    public void removeResource(JdoResource jdoResource)
    {
        if ( !(jdoResource instanceof JdoResource) )
        {
            throw new ClassCastException( "RbacDatabase.removeResources(jdoResource) parameter must be instanceof " + JdoResource.class.getName() );
        }
        getResources().remove( jdoResource );
    } //-- void removeResource(JdoResource) 

    /**
     * Method removeRole.
     * 
     * @param jdoRole
     */
    public void removeRole(JdoRole jdoRole)
    {
        if ( !(jdoRole instanceof JdoRole) )
        {
            throw new ClassCastException( "RbacDatabase.removeRoles(jdoRole) parameter must be instanceof " + JdoRole.class.getName() );
        }
        getRoles().remove( jdoRole );
    } //-- void removeRole(JdoRole) 

    /**
     * Method removeUserAssignment.
     * 
     * @param jdoUserAssignment
     */
    public void removeUserAssignment(JdoUserAssignment jdoUserAssignment)
    {
        if ( !(jdoUserAssignment instanceof JdoUserAssignment) )
        {
            throw new ClassCastException( "RbacDatabase.removeUserAssignments(jdoUserAssignment) parameter must be instanceof " + JdoUserAssignment.class.getName() );
        }
        getUserAssignments().remove( jdoUserAssignment );
    } //-- void removeUserAssignment(JdoUserAssignment) 

    /**
     * Set the operations field.
     * 
     * @param operations
     */
    public void setOperations(java.util.List operations)
    {
        this.operations = operations;
    } //-- void setOperations(java.util.List) 

    /**
     * Set the permissions field.
     * 
     * @param permissions
     */
    public void setPermissions(java.util.List permissions)
    {
        this.permissions = permissions;
    } //-- void setPermissions(java.util.List) 

    /**
     * Set the resources field.
     * 
     * @param resources
     */
    public void setResources(java.util.List resources)
    {
        this.resources = resources;
    } //-- void setResources(java.util.List) 

    /**
     * Set the roles field.
     * 
     * @param roles
     */
    public void setRoles(java.util.List roles)
    {
        this.roles = roles;
    } //-- void setRoles(java.util.List) 

    /**
     * Set the userAssignments field.
     * 
     * @param userAssignments
     */
    public void setUserAssignments(java.util.List userAssignments)
    {
        this.userAssignments = userAssignments;
    } //-- void setUserAssignments(java.util.List) 


    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
