/*
 * $Id$
 */

package org.codehaus.plexus.security.authorization.rbac.jdo.v0_9_0;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Class JdoRole.
 * 
 * @version $Revision$ $Date$
 */
public class JdoRole extends org.codehaus.plexus.security.rbac.AbstractRole 
implements org.codehaus.plexus.security.rbac.Role, java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field name.
     */
    private String name;

    /**
     * Field description.
     */
    private String description;

    /**
     * 
     *             true if this role is available to be assigned to
     * a user
     *           .
     */
    private boolean assignable = false;

    /**
     * 
     *             true if this object is permanent.
     *           
     */
    private boolean permanent = false;

    /**
     * Field childRoleNames.
     */
    private java.util.List childRoleNames = new java.util.ArrayList();

    /**
     * Field permissions.
     */
    private java.util.List permissions = new java.util.ArrayList();


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addChildRoleName.
     * 
     * @param string
     */
    public void addChildRoleName(String string)
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "JdoRole.addChildRoleNames(string) parameter must be instanceof " + String.class.getName() );
        }
        getChildRoleNames().add( string );
    } //-- void addChildRoleName(String) 

    /**
     * Method addPermission.
     * 
     * @param jdoPermission
     */
    public void addPermission(org.codehaus.plexus.security.rbac.Permission jdoPermission)
    {
        if ( !(jdoPermission instanceof JdoPermission) )
        {
            throw new ClassCastException( "JdoRole.addPermissions(jdoPermission) parameter must be instanceof " + JdoPermission.class.getName() );
        }
        getPermissions().add( ( (JdoPermission) jdoPermission ) );
    } //-- void addPermission(org.codehaus.plexus.security.rbac.Permission) 

    /**
     * Method equals.
     * 
     * @param other
     * @return boolean
     */
    public boolean equals(Object other)
    {
        if ( this == other)
        {
            return true;
        }
        
        if ( !(other instanceof JdoRole) )
        {
            return false;
        }
        
        JdoRole that = (JdoRole) other;
        boolean result = true;
        
        result = result && ( getName() == null ? that.getName() == null : getName().equals( that.getName() ) );
        result = result && ( super.equals( other ) );
        
        return result;
    } //-- boolean equals(Object) 

    /**
     * Method getChildRoleNames.
     * 
     * @return java.util.List
     */
    public java.util.List getChildRoleNames()
    {
        return this.childRoleNames;
    } //-- java.util.List getChildRoleNames() 

    /**
     * Get the description field.
     * 
     * @return String
     */
    public String getDescription()
    {
        return this.description;
    } //-- String getDescription() 

    /**
     * Get the name field.
     * 
     * @return String
     */
    public String getName()
    {
        return this.name;
    } //-- String getName() 

    /**
     * Method getPermissions.
     * 
     * @return java.util.List
     */
    public java.util.List getPermissions()
    {
        return this.permissions;
    } //-- java.util.List getPermissions() 

    /**
     * Method hashCode.
     * 
     * @return int
     */
    public int hashCode()
    {
        int result = 17;
        
        result = 37 * result + ( name != null ? name.hashCode() : 0 );
        result = 37 * result + super.hashCode();
        
        return result;
    } //-- int hashCode() 

    /**
     * Get 
     *             true if this role is available to be assigned to
     * a user
     *           .
     * 
     * @return boolean
     */
    public boolean isAssignable()
    {
        return this.assignable;
    } //-- boolean isAssignable() 

    /**
     * Get 
     *             true if this object is permanent.
     *           
     * 
     * @return boolean
     */
    public boolean isPermanent()
    {
        return this.permanent;
    } //-- boolean isPermanent() 

    /**
     * Method removeChildRoleName.
     * 
     * @param string
     */
    public void removeChildRoleName(String string)
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "JdoRole.removeChildRoleNames(string) parameter must be instanceof " + String.class.getName() );
        }
        getChildRoleNames().remove( string );
    } //-- void removeChildRoleName(String) 

    /**
     * Method removePermission.
     * 
     * @param jdoPermission
     */
    public void removePermission(org.codehaus.plexus.security.rbac.Permission jdoPermission)
    {
        if ( !(jdoPermission instanceof JdoPermission) )
        {
            throw new ClassCastException( "JdoRole.removePermissions(jdoPermission) parameter must be instanceof " + JdoPermission.class.getName() );
        }
        getPermissions().remove( ( (JdoPermission) jdoPermission ) );
    } //-- void removePermission(org.codehaus.plexus.security.rbac.Permission) 

    /**
     * Set 
     *             true if this role is available to be assigned to
     * a user
     *           .
     * 
     * @param assignable
     */
    public void setAssignable(boolean assignable)
    {
        this.assignable = assignable;
    } //-- void setAssignable(boolean) 

    /**
     * Set 
     *             roles that will inherit the permissions of this
     * role
     *           .
     * 
     * @param childRoleNames
     */
    public void setChildRoleNames(java.util.List childRoleNames)
    {
        this.childRoleNames = childRoleNames;
    } //-- void setChildRoleNames(java.util.List) 

    /**
     * Set the description field.
     * 
     * @param description
     */
    public void setDescription(String description)
    {
        this.description = description;
    } //-- void setDescription(String) 

    /**
     * Set the name field.
     * 
     * @param name
     */
    public void setName(String name)
    {
        this.name = name;
    } //-- void setName(String) 

    /**
     * Set 
     *             true if this object is permanent.
     *           
     * 
     * @param permanent
     */
    public void setPermanent(boolean permanent)
    {
        this.permanent = permanent;
    } //-- void setPermanent(boolean) 

    /**
     * Set the permissions field.
     * 
     * @param permissions
     */
    public void setPermissions(java.util.List permissions)
    {
        this.permissions = permissions;
    } //-- void setPermissions(java.util.List) 

    /**
     * Method toString.
     * 
     * @return java.lang.String
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();
        
        buf.append( "name = '" );
        buf.append( getName() );
        buf.append( "'" );
        buf.append( "\n" );
        buf.append( super.toString() );
        
        return buf.toString();
    } //-- java.lang.String toString() 


    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
