/*
 * $Id$
 */

package org.codehaus.plexus.security.authorization.rbac.jdo.v0_9_0;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * 
 *         In RBAC terms, this is the entity which an operation is
 * associated with that which permissions are based on.
 *       
 * 
 * @version $Revision$ $Date$
 */
public class JdoResource 
implements org.codehaus.plexus.security.rbac.Resource, java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             The string identifier for a resource.
     *           
     */
    private String identifier;

    /**
     * 
     *             true if the identifer is a pattern that is to be
     * evaluated, for example x.* could match x.a or x.b and x.**
     *             could match x.foo
     *           .
     */
    private boolean pattern = false;

    /**
     * 
     *             true if this object is permanent.
     *           
     */
    private boolean permanent = false;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method equals.
     * 
     * @param other
     * @return boolean
     */
    public boolean equals(Object other)
    {
        if ( this == other)
        {
            return true;
        }
        
        if ( !(other instanceof JdoResource) )
        {
            return false;
        }
        
        JdoResource that = (JdoResource) other;
        boolean result = true;
        
        result = result && ( getIdentifier() == null ? that.getIdentifier() == null : getIdentifier().equals( that.getIdentifier() ) );
        
        return result;
    } //-- boolean equals(Object) 

    /**
     * Get 
     *             The string identifier for a resource.
     *           
     * 
     * @return String
     */
    public String getIdentifier()
    {
        return this.identifier;
    } //-- String getIdentifier() 

    /**
     * Method hashCode.
     * 
     * @return int
     */
    public int hashCode()
    {
        int result = 17;
        
        result = 37 * result + ( identifier != null ? identifier.hashCode() : 0 );
        
        return result;
    } //-- int hashCode() 

    /**
     * Get 
     *             true if the identifer is a pattern that is to be
     * evaluated, for example x.* could match x.a or x.b and x.**
     *             could match x.foo
     *           .
     * 
     * @return boolean
     */
    public boolean isPattern()
    {
        return this.pattern;
    } //-- boolean isPattern() 

    /**
     * Get 
     *             true if this object is permanent.
     *           
     * 
     * @return boolean
     */
    public boolean isPermanent()
    {
        return this.permanent;
    } //-- boolean isPermanent() 

    /**
     * Set 
     *             The string identifier for a resource.
     *           
     * 
     * @param identifier
     */
    public void setIdentifier(String identifier)
    {
        this.identifier = identifier;
    } //-- void setIdentifier(String) 

    /**
     * Set 
     *             true if the identifer is a pattern that is to be
     * evaluated, for example x.* could match x.a or x.b and x.**
     *             could match x.foo
     *           .
     * 
     * @param pattern
     */
    public void setPattern(boolean pattern)
    {
        this.pattern = pattern;
    } //-- void setPattern(boolean) 

    /**
     * Set 
     *             true if this object is permanent.
     *           
     * 
     * @param permanent
     */
    public void setPermanent(boolean permanent)
    {
        this.permanent = permanent;
    } //-- void setPermanent(boolean) 

    /**
     * Method toString.
     * 
     * @return java.lang.String
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();
        
        buf.append( "identifier = '" );
        buf.append( getIdentifier() );
        buf.append( "'" );
        
        return buf.toString();
    } //-- java.lang.String toString() 


    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
