/*
 * $Id$
 */

package org.codehaus.plexus.security.authorization.rbac.jdo.v0_9_0;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Class JdoPermission.
 * 
 * @version $Revision$ $Date$
 */
public class JdoPermission 
implements org.codehaus.plexus.security.rbac.Permission, java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field name.
     */
    private String name;

    /**
     * Field description.
     */
    private String description;

    /**
     * 
     *             true if this object is permanent.
     *           
     */
    private boolean permanent = false;

    /**
     * Field operation.
     */
    private JdoOperation operation;

    /**
     * Field resource.
     */
    private JdoResource resource;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method equals.
     * 
     * @param other
     * @return boolean
     */
    public boolean equals(Object other)
    {
        if ( this == other)
        {
            return true;
        }
        
        if ( !(other instanceof JdoPermission) )
        {
            return false;
        }
        
        JdoPermission that = (JdoPermission) other;
        boolean result = true;
        
        result = result && ( getName() == null ? that.getName() == null : getName().equals( that.getName() ) );
        
        return result;
    } //-- boolean equals(Object) 

    /**
     * Get the description field.
     * 
     * @return String
     */
    public String getDescription()
    {
        return this.description;
    } //-- String getDescription() 

    /**
     * Get the name field.
     * 
     * @return String
     */
    public String getName()
    {
        return this.name;
    } //-- String getName() 

    /**
     * Get the operation field.
     * 
     * @return org.codehaus.plexus.security.rbac.Operation
     */
    public org.codehaus.plexus.security.rbac.Operation getOperation()
    {
        return (org.codehaus.plexus.security.rbac.Operation) this.operation;
    } //-- org.codehaus.plexus.security.rbac.Operation getOperation() 

    /**
     * Get the resource field.
     * 
     * @return org.codehaus.plexus.security.rbac.Resource
     */
    public org.codehaus.plexus.security.rbac.Resource getResource()
    {
        return (org.codehaus.plexus.security.rbac.Resource) this.resource;
    } //-- org.codehaus.plexus.security.rbac.Resource getResource() 

    /**
     * Method hashCode.
     * 
     * @return int
     */
    public int hashCode()
    {
        int result = 17;
        
        result = 37 * result + ( name != null ? name.hashCode() : 0 );
        
        return result;
    } //-- int hashCode() 

    /**
     * Get 
     *             true if this object is permanent.
     *           
     * 
     * @return boolean
     */
    public boolean isPermanent()
    {
        return this.permanent;
    } //-- boolean isPermanent() 

    /**
     * Set the description field.
     * 
     * @param description
     */
    public void setDescription(String description)
    {
        this.description = description;
    } //-- void setDescription(String) 

    /**
     * Set the name field.
     * 
     * @param name
     */
    public void setName(String name)
    {
        this.name = name;
    } //-- void setName(String) 

    /**
     * Set the operation field.
     * 
     * @param operation
     */
    public void setOperation(org.codehaus.plexus.security.rbac.Operation operation)
    {
        if ( !(operation instanceof org.codehaus.plexus.security.rbac.Operation) )
        {
            throw new ClassCastException( "JdoPermission.setOperation(operation) parameter must be instanceof " + org.codehaus.plexus.security.rbac.Operation.class.getName() );
        }
        this.operation = (JdoOperation) operation;
    } //-- void setOperation(org.codehaus.plexus.security.rbac.Operation) 

    /**
     * Set 
     *             true if this object is permanent.
     *           
     * 
     * @param permanent
     */
    public void setPermanent(boolean permanent)
    {
        this.permanent = permanent;
    } //-- void setPermanent(boolean) 

    /**
     * Set the resource field.
     * 
     * @param resource
     */
    public void setResource(org.codehaus.plexus.security.rbac.Resource resource)
    {
        if ( !(resource instanceof org.codehaus.plexus.security.rbac.Resource) )
        {
            throw new ClassCastException( "JdoPermission.setResource(resource) parameter must be instanceof " + org.codehaus.plexus.security.rbac.Resource.class.getName() );
        }
        this.resource = (JdoResource) resource;
    } //-- void setResource(org.codehaus.plexus.security.rbac.Resource) 

    /**
     * Method toString.
     * 
     * @return java.lang.String
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();
        
        buf.append( "name = '" );
        buf.append( getName() );
        buf.append( "'" );
        
        return buf.toString();
    } //-- java.lang.String toString() 


    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
