/*
 * $Id$
 */

package org.codehaus.plexus.security.authorization.rbac.jdo.v0_9_0;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Class JdoOperation.
 * 
 * @version $Revision$ $Date$
 */
public class JdoOperation 
implements org.codehaus.plexus.security.rbac.Operation, java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field name.
     */
    private String name;

    /**
     * Field description.
     */
    private String description;

    /**
     * 
     *             true if this object is permanent.
     *           
     */
    private boolean permanent = false;

    /**
     * 
     *             true if the resource is required for
     * authorization to be granted
     *           .
     */
    private boolean resourceRequired = false;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method equals.
     * 
     * @param other
     * @return boolean
     */
    public boolean equals(Object other)
    {
        if ( this == other)
        {
            return true;
        }
        
        if ( !(other instanceof JdoOperation) )
        {
            return false;
        }
        
        JdoOperation that = (JdoOperation) other;
        boolean result = true;
        
        result = result && ( getName() == null ? that.getName() == null : getName().equals( that.getName() ) );
        
        return result;
    } //-- boolean equals(Object) 

    /**
     * Get the description field.
     * 
     * @return String
     */
    public String getDescription()
    {
        return this.description;
    } //-- String getDescription() 

    /**
     * Get the name field.
     * 
     * @return String
     */
    public String getName()
    {
        return this.name;
    } //-- String getName() 

    /**
     * Method hashCode.
     * 
     * @return int
     */
    public int hashCode()
    {
        int result = 17;
        
        result = 37 * result + ( name != null ? name.hashCode() : 0 );
        
        return result;
    } //-- int hashCode() 

    /**
     * Get 
     *             true if this object is permanent.
     *           
     * 
     * @return boolean
     */
    public boolean isPermanent()
    {
        return this.permanent;
    } //-- boolean isPermanent() 

    /**
     * Get 
     *             true if the resource is required for
     * authorization to be granted
     *           .
     * 
     * @return boolean
     */
    public boolean isResourceRequired()
    {
        return this.resourceRequired;
    } //-- boolean isResourceRequired() 

    /**
     * Set the description field.
     * 
     * @param description
     */
    public void setDescription(String description)
    {
        this.description = description;
    } //-- void setDescription(String) 

    /**
     * Set the name field.
     * 
     * @param name
     */
    public void setName(String name)
    {
        this.name = name;
    } //-- void setName(String) 

    /**
     * Set 
     *             true if this object is permanent.
     *           
     * 
     * @param permanent
     */
    public void setPermanent(boolean permanent)
    {
        this.permanent = permanent;
    } //-- void setPermanent(boolean) 

    /**
     * Set 
     *             true if the resource is required for
     * authorization to be granted
     *           .
     * 
     * @param resourceRequired
     */
    public void setResourceRequired(boolean resourceRequired)
    {
        this.resourceRequired = resourceRequired;
    } //-- void setResourceRequired(boolean) 

    /**
     * Method toString.
     * 
     * @return java.lang.String
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();
        
        buf.append( "name = '" );
        buf.append( getName() );
        buf.append( "'" );
        
        return buf.toString();
    } //-- java.lang.String toString() 


    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
