/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.view;

import com.opensymphony.xwork2.ActionContext;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.continuum.model.project.ProjectScmRoot;
import org.apache.maven.continuum.web.model.ProjectSummary;
import org.apache.maven.continuum.web.util.StateGenerator;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.views.util.UrlHelper;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.redback.authorization.AuthorizationException;
import org.codehaus.plexus.redback.system.SecuritySession;
import org.codehaus.plexus.redback.system.SecuritySystem;
import org.extremecomponents.table.bean.Column;
import org.extremecomponents.table.cell.DisplayCell;
import org.extremecomponents.table.core.TableModel;

/*
 * Exception performing whole class analysis ignored.
 */
public class StateCell
extends DisplayCell {
    protected String getCellValue(TableModel tableModel, Column column) {
        if (tableModel.getCurrentRowBean() instanceof ProjectSummary) {
            ProjectSummary project = (ProjectSummary)tableModel.getCurrentRowBean();
            switch (project.getState()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: {
                    String state = StateGenerator.generate((int)project.getState(), (String)tableModel.getContext().getContextPath());
                    if (project.getLatestBuildId() != -1 && !"NEW".equals(state) && project.getState() != 8) {
                        if (this.isAuthorized(project.getProjectGroupName())) {
                            return StateCell.createActionLink((String)"buildResult", (ProjectSummary)project, (String)state);
                        }
                        return state;
                    }
                    return state;
                }
            }
            return "&nbsp;";
        }
        ProjectScmRoot projectScmRoot = (ProjectScmRoot)tableModel.getCurrentRowBean();
        switch (projectScmRoot.getState()) {
            case 4: 
            case 5: 
            case 8: {
                String state = StateGenerator.generate((int)projectScmRoot.getState(), (String)tableModel.getContext().getContextPath());
                if (!"NEW".equals(state)) {
                    if (this.isAuthorized(projectScmRoot.getProjectGroup().getName()) && projectScmRoot.getState() == 4) {
                        return StateCell.createActionLink((String)"scmResult", (ProjectScmRoot)projectScmRoot, (String)state);
                    }
                    return state;
                }
                return state;
            }
        }
        return "&nbsp;";
    }

    private static String createActionLink(String action, ProjectSummary project, String state) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("projectId", project.getId());
        params.put("projectName", project.getName());
        params.put("buildId", project.getLatestBuildId());
        params.put("projectGroupId", project.getProjectGroupId());
        String url = UrlHelper.buildUrl((String)("/" + action + ".action"), (HttpServletRequest)ServletActionContext.getRequest(), (HttpServletResponse)ServletActionContext.getResponse(), params);
        return "<a href=\"" + url + "\">" + state + "</a>";
    }

    private static String createActionLink(String action, ProjectScmRoot scmRoot, String state) {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("projectGroupId", scmRoot.getProjectGroup().getId());
        params.put("projectScmRootId", scmRoot.getId());
        String url = UrlHelper.buildUrl((String)("/" + action + ".action"), (HttpServletRequest)ServletActionContext.getRequest(), (HttpServletResponse)ServletActionContext.getResponse(), params);
        return "<a href=\"" + url + "\">" + state + "</a>";
    }

    private boolean isAuthorized(String projectGroupName) {
        ActionContext context = ActionContext.getContext();
        PlexusContainer container = (PlexusContainer)context.getApplication().get("plexus");
        SecuritySession securitySession = (SecuritySession)context.getSession().get("securitySession");
        try {
            SecuritySystem securitySystem = (SecuritySystem)container.lookup(SecuritySystem.ROLE);
            if (!securitySystem.isAuthorized(securitySession, (Object)"continuum-view-group", (Object)projectGroupName)) {
                return false;
            }
        }
        catch (ComponentLookupException cle) {
            return false;
        }
        catch (AuthorizationException ae) {
            return false;
        }
        return true;
    }
}

