/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.validator;

import com.opensymphony.xwork2.validator.ValidationException;
import com.opensymphony.xwork2.validator.validators.ValidatorSupport;
import org.apache.maven.continuum.execution.ExecutorConfigurator;
import org.apache.maven.continuum.installation.InstallationException;
import org.apache.maven.continuum.installation.InstallationService;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallationValidator
extends ValidatorSupport {
    private String fieldName;
    private static final Logger logger = LoggerFactory.getLogger(InstallationValidator.class);
    private InstallationService installationService;

    public void validate(Object object) throws ValidationException {
        String name = (String)this.getFieldValue("installation.name", object);
        if (StringUtils.isEmpty((String)name)) {
            return;
        }
        String varValue = (String)this.getFieldValue("installation.varValue", object);
        if (StringUtils.isEmpty((String)varValue)) {
            return;
        }
        String type = (String)this.getFieldValue("installation.type", object);
        ExecutorConfigurator executorConfigurator = this.installationService.getExecutorConfigurator(type);
        try {
            if (executorConfigurator != null && executorConfigurator.getVersionArgument() != null) {
                this.installationService.getExecutorConfiguratorVersion(varValue, executorConfigurator, null);
            }
        }
        catch (InstallationException e) {
            String message = this.getMessage((Object)this.getMessageKey()) + e.getMessage();
            logger.error(message);
            this.addFieldError("installation.varValue", (Object)message);
        }
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }
}

