/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.util;

import java.io.File;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class WorkingCopyContentGenerator {
    private File basedir;
    private String urlParamSeparator;
    private static final DecimalFormat decFormatter = new DecimalFormat("###.##");
    private static final long KILO = 1024L;
    private static final long MEGA = 0x100000L;
    private static final long GIGA = 0x40000000L;
    private boolean odd = false;

    public String generate(List<File> files, String baseUrl, String imagesBaseUrl, File basedir) {
        this.basedir = basedir;
        this.urlParamSeparator = baseUrl.indexOf("?") > 0 ? "&" : "?";
        StringBuffer buf = new StringBuffer();
        buf.append("<div class=\"eXtremeTable\" >");
        buf.append("<table class=\"tableRegion\" width=\"100%\">\n");
        buf.append("<tr class=\"odd\"><td><img src=\"").append(imagesBaseUrl).append("icon_arrowfolder1_sml.gif\">&nbsp;<a href=\"").append(baseUrl).append(this.urlParamSeparator).append("userDirectory=/\">/</a><br /></td><td>&nbsp;</td><td>&nbsp;</td>");
        this.print(basedir, files, baseUrl, imagesBaseUrl, buf);
        buf.append("</table>\n");
        buf.append("</div>\n");
        return buf.toString();
    }

    private void print(File basedir, List<File> files, String baseUrl, String imagesBaseUrl, StringBuffer buf) {
        for (File f : files) {
            this.print(f, this.getIndent(basedir, f), baseUrl, imagesBaseUrl, buf);
        }
    }

    private void print(File f, String indent, String baseUrl, String imagesBaseUrl, StringBuffer buf) {
        String cssClass;
        String string = cssClass = this.odd ? "odd" : "even";
        if (!f.isDirectory()) {
            String fileName = f.getName();
            if (!(".cvsignore".equals(fileName) || "vssver.scc".equals(fileName) || ".DS_Store".equals(fileName) || "release.properties".equals(fileName))) {
                String userDirectory = f.getParentFile().getAbsolutePath().equals(this.basedir.getAbsolutePath()) ? "/" : f.getParentFile().getAbsolutePath().substring(this.basedir.getAbsolutePath().length() + 1);
                userDirectory = StringUtils.replace((String)userDirectory, (String)"\\", (String)"/");
                buf.append("<tr class=\"").append(cssClass).append("\">");
                buf.append("<td width=\"98%\">").append(indent).append("&nbsp;&nbsp;<img src=\"").append(imagesBaseUrl).append("file.gif\">&nbsp;<a href=\"").append(baseUrl).append(this.urlParamSeparator).append("userDirectory=").append(userDirectory).append("&file=").append(fileName).append("\">").append(fileName).append("</a></td><td width=\"1%\">").append(WorkingCopyContentGenerator.getReadableFileSize((long)f.length())).append("</td><td width=\"1%\">").append(this.getFormattedDate(f.lastModified())).append("</td>\n");
                buf.append("</tr>\n");
                this.odd = !this.odd;
            }
        } else {
            String directoryName = f.getName();
            if (!("CVS".equals(directoryName) || ".svn".equals(directoryName) || "SCCS".equals(directoryName))) {
                String userDirectory = f.getAbsolutePath().substring(this.basedir.getAbsolutePath().length() + 1);
                userDirectory = StringUtils.replace((String)userDirectory, (String)"\\", (String)"/");
                buf.append("<tr class=\"").append(cssClass).append("\">");
                buf.append("<td width=\"98%\">").append(indent).append("<img src=\"").append(imagesBaseUrl).append("icon_arrowfolder1_sml.gif\">&nbsp;<a href =\"").append(baseUrl).append(this.urlParamSeparator).append("userDirectory=").append(userDirectory).append("\">").append(directoryName).append("</a></td><td width=\"1%\">&nbsp;</td><td width=\"1%\">").append(this.getFormattedDate(f.lastModified())).append("</td>");
                buf.append("</tr>\n");
                this.odd = !this.odd;
            }
        }
    }

    private String getFormattedDate(long timestamp) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(timestamp);
        Date date = cal.getTime();
        String res = new SimpleDateFormat("MMM dd, yyyy hh:mm:ss aaa z").format(date);
        return StringUtils.replace((String)res, (String)" ", (String)"&nbsp;");
    }

    private static String getReadableFileSize(long fileSizeInBytes) {
        if (fileSizeInBytes >= 0x40000000L) {
            return decFormatter.format(fileSizeInBytes / 0x40000000L) + "&nbsp;Gb";
        }
        if (fileSizeInBytes >= 0x100000L) {
            return decFormatter.format(fileSizeInBytes / 0x100000L) + "&nbsp;Mb";
        }
        if (fileSizeInBytes >= 1024L) {
            return decFormatter.format(fileSizeInBytes / 1024L) + "&nbsp;Kb";
        }
        if (fileSizeInBytes > 0L && fileSizeInBytes < 1024L) {
            return decFormatter.format(fileSizeInBytes) + "&nbsp;b";
        }
        return "0&nbsp;b";
    }

    private String getIndent(File basedir, File userFile) {
        String root = basedir.getAbsolutePath();
        String userdir = userFile.isDirectory() ? userFile.getAbsolutePath() : userFile.getParentFile().getAbsolutePath();
        userdir = userdir.substring(root.length());
        StringBuffer indent = new StringBuffer();
        while (userdir.indexOf(File.separator) >= 0) {
            indent.append("&nbsp;&nbsp;");
            userdir = userdir.substring(userdir.indexOf(File.separator) + 1);
        }
        return indent.toString();
    }
}

