/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.checks.security;

import java.util.List;
import org.apache.maven.continuum.Continuum;
import org.apache.maven.continuum.model.project.ProjectGroup;
import org.codehaus.plexus.redback.role.RoleManager;
import org.codehaus.plexus.redback.role.RoleManagerException;
import org.codehaus.plexus.redback.system.check.EnvironmentCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleProfileEnvironmentCheck
implements EnvironmentCheck {
    private static final Logger log = LoggerFactory.getLogger(RoleProfileEnvironmentCheck.class);
    private RoleManager roleManager;
    private Continuum continuum;

    public void validateEnvironment(List list) {
        try {
            log.info("Checking roles list.");
            List projectGroups = this.continuum.getAllProjectGroups();
            for (ProjectGroup group : projectGroups) {
                if (!this.roleManager.templatedRoleExists("project-administrator", group.getName())) {
                    this.roleManager.createTemplatedRole("project-administrator", group.getName());
                }
                if (!this.roleManager.templatedRoleExists("project-developer", group.getName())) {
                    this.roleManager.createTemplatedRole("project-developer", group.getName());
                }
                if (this.roleManager.templatedRoleExists("project-user", group.getName())) continue;
                this.roleManager.createTemplatedRole("project-user", group.getName());
            }
        }
        catch (RoleManagerException rpe) {
            rpe.printStackTrace();
            list.add("error checking existence of roles for groups");
        }
    }
}

