/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action.notifier;

import org.apache.continuum.web.util.GenerateRecipentNotifier;
import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.model.project.ProjectNotifier;
import org.apache.maven.continuum.web.action.ContinuumActionSupport;
import org.apache.maven.continuum.web.exception.AuthorizationRequiredException;
import org.codehaus.plexus.util.StringUtils;

public class DeleteProjectNotifierAction
extends ContinuumActionSupport {
    private int projectId;
    private int projectGroupId;
    private int notifierId;
    private String notifierType;
    private String recipient;
    private boolean fromGroupPage = false;
    private String projectGroupName = "";

    public String execute() throws ContinuumException {
        try {
            this.checkRemoveProjectNotifierAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        this.getContinuum().removeNotifier(this.projectId, this.notifierId);
        if (this.fromGroupPage) {
            return "to_group_page";
        }
        return "success";
    }

    public String doDefault() throws ContinuumException {
        try {
            this.checkRemoveProjectNotifierAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        ProjectNotifier notifier = this.getContinuum().getNotifier(this.projectId, this.notifierId);
        this.notifierType = notifier.getType();
        this.recipient = GenerateRecipentNotifier.generate((ProjectNotifier)notifier);
        return "delete";
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    public int getProjectId() {
        return this.projectId;
    }

    public void setNotifierId(int notifierId) {
        this.notifierId = notifierId;
    }

    public int getNotifierId() {
        return this.notifierId;
    }

    public void setNotifierType(String notifierType) {
        this.notifierType = notifierType;
    }

    public String getNotifierType() {
        return this.notifierType;
    }

    public int getProjectGroupId() {
        return this.projectGroupId;
    }

    public void setProjectGroupId(int projectGroupId) {
        this.projectGroupId = projectGroupId;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public boolean isFromGroupPage() {
        return this.fromGroupPage;
    }

    public void setFromGroupPage(boolean fromGroupPage) {
        this.fromGroupPage = fromGroupPage;
    }

    public String getProjectGroupName() throws ContinuumException {
        if (StringUtils.isEmpty((String)this.projectGroupName)) {
            this.projectGroupName = this.projectGroupId != 0 ? this.getContinuum().getProjectGroup(this.projectGroupId).getName() : this.getContinuum().getProjectGroupByProjectId(this.projectId).getName();
        }
        return this.projectGroupName;
    }
}

