/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action.notifier;

import org.apache.continuum.web.util.GenerateRecipentNotifier;
import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.model.project.ProjectNotifier;
import org.apache.maven.continuum.web.action.ContinuumActionSupport;
import org.apache.maven.continuum.web.exception.AuthorizationRequiredException;
import org.codehaus.plexus.util.StringUtils;

public class DeleteGroupNotifierAction
extends ContinuumActionSupport {
    private int projectGroupId;
    private int notifierId;
    private String notifierType;
    private String recipient;
    private String projectGroupName = "";

    public String execute() throws ContinuumException {
        try {
            this.checkRemoveProjectGroupNotifierAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        this.getContinuum().removeGroupNotifier(this.projectGroupId, this.notifierId);
        return "success";
    }

    public String doDefault() throws ContinuumException {
        try {
            this.checkRemoveProjectGroupNotifierAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        ProjectNotifier notifier = this.getContinuum().getGroupNotifier(this.projectGroupId, this.notifierId);
        this.notifierType = notifier.getType();
        this.recipient = GenerateRecipentNotifier.generate((ProjectNotifier)notifier);
        return "delete";
    }

    public void setNotifierId(int notifierId) {
        this.notifierId = notifierId;
    }

    public int getNotifierId() {
        return this.notifierId;
    }

    public void setNotifierType(String notifierType) {
        this.notifierType = notifierType;
    }

    public String getNotifierType() {
        return this.notifierType;
    }

    public int getProjectGroupId() {
        return this.projectGroupId;
    }

    public void setProjectGroupId(int projectGroupId) {
        this.projectGroupId = projectGroupId;
    }

    public int getProjectId() {
        return -1;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public String getProjectGroupName() throws ContinuumException {
        if (StringUtils.isEmpty((String)this.projectGroupName)) {
            this.projectGroupName = this.getContinuum().getProjectGroup(this.projectGroupId).getName();
        }
        return this.projectGroupName;
    }
}

