/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action.notifier;

import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.web.action.ContinuumActionSupport;
import org.apache.maven.continuum.web.exception.AuthorizationRequiredException;
import org.codehaus.plexus.util.StringUtils;

public class AddProjectNotifierAction
extends ContinuumActionSupport {
    private int projectId;
    private int projectGroupId;
    private String notifierType;
    private boolean fromGroupPage = false;
    private String projectGroupName = "";

    public String execute() throws ContinuumException {
        try {
            this.checkAddProjectNotifierAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        return this.notifierType + "_" + "input";
    }

    public String doDefault() throws ContinuumException {
        return this.input();
    }

    public String input() throws ContinuumException {
        try {
            this.checkAddProjectNotifierAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        return "input";
    }

    public String getNotifierType() {
        return this.notifierType;
    }

    public void setNotifierType(String notifierType) {
        this.notifierType = notifierType;
    }

    public int getProjectId() {
        return this.projectId;
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    public int getProjectGroupId() {
        return this.projectGroupId;
    }

    public void setProjectGroupId(int projectGroupId) {
        this.projectGroupId = projectGroupId;
    }

    public boolean isFromGroupPage() {
        return this.fromGroupPage;
    }

    public void setFromGroupPage(boolean fromGroupPage) {
        this.fromGroupPage = fromGroupPage;
    }

    public String getProjectGroupName() throws ContinuumException {
        if (StringUtils.isEmpty((String)this.projectGroupName)) {
            this.projectGroupName = this.projectGroupId != 0 ? this.getContinuum().getProjectGroup(this.projectGroupId).getName() : this.getContinuum().getProjectGroupByProjectId(this.projectId).getName();
        }
        return this.projectGroupName;
    }
}

