/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action.notifier;

import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.web.action.ContinuumActionSupport;
import org.apache.maven.continuum.web.exception.AuthorizationRequiredException;
import org.codehaus.plexus.util.StringUtils;

public class AddGroupNotifierAction
extends ContinuumActionSupport {
    private int projectGroupId;
    private String notifierType;
    private String projectGroupName = "";

    public String execute() throws ContinuumException {
        try {
            this.checkAddProjectGroupNotifierAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        return this.notifierType + "_" + "input";
    }

    public String doDefault() throws ContinuumException {
        return this.input();
    }

    public String input() throws ContinuumException {
        try {
            this.checkAddProjectGroupNotifierAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        return "input";
    }

    public String getNotifierType() {
        return this.notifierType;
    }

    public void setNotifierType(String notifierType) {
        this.notifierType = notifierType;
    }

    public int getProjectGroupId() {
        return this.projectGroupId;
    }

    public void setProjectGroupId(int projectGroupId) {
        this.projectGroupId = projectGroupId;
    }

    public String getProjectGroupName() throws ContinuumException {
        if (StringUtils.isEmpty((String)this.projectGroupName)) {
            this.projectGroupName = this.getContinuum().getProjectGroup(this.projectGroupId).getName();
        }
        return this.projectGroupName;
    }
}

