/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action.notifier;

import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.model.project.ProjectNotifier;
import org.apache.maven.continuum.web.action.notifier.AbstractNotifierEditActionSupport;
import org.apache.maven.continuum.web.exception.AuthorizationRequiredException;

public abstract class AbstractProjectNotifierEditAction
extends AbstractNotifierEditActionSupport {
    private int projectId;
    private int projectGroupId;
    private String projectGroupName = "";

    protected void saveNotifier(ProjectNotifier notifier) throws ContinuumException {
        boolean isNew;
        boolean bl = isNew = notifier.getId() <= 0;
        if (!isNew) {
            this.getContinuum().updateNotifier(this.projectId, notifier);
        } else {
            this.getContinuum().addNotifier(this.projectId, notifier);
        }
    }

    protected ProjectNotifier getNotifier() throws ContinuumException {
        return this.getContinuum().getNotifier(this.projectId, this.getNotifierId());
    }

    public int getProjectId() {
        return this.projectId;
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    public int getProjectGroupId() {
        return this.projectGroupId;
    }

    public void setProjectGroupId(int projectGroupId) {
        this.projectGroupId = projectGroupId;
    }

    protected void checkAuthorization() throws AuthorizationRequiredException, ContinuumException {
        if (this.getNotifier() == null) {
            this.checkAddProjectNotifierAuthorization(this.getProjectGroupName());
        } else {
            this.checkModifyProjectNotifierAuthorization(this.getProjectGroupName());
        }
    }

    public String getProjectGroupName() throws ContinuumException {
        if (this.projectGroupName == null || "".equals(this.projectGroupName)) {
            this.projectGroupName = this.projectGroupId != 0 ? this.getContinuum().getProjectGroup(this.projectGroupId).getName() : this.getContinuum().getProjectGroupByProjectId(this.projectId).getName();
        }
        return this.projectGroupName;
    }
}

