/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action.notifier;

import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.model.project.ProjectNotifier;
import org.apache.maven.continuum.web.action.notifier.AbstractNotifierEditActionSupport;
import org.apache.maven.continuum.web.exception.AuthorizationRequiredException;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractGroupNotifierEditAction
extends AbstractNotifierEditActionSupport {
    private int projectGroupId;
    private String projectGroupName = "";

    protected void saveNotifier(ProjectNotifier notifier) throws ContinuumException {
        boolean isNew;
        boolean bl = isNew = notifier.getId() <= 0;
        if (!isNew) {
            this.getContinuum().updateGroupNotifier(this.projectGroupId, notifier);
        } else {
            this.getContinuum().addGroupNotifier(this.projectGroupId, notifier);
        }
    }

    protected ProjectNotifier getNotifier() throws ContinuumException {
        return this.getContinuum().getGroupNotifier(this.projectGroupId, this.getNotifierId());
    }

    public int getProjectGroupId() {
        return this.projectGroupId;
    }

    public void setProjectGroupId(int projectGroupId) {
        this.projectGroupId = projectGroupId;
    }

    protected void checkAuthorization() throws AuthorizationRequiredException, ContinuumException {
        if (this.getNotifier() == null) {
            this.checkAddProjectGroupNotifierAuthorization(this.getProjectGroupName());
        } else {
            this.checkModifyProjectGroupNotifierAuthorization(this.getProjectGroupName());
        }
    }

    public String getProjectGroupName() throws ContinuumException {
        if (StringUtils.isEmpty((String)this.projectGroupName)) {
            this.projectGroupName = this.getContinuum().getProjectGroup(this.projectGroupId).getName();
        }
        return this.projectGroupName;
    }
}

