/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action.component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.continuum.web.util.GenerateRecipentNotifier;
import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.model.project.ProjectGroup;
import org.apache.maven.continuum.model.project.ProjectNotifier;
import org.apache.maven.continuum.web.action.ContinuumActionSupport;
import org.apache.maven.continuum.web.exception.AuthorizationRequiredException;
import org.apache.maven.continuum.web.model.NotifierSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotifierSummaryAction
extends ContinuumActionSupport {
    private static final Logger logger = LoggerFactory.getLogger(NotifierSummaryAction.class);
    private int projectGroupId;
    private int projectId;
    private ProjectGroup projectGroup;
    private List<NotifierSummary> projectGroupNotifierSummaries = new ArrayList();
    private List<NotifierSummary> projectNotifierSummaries = new ArrayList();
    private String projectGroupName = "";

    public String summarizeForProject() {
        logger.debug("Obtaining summary for Project Id: " + this.projectId);
        try {
            this.checkViewProjectGroupAuthorization(this.getProjectGroupName());
            this.projectNotifierSummaries = this.summarizeForProject(this.projectId);
        }
        catch (ContinuumException e) {
            logger.error("Unable to prepare Notifier summaries for Project Id: " + this.projectId, (Throwable)e);
            return "error";
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        return "success";
    }

    private List<NotifierSummary> summarizeForProject(int projectId) throws ContinuumException {
        return this.gatherProjectNotifierSummaries(projectId);
    }

    public String summarizeForProjectGroup() {
        logger.debug("Obtaining summary for ProjectGroup Id:" + this.projectGroupId);
        try {
            this.checkViewProjectGroupAuthorization(this.getProjectGroupName());
            this.projectGroupNotifierSummaries = this.gatherGroupNotifierSummaries();
            Collection projects = this.getContinuum().getProjectsInGroup(this.projectGroupId);
            if (projects != null) {
                for (Project project : projects) {
                    this.projectNotifierSummaries.addAll(this.summarizeForProject(project.getId()));
                }
            }
        }
        catch (ContinuumException e) {
            logger.error("Unable to prepare Notifier summaries for ProjectGroup Id: " + this.projectGroupId, (Throwable)e);
            return "error";
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        return "success";
    }

    private List<NotifierSummary> gatherProjectNotifierSummaries(int projectId) throws ContinuumException {
        ArrayList<NotifierSummary> summaryList = new ArrayList<NotifierSummary>();
        Project project = this.getContinuum().getProjectWithAllDetails(projectId);
        for (ProjectNotifier pn : project.getNotifiers()) {
            NotifierSummary ns = this.generateProjectNotifierSummary(pn, project);
            summaryList.add(ns);
        }
        return summaryList;
    }

    private List<NotifierSummary> gatherGroupNotifierSummaries() throws ContinuumException {
        ArrayList<NotifierSummary> summaryList = new ArrayList<NotifierSummary>();
        this.projectGroup = this.getContinuum().getProjectGroupWithBuildDetails(this.projectGroupId);
        for (ProjectNotifier pn : this.projectGroup.getNotifiers()) {
            NotifierSummary ns = this.generateGroupNotifierSummary(pn);
            summaryList.add(ns);
        }
        return summaryList;
    }

    private NotifierSummary generateProjectNotifierSummary(ProjectNotifier notifier, Project project) {
        return this.generateNotifierSummary(notifier, this.projectGroupId, project);
    }

    private NotifierSummary generateGroupNotifierSummary(ProjectNotifier notifier) {
        return this.generateNotifierSummary(notifier, this.projectGroupId, null);
    }

    private NotifierSummary generateNotifierSummary(ProjectNotifier notifier, int projectGroupId, Project project) {
        NotifierSummary ns = new NotifierSummary();
        ns.setId(notifier.getId());
        ns.setType(notifier.getType());
        ns.setProjectGroupId(projectGroupId);
        if (project != null) {
            ns.setProjectId(project.getId());
            ns.setProjectName(project.getName());
        }
        if (notifier.isFromProject()) {
            ns.setFromProject(true);
        } else {
            ns.setFromProject(false);
        }
        String recipient = GenerateRecipentNotifier.generate((ProjectNotifier)notifier);
        ns.setRecipient(recipient);
        StringBuffer sb = new StringBuffer();
        if (notifier.isSendOnError()) {
            sb.append("Error");
        }
        if (notifier.isSendOnFailure()) {
            if (sb.length() > 0) {
                sb.append('/');
            }
            sb.append("Failure");
        }
        if (notifier.isSendOnSuccess()) {
            if (sb.length() > 0) {
                sb.append('/');
            }
            sb.append("Success");
        }
        if (notifier.isSendOnWarning()) {
            if (sb.length() > 0) {
                sb.append('/');
            }
            sb.append("Warning");
        }
        if (notifier.isSendOnScmFailure()) {
            if (sb.length() > 0) {
                sb.append('/');
            }
            sb.append("SCM Failure");
        }
        ns.setEvents(sb.toString());
        ns.setEnabled(notifier.isEnabled());
        return ns;
    }

    public int getProjectGroupId() {
        return this.projectGroupId;
    }

    public void setProjectGroupId(int projectGroupId) {
        this.projectGroupId = projectGroupId;
    }

    public int getProjectId() {
        return this.projectId;
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    public ProjectGroup getProjectGroup() {
        return this.projectGroup;
    }

    public void setProjectGroup(ProjectGroup projectGroup) {
        this.projectGroup = projectGroup;
    }

    public List<NotifierSummary> getProjectGroupNotifierSummaries() {
        return this.projectGroupNotifierSummaries;
    }

    public void setProjectGroupNotifierSummaries(List<NotifierSummary> projectGroupNotifierSummaries) {
        this.projectGroupNotifierSummaries = projectGroupNotifierSummaries;
    }

    public List<NotifierSummary> getProjectNotifierSummaries() {
        return this.projectNotifierSummaries;
    }

    public void setProjectNotifierSummaries(List<NotifierSummary> projectNotifierSummaries) {
        this.projectNotifierSummaries = projectNotifierSummaries;
    }

    public String getProjectGroupName() throws ContinuumException {
        if (this.projectGroupName == null || "".equals(this.projectGroupName)) {
            this.projectGroupName = this.projectGroupId != 0 ? this.getContinuum().getProjectGroup(this.projectGroupId).getName() : this.getContinuum().getProjectGroupByProjectId(this.projectId).getName();
        }
        return this.projectGroupName;
    }
}

