/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action.component;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.model.project.BuildDefinition;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.model.project.ProjectGroup;
import org.apache.maven.continuum.web.action.AbstractBuildDefinitionAction;
import org.apache.maven.continuum.web.exception.AuthorizationRequiredException;
import org.apache.maven.continuum.web.model.BuildDefinitionSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildDefinitionSummaryAction
extends AbstractBuildDefinitionAction {
    private static final Logger logger = LoggerFactory.getLogger(BuildDefinitionSummaryAction.class);
    private int projectGroupId;
    private String projectGroupName;
    private int projectId;
    private int defaultGroupDefinitionId;
    private ProjectGroup projectGroup;
    private List<BuildDefinitionSummary> projectBuildDefinitionSummaries = new ArrayList();
    private List<BuildDefinitionSummary> groupBuildDefinitionSummaries = new ArrayList();
    private List<BuildDefinitionSummary> allBuildDefinitionSummaries = new ArrayList();

    public String summarizeForProject() {
        try {
            this.projectGroup = this.getContinuum().getProjectGroupByProjectId(this.projectId);
            this.projectGroupId = this.projectGroup.getId();
            this.projectGroupName = this.projectGroup.getName();
            this.checkViewProjectGroupAuthorization(this.projectGroupName);
            this.groupBuildDefinitionSummaries = this.gatherGroupBuildDefinitionSummaries(this.projectGroupId);
            this.projectBuildDefinitionSummaries = this.gatherProjectBuildDefinitionSummaries(this.projectId);
            this.fixDefaultBuildDefinitions();
            this.allBuildDefinitionSummaries.addAll(this.groupBuildDefinitionSummaries);
            this.allBuildDefinitionSummaries.addAll(this.projectBuildDefinitionSummaries);
        }
        catch (ContinuumException e) {
            logger.info("unable to build summary");
            return "error";
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        return "success";
    }

    public String summarizeForGroup() {
        try {
            this.groupBuildDefinitionSummaries = this.gatherGroupBuildDefinitionSummaries(this.projectGroupId);
            this.projectGroup = this.getContinuum().getProjectGroupWithProjects(this.projectGroupId);
            this.checkViewProjectGroupAuthorization(this.projectGroup.getName());
            for (Project project : this.projectGroup.getProjects()) {
                this.projectBuildDefinitionSummaries.addAll(this.gatherProjectBuildDefinitionSummaries(project.getId()));
            }
            this.allBuildDefinitionSummaries.addAll(this.groupBuildDefinitionSummaries);
            this.allBuildDefinitionSummaries.addAll(this.projectBuildDefinitionSummaries);
        }
        catch (ContinuumException e) {
            logger.info("unable to build summary");
            return "error";
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        return "success";
    }

    private void fixDefaultBuildDefinitions() {
        boolean containsDefaultBDForProject = false;
        for (BuildDefinitionSummary bds : this.projectBuildDefinitionSummaries) {
            if (!bds.isIsDefault()) continue;
            containsDefaultBDForProject = true;
        }
        for (BuildDefinitionSummary bds : this.groupBuildDefinitionSummaries) {
            if (bds.isIsDefault()) {
                this.defaultGroupDefinitionId = bds.getId();
            }
            if (!containsDefaultBDForProject) continue;
            bds.setIsDefault(false);
        }
    }

    private List<BuildDefinitionSummary> gatherProjectBuildDefinitionSummaries(int projectId) throws ContinuumException {
        ArrayList<BuildDefinitionSummary> summaryList = new ArrayList<BuildDefinitionSummary>();
        Project project = this.getContinuum().getProjectWithAllDetails(projectId);
        for (BuildDefinition bd : project.getBuildDefinitions()) {
            BuildDefinitionSummary bds = this.generateBuildDefinitionSummary(bd);
            bds.setFrom("PROJECT");
            bds.setProjectId(project.getId());
            bds.setProjectName(project.getName());
            summaryList.add(bds);
        }
        return summaryList;
    }

    private List<BuildDefinitionSummary> gatherGroupBuildDefinitionSummaries(int projectGroupId) throws ContinuumException {
        ArrayList<BuildDefinitionSummary> summaryList = new ArrayList<BuildDefinitionSummary>();
        this.projectGroup = this.getContinuum().getProjectGroupWithBuildDetails(projectGroupId);
        for (BuildDefinition bd : this.projectGroup.getBuildDefinitions()) {
            BuildDefinitionSummary bds = this.generateBuildDefinitionSummary(bd);
            bds.setFrom("GROUP");
            bds.setProjectGroupId(this.projectGroup.getId());
            summaryList.add(bds);
        }
        return summaryList;
    }

    public int getProjectId() {
        return this.projectId;
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    public int getProjectGroupId() {
        return this.projectGroupId;
    }

    public void setProjectGroupId(int projectGroupId) {
        this.projectGroupId = projectGroupId;
    }

    public String getProjectGroupName() {
        return this.projectGroupName;
    }

    public void setProjectGroupName(String projectGroupName) {
        this.projectGroupName = projectGroupName;
    }

    public List<BuildDefinitionSummary> getProjectBuildDefinitionSummaries() {
        return this.projectBuildDefinitionSummaries;
    }

    public void setProjectBuildDefinitionSummaries(List<BuildDefinitionSummary> projectBuildDefinitionSummaries) {
        this.projectBuildDefinitionSummaries = projectBuildDefinitionSummaries;
    }

    public List<BuildDefinitionSummary> getGroupBuildDefinitionSummaries() {
        return this.groupBuildDefinitionSummaries;
    }

    public void setGroupBuildDefinitionSummaries(List<BuildDefinitionSummary> groupBuildDefinitionSummaries) {
        this.groupBuildDefinitionSummaries = groupBuildDefinitionSummaries;
    }

    public List<BuildDefinitionSummary> getAllBuildDefinitionSummaries() {
        return this.allBuildDefinitionSummaries;
    }

    public void setAllBuildDefinitionSummaries(List<BuildDefinitionSummary> allBuildDefinitionSummaries) {
        this.allBuildDefinitionSummaries = allBuildDefinitionSummaries;
    }

    public ProjectGroup getProjectGroup() {
        return this.projectGroup;
    }

    public void setProjectGroup(ProjectGroup projectGroup) {
        this.projectGroup = projectGroup;
    }

    public int getDefaultGroupDefinitionId() {
        return this.defaultGroupDefinitionId;
    }
}

