/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action.admin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.continuum.buildmanager.BuildManagerException;
import org.apache.continuum.taskqueue.BuildProjectTask;
import org.apache.continuum.taskqueue.CheckOutTask;
import org.apache.continuum.taskqueue.PrepareBuildProjectsTask;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.model.project.ProjectGroup;
import org.apache.maven.continuum.web.action.ContinuumActionSupport;
import org.apache.maven.continuum.web.bean.BuildProjectQueue;
import org.apache.maven.continuum.web.bean.CheckoutQueue;
import org.apache.maven.continuum.web.exception.AuthenticationRequiredException;
import org.apache.maven.continuum.web.exception.AuthorizationRequiredException;
import org.apache.maven.continuum.web.model.DistributedBuildSummary;
import org.apache.maven.continuum.web.model.PrepareBuildSummary;
import org.codehaus.redback.integration.interceptor.SecureAction;
import org.codehaus.redback.integration.interceptor.SecureActionBundle;
import org.codehaus.redback.integration.interceptor.SecureActionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueuesAction
extends ContinuumActionSupport
implements SecureAction {
    private static final Logger logger = LoggerFactory.getLogger(QueuesAction.class);
    private static final String DISTRIBUTED_BUILD_SUCCESS = "distributed-build-success";
    private List<String> selectedPrepareBuildTaskHashCodes;
    private List<String> selectedBuildTaskHashCodes;
    private List<String> selectedCheckOutTaskHashCodes;
    private int buildDefinitionId;
    private int projectId;
    private int trigger;
    private String projectName;
    private List<BuildProjectQueue> currentBuildProjectTasks = new ArrayList();
    private List<CheckoutQueue> currentCheckoutTasks = new ArrayList();
    private List<BuildProjectQueue> buildsInQueue = new ArrayList();
    private List<CheckoutQueue> checkoutsInQueue = new ArrayList();
    private List<PrepareBuildSummary> currentPrepareBuilds = new ArrayList();
    private List<PrepareBuildSummary> prepareBuildQueues = new ArrayList();
    private List<PrepareBuildSummary> currentDistributedPrepareBuilds = new ArrayList();
    private List<PrepareBuildSummary> distributedPrepareBuildQueues = new ArrayList();
    private List<DistributedBuildSummary> currentDistributedBuilds = new ArrayList();
    private List<DistributedBuildSummary> distributedBuildQueues = new ArrayList();
    private String buildAgentUrl;
    private int projectGroupId;
    private int scmRootId;

    public String cancelCurrent() throws Exception {
        try {
            this.checkManageQueuesAuthorization();
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        catch (AuthenticationRequiredException e) {
            this.addActionError(e.getMessage());
            return "requires-authentication";
        }
        try {
            this.getContinuum().getBuildsManager().cancelBuild(this.projectId);
        }
        catch (BuildManagerException e) {
            this.addActionError(e.getMessage());
            return "error";
        }
        return "success";
    }

    public String removeCheckout() throws Exception {
        try {
            this.checkManageQueuesAuthorization();
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        catch (AuthenticationRequiredException e) {
            this.addActionError(e.getMessage());
            return "requires-authentication";
        }
        try {
            this.getContinuum().getBuildsManager().removeProjectFromCheckoutQueue(this.projectId);
        }
        catch (BuildManagerException e) {
            this.addActionError(e.getMessage());
            return "error";
        }
        return "success";
    }

    public String cancelCurrentCheckout() throws Exception {
        try {
            this.checkManageQueuesAuthorization();
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        catch (AuthenticationRequiredException e) {
            this.addActionError(e.getMessage());
            return "requires-authentication";
        }
        try {
            this.cancelCheckout(this.projectId);
        }
        catch (BuildManagerException e) {
            this.addActionError(e.getMessage());
            return "error";
        }
        return "success";
    }

    public String display() throws Exception {
        BuildProjectQueue queue;
        BuildProjectQueue queue2;
        Set keySet;
        if (this.getContinuum().getConfiguration().isDistributedBuildEnabled()) {
            PrepareBuildSummary summary;
            Map currentPrepareBuildMap = this.getContinuum().getDistributedBuildManager().getProjectsCurrentlyPreparingBuild();
            for (String url : currentPrepareBuildMap.keySet()) {
                PrepareBuildProjectsTask task = (PrepareBuildProjectsTask)currentPrepareBuildMap.get(url);
                ProjectGroup projectGroup = this.getContinuum().getProjectGroup(task.getProjectGroupId());
                PrepareBuildSummary summary2 = new PrepareBuildSummary();
                summary2.setBuildAgentUrl(url);
                summary2.setProjectGroupId(task.getProjectGroupId());
                summary2.setProjectGroupName(projectGroup.getName());
                summary2.setScmRootAddress(task.getScmRootAddress());
                summary2.setScmRootId(task.getProjectScmRootId());
                this.currentDistributedPrepareBuilds.add(summary2);
            }
            Map currentBuildMap = this.getContinuum().getDistributedBuildManager().getProjectsCurrentlyBuilding();
            for (String url : currentBuildMap.keySet()) {
                BuildProjectTask task = (BuildProjectTask)currentBuildMap.get(url);
                Project project = this.getContinuum().getProject(task.getProjectId());
                DistributedBuildSummary summary3 = new DistributedBuildSummary();
                summary3.setProjectId(project.getId());
                summary3.setProjectName(project.getName());
                summary3.setProjectGroupName(project.getProjectGroup().getName());
                summary3.setBuildDefinitionId(task.getBuildDefinitionId());
                summary3.setBuildDefinitionLabel(task.getBuildDefinitionLabel());
                summary3.setHashCode(task.getHashCode());
                summary3.setBuildAgentUrl(url);
                this.currentDistributedBuilds.add(summary3);
            }
            Map prepareBuildMap = this.getContinuum().getDistributedBuildManager().getProjectsInPrepareBuildQueue();
            for (String url : prepareBuildMap.keySet()) {
                for (PrepareBuildProjectsTask task : (List)prepareBuildMap.get(url)) {
                    ProjectGroup projectGroup = this.getContinuum().getProjectGroup(task.getProjectGroupId());
                    summary = new PrepareBuildSummary();
                    summary.setBuildAgentUrl(url);
                    summary.setProjectGroupId(task.getProjectGroupId());
                    summary.setProjectGroupName(projectGroup.getName());
                    summary.setScmRootAddress(task.getScmRootAddress());
                    summary.setScmRootId(task.getProjectScmRootId());
                    summary.setHashCode(task.getHashCode());
                    this.distributedPrepareBuildQueues.add(summary);
                }
            }
            Map buildMap = this.getContinuum().getDistributedBuildManager().getProjectsInBuildQueue();
            for (String url : buildMap.keySet()) {
                for (BuildProjectTask task : (List)buildMap.get(url)) {
                    summary = new DistributedBuildSummary();
                    Project project = this.getContinuum().getProject(task.getProjectId());
                    summary.setProjectId(project.getId());
                    summary.setProjectName(project.getName());
                    summary.setProjectGroupName(project.getProjectGroup().getName());
                    summary.setBuildDefinitionId(task.getBuildDefinitionId());
                    summary.setBuildDefinitionLabel(task.getBuildDefinitionLabel());
                    summary.setHashCode(task.getHashCode());
                    summary.setBuildAgentUrl(url);
                    this.distributedBuildQueues.add(summary);
                }
            }
            return DISTRIBUTED_BUILD_SUCCESS;
        }
        try {
            PrepareBuildProjectsTask currentPrepareBuildTask = this.getContinuum().getBuildsManager().getCurrentProjectInPrepareBuild();
            if (currentPrepareBuildTask != null) {
                PrepareBuildSummary s = new PrepareBuildSummary();
                s.setProjectGroupId(currentPrepareBuildTask.getProjectGroupId());
                s.setProjectGroupName(currentPrepareBuildTask.getProjectGroupName());
                s.setScmRootId(currentPrepareBuildTask.getProjectScmRootId());
                s.setScmRootAddress(currentPrepareBuildTask.getScmRootAddress());
                this.currentPrepareBuilds.add(s);
            }
        }
        catch (BuildManagerException e) {
            this.addActionError(e.getMessage());
            return "error";
        }
        try {
            Map currentBuilds = this.getContinuum().getBuildsManager().getCurrentBuilds();
            keySet = currentBuilds.keySet();
            for (String key : keySet) {
                BuildProjectTask buildTask = (BuildProjectTask)currentBuilds.get(key);
                queue2 = new BuildProjectQueue();
                queue2.setName(key);
                queue2.setTask(buildTask);
                this.currentBuildProjectTasks.add(queue2);
            }
        }
        catch (BuildManagerException e) {
            this.addActionError(e.getMessage());
            return "error";
        }
        try {
            List prepareBuilds = this.getContinuum().getBuildsManager().getProjectsInPrepareBuildQueue();
            for (PrepareBuildProjectsTask task : prepareBuilds) {
                PrepareBuildSummary summary = new PrepareBuildSummary();
                summary.setProjectGroupId(task.getProjectGroupId());
                summary.setProjectGroupName(task.getProjectGroupName());
                summary.setScmRootId(task.getProjectScmRootId());
                summary.setScmRootAddress(task.getScmRootAddress());
                summary.setHashCode(task.getHashCode());
                this.prepareBuildQueues.add(summary);
            }
        }
        catch (BuildManagerException e) {
            this.addActionError(e.getMessage());
            return "error";
        }
        try {
            Map builds = this.getContinuum().getBuildsManager().getProjectsInBuildQueues();
            keySet = builds.keySet();
            for (String key : keySet) {
                for (BuildProjectTask task : (List)builds.get(key)) {
                    queue = new BuildProjectQueue();
                    queue.setName(key);
                    queue.setTask(task);
                    this.buildsInQueue.add(queue);
                }
            }
        }
        catch (BuildManagerException e) {
            this.addActionError(e.getMessage());
            return "error";
        }
        try {
            Map currentCheckouts = this.getContinuum().getBuildsManager().getCurrentCheckouts();
            keySet = currentCheckouts.keySet();
            for (String key : keySet) {
                CheckOutTask checkoutTask = (CheckOutTask)currentCheckouts.get(key);
                queue2 = new CheckoutQueue();
                queue2.setName(key);
                queue2.setTask(checkoutTask);
                this.currentCheckoutTasks.add(queue2);
            }
        }
        catch (BuildManagerException e) {
            this.addActionError(e.getMessage());
            return "error";
        }
        try {
            Map checkouts = this.getContinuum().getBuildsManager().getProjectsInCheckoutQueues();
            keySet = checkouts.keySet();
            for (String key : keySet) {
                for (BuildProjectTask task : (List)checkouts.get(key)) {
                    queue = new CheckoutQueue();
                    queue.setName(key);
                    queue.setTask((CheckOutTask)task);
                    this.checkoutsInQueue.add(queue);
                }
            }
        }
        catch (BuildManagerException e) {
            this.addActionError(e.getMessage());
            return "error";
        }
        return "success";
    }

    public String remove() throws Exception {
        try {
            this.checkManageQueuesAuthorization();
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        catch (AuthenticationRequiredException e) {
            this.addActionError(e.getMessage());
            return "requires-authentication";
        }
        this.getContinuum().getBuildsManager().removeProjectFromBuildQueue(this.projectId, this.buildDefinitionId, this.trigger, this.projectName, this.projectGroupId);
        Project project = this.getContinuum().getProject(this.projectId);
        project.setState(project.getOldState());
        this.getContinuum().updateProject(project);
        return "success";
    }

    public String removeBuildEntries() throws Exception {
        try {
            this.checkManageQueuesAuthorization();
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        catch (AuthenticationRequiredException e) {
            this.addActionError(e.getMessage());
            return "requires-authentication";
        }
        this.getContinuum().getBuildsManager().removeProjectsFromBuildQueueWithHashcodes(this.listToIntArray(this.getSelectedBuildTaskHashCodes()));
        return "success";
    }

    public String removeCheckoutEntries() throws Exception {
        try {
            this.checkManageQueuesAuthorization();
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        catch (AuthenticationRequiredException e) {
            this.addActionError(e.getMessage());
            return "requires-authentication";
        }
        this.getContinuum().getBuildsManager().removeProjectsFromCheckoutQueueWithHashcodes(this.listToIntArray(this.getSelectedCheckOutTaskHashCodes()));
        return "success";
    }

    public String removePrepareBuildEntry() throws Exception {
        try {
            this.checkManageQueuesAuthorization();
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        catch (AuthenticationRequiredException e) {
            this.addActionError(e.getMessage());
            return "requires-authentication";
        }
        this.getContinuum().getBuildsManager().removeProjectFromPrepareBuildQueue(this.projectGroupId, this.scmRootId);
        return "success";
    }

    public String removePrepareBuildEntries() throws Exception {
        try {
            this.checkManageQueuesAuthorization();
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        catch (AuthenticationRequiredException e) {
            this.addActionError(e.getMessage());
            return "requires-authentication";
        }
        this.getContinuum().getBuildsManager().removeProjectsFromPrepareBuildQueueWithHashCodes(this.listToIntArray(this.selectedPrepareBuildTaskHashCodes));
        return "success";
    }

    public String cancelDistributedBuild() throws Exception {
        try {
            this.checkManageQueuesAuthorization();
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        catch (AuthenticationRequiredException e) {
            this.addActionError(e.getMessage());
            return "requires-authentication";
        }
        this.getContinuum().getDistributedBuildManager().cancelDistributedBuild(this.buildAgentUrl);
        return "success";
    }

    public String removeDistributedPrepareBuildEntry() throws Exception {
        try {
            this.checkManageQueuesAuthorization();
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        catch (AuthenticationRequiredException e) {
            this.addActionError(e.getMessage());
            return "requires-authentication";
        }
        this.getContinuum().getDistributedBuildManager().removeFromPrepareBuildQueue(this.buildAgentUrl, this.projectGroupId, this.scmRootId);
        return "success";
    }

    public String removeDistributedPrepareBuildEntries() throws Exception {
        try {
            this.checkManageQueuesAuthorization();
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        catch (AuthenticationRequiredException e) {
            this.addActionError(e.getMessage());
            return "requires-authentication";
        }
        this.getContinuum().getDistributedBuildManager().removeFromPrepareBuildQueue(this.getSelectedPrepareBuildTaskHashCodes());
        return "success";
    }

    public String removeDistributedBuildEntry() throws Exception {
        try {
            this.checkManageQueuesAuthorization();
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        catch (AuthenticationRequiredException e) {
            this.addActionError(e.getMessage());
            return "requires-authentication";
        }
        this.getContinuum().getDistributedBuildManager().removeFromBuildQueue(this.buildAgentUrl, this.projectId, this.buildDefinitionId);
        return "success";
    }

    public String removeDistributedBuildEntries() throws Exception {
        try {
            this.checkManageQueuesAuthorization();
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        catch (AuthenticationRequiredException e) {
            this.addActionError(e.getMessage());
            return "requires-authentication";
        }
        this.getContinuum().getDistributedBuildManager().removeFromBuildQueue(this.getSelectedBuildTaskHashCodes());
        return "success";
    }

    private int[] listToIntArray(List<String> strings) {
        if (strings == null || strings.isEmpty()) {
            return new int[0];
        }
        int[] array = new int[]{};
        for (String intString : strings) {
            array = ArrayUtils.add((int[])array, (int)Integer.parseInt(intString));
        }
        return array;
    }

    public SecureActionBundle getSecureActionBundle() throws SecureActionException {
        SecureActionBundle bundle = new SecureActionBundle();
        bundle.setRequiresAuthentication(true);
        bundle.addRequiredAuthorization("continuum-view-queues", "*");
        return bundle;
    }

    private boolean cancelCheckout(int projectId) throws BuildManagerException {
        Map tasks = this.getContinuum().getBuildsManager().getCurrentCheckouts();
        if (tasks != null) {
            Set keySet = tasks.keySet();
            for (String key : keySet) {
                CheckOutTask task = (CheckOutTask)tasks.get(key);
                if (task == null) continue;
                if (task.getProjectId() == projectId) {
                    logger.info("Cancelling checkout for project " + projectId);
                    return this.getContinuum().getBuildsManager().cancelCheckout(projectId);
                }
                logger.warn("Current task is not for the given projectId (" + projectId + "): " + task.getProjectId() + "; not cancelling checkout");
            }
        } else {
            logger.warn("No task running - not cancelling checkout");
        }
        return false;
    }

    public int getBuildDefinitionId() {
        return this.buildDefinitionId;
    }

    public void setBuildDefinitionId(int buildDefinitionId) {
        this.buildDefinitionId = buildDefinitionId;
    }

    public int getProjectId() {
        return this.projectId;
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    public int getTrigger() {
        return this.trigger;
    }

    public void setTrigger(int trigger) {
        this.trigger = trigger;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public List<String> getSelectedBuildTaskHashCodes() {
        return this.selectedBuildTaskHashCodes;
    }

    public void setSelectedBuildTaskHashCodes(List<String> selectedBuildTaskHashCodes) {
        this.selectedBuildTaskHashCodes = selectedBuildTaskHashCodes;
    }

    public List<String> getSelectedCheckOutTaskHashCodes() {
        return this.selectedCheckOutTaskHashCodes;
    }

    public void setSelectedCheckOutTaskHashCodes(List<String> selectedCheckOutTaskHashCodes) {
        this.selectedCheckOutTaskHashCodes = selectedCheckOutTaskHashCodes;
    }

    public List<BuildProjectQueue> getCurrentBuildProjectTasks() {
        return this.currentBuildProjectTasks;
    }

    public void setCurrentBuildProjectTasks(List<BuildProjectQueue> currentBuildProjectTasks) {
        this.currentBuildProjectTasks = currentBuildProjectTasks;
    }

    public List<CheckoutQueue> getCurrentCheckoutTasks() {
        return this.currentCheckoutTasks;
    }

    public void setCurrentCheckoutTasks(List<CheckoutQueue> currentCheckoutTasks) {
        this.currentCheckoutTasks = currentCheckoutTasks;
    }

    public List<BuildProjectQueue> getBuildsInQueue() {
        return this.buildsInQueue;
    }

    public void setBuildsInQueue(List<BuildProjectQueue> buildsInQueue) {
        this.buildsInQueue = buildsInQueue;
    }

    public List<CheckoutQueue> getCheckoutsInQueue() {
        return this.checkoutsInQueue;
    }

    public void setCheckoutsInQueue(List<CheckoutQueue> checkoutsInQueue) {
        this.checkoutsInQueue = checkoutsInQueue;
    }

    public List<PrepareBuildSummary> getCurrentDistributedPrepareBuilds() {
        return this.currentDistributedPrepareBuilds;
    }

    public List<DistributedBuildSummary> getCurrentDistributedBuilds() {
        return this.currentDistributedBuilds;
    }

    public List<PrepareBuildSummary> getDistributedPrepareBuildQueues() {
        return this.distributedPrepareBuildQueues;
    }

    public List<DistributedBuildSummary> getDistributedBuildQueues() {
        return this.distributedBuildQueues;
    }

    public List<PrepareBuildSummary> getCurrentPrepareBuilds() {
        return this.currentPrepareBuilds;
    }

    public List<PrepareBuildSummary> getPrepareBuildQueues() {
        return this.prepareBuildQueues;
    }

    public String getBuildAgentUrl() {
        return this.buildAgentUrl;
    }

    public void setBuildAgentUrl(String buildAgentUrl) {
        this.buildAgentUrl = buildAgentUrl;
    }

    public void setProjectGroupId(int projectGroupId) {
        this.projectGroupId = projectGroupId;
    }

    public void setScmRootId(int scmRootId) {
        this.scmRootId = scmRootId;
    }

    public void setSelectedPrepareBuildTaskHashCodes(List<String> selectedPrepareBuildTaskHashCodes) {
        this.selectedPrepareBuildTaskHashCodes = selectedPrepareBuildTaskHashCodes;
    }

    public List<String> getSelectedPrepareBuildTaskHashCodes() {
        return this.selectedPrepareBuildTaskHashCodes;
    }
}

