/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action.admin;

import com.opensymphony.xwork2.ModelDriven;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.continuum.execution.maven.m2.MavenBuilderHelper;
import org.apache.maven.continuum.execution.maven.m2.SettingsConfigurationException;
import org.apache.maven.continuum.web.action.component.AbstractFooterAction;
import org.apache.maven.continuum.web.appareance.AppareanceConfiguration;
import org.apache.maven.model.Model;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.settings.MavenSettingsBuilder;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.app.company.CompanyPomHandler;
import org.apache.maven.shared.app.configuration.Configuration;
import org.apache.maven.shared.app.configuration.MavenAppConfiguration;
import org.codehaus.plexus.registry.RegistryException;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.codehaus.redback.integration.interceptor.SecureAction;
import org.codehaus.redback.integration.interceptor.SecureActionBundle;
import org.codehaus.redback.integration.interceptor.SecureActionException;

public class ConfigureAppearanceAction
extends AbstractFooterAction
implements ModelDriven,
SecureAction {
    private MavenAppConfiguration appConfiguration;
    private Configuration configuration;
    private Model companyModel;
    private CompanyPomHandler companyPomHandler;
    private MavenBuilderHelper helper;
    private MavenSettingsBuilder mavenSettingsBuilder;
    private ArtifactRepositoryFactory artifactRepositoryFactory;
    private ArtifactRepositoryLayout layout;
    private AppareanceConfiguration appareanceConfiguration;

    public String execute() throws IOException, RegistryException {
        this.appConfiguration.save(this.configuration);
        return "success";
    }

    public String input() throws IOException, RegistryException {
        return "input";
    }

    public Object getModel() {
        return this.configuration;
    }

    public void prepare() throws ProjectBuildingException, ArtifactMetadataRetrievalException, SettingsConfigurationException, XmlPullParserException, IOException {
        Settings settings = this.mavenSettingsBuilder.buildSettings(false);
        List profileIds = settings.getActiveProfiles();
        List profiles = settings.getProfiles();
        ArrayList<ArtifactRepository> remoteRepositories = new ArrayList<ArtifactRepository>();
        Map profilesAsMap = settings.getProfilesAsMap();
        if (profileIds != null && !profileIds.isEmpty()) {
            for (String profileId : profileIds) {
                List repos;
                Profile profile = (Profile)profilesAsMap.get(profileId);
                if (profile == null || (repos = profile.getRepositories()) == null || repos.isEmpty()) continue;
                for (Repository repo : repos) {
                    remoteRepositories.add(this.artifactRepositoryFactory.createArtifactRepository(repo.getId(), repo.getUrl(), this.layout, null, null));
                }
            }
        }
        this.configuration = this.appConfiguration.getConfiguration();
        this.companyModel = this.companyPomHandler.getCompanyPomModel(this.configuration.getCompanyPom(), this.helper.getLocalRepository(), remoteRepositories);
        this.setFooter(this.appareanceConfiguration.getFooter());
    }

    public Model getCompanyModel() {
        return this.companyModel;
    }

    public SecureActionBundle getSecureActionBundle() throws SecureActionException {
        SecureActionBundle bundle = new SecureActionBundle();
        bundle.setRequiresAuthentication(true);
        bundle.addRequiredAuthorization("continuum-manage-configuration", "*");
        return bundle;
    }
}

