/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.configuration.ConfigurationException;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.reports.surefire.ReportTest;
import org.apache.maven.continuum.reports.surefire.ReportTestSuite;
import org.apache.maven.continuum.reports.surefire.ReportTestSuiteGenerator;
import org.apache.maven.continuum.reports.surefire.ReportTestSuiteGeneratorException;
import org.apache.maven.continuum.web.action.ContinuumActionSupport;
import org.apache.maven.continuum.web.exception.AuthorizationRequiredException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SurefireReportAction
extends ContinuumActionSupport {
    private ReportTestSuiteGenerator reportTestSuiteGenerator;
    private int buildId;
    private int projectId;
    private List<ReportTestSuite> testSuites;
    private List<ReportTest> testSummaryList;
    private List<ReportTest> testPackageList;
    private String projectName;
    private Project project;

    public String execute() throws ContinuumException, ConfigurationException, ReportTestSuiteGeneratorException {
        try {
            this.checkViewProjectGroupAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException e) {
            return "requires-authorization";
        }
        this.project = this.getProjectById(this.projectId);
        this.testSuites = this.reportTestSuiteGenerator.generateReports(this.buildId, this.projectId);
        this.getSummary(this.testSuites);
        this.getDetails(this.testSuites);
        return "success";
    }

    private void getSummary(List<ReportTestSuite> suiteList) {
        int totalTests = 0;
        int totalErrors = 0;
        int totalFailures = 0;
        float totalTime = 0.0f;
        for (ReportTestSuite suite : suiteList) {
            totalTests += suite.getNumberOfTests();
            totalErrors += suite.getNumberOfErrors();
            totalFailures += suite.getNumberOfFailures();
            totalTime += suite.getTimeElapsed();
        }
        ReportTest report = new ReportTest();
        report.setTests(totalTests);
        report.setErrors(totalErrors);
        report.setFailures(totalFailures);
        report.setElapsedTime(totalTime);
        this.testSummaryList = Collections.singletonList(report);
    }

    private void getDetails(List<ReportTestSuite> suiteList) {
        LinkedHashMap<String, ReportTest> testsByPackage = new LinkedHashMap<String, ReportTest>();
        for (ReportTestSuite suite : suiteList) {
            ReportTest report = (ReportTest)testsByPackage.get(suite.getPackageName());
            if (report == null) {
                report = new ReportTest();
                report.setId(suite.getPackageName());
                report.setName(suite.getPackageName());
            }
            report.setTests(report.getTests() + suite.getNumberOfTests());
            report.setErrors(report.getErrors() + suite.getNumberOfErrors());
            report.setFailures(report.getFailures() + suite.getNumberOfFailures());
            report.setElapsedTime(report.getElapsedTime() + suite.getTimeElapsed());
            ReportTest reportTest = new ReportTest();
            reportTest.setId(suite.getPackageName() + "." + suite.getName());
            reportTest.setName(suite.getName());
            reportTest.setTests(suite.getNumberOfTests());
            reportTest.setErrors(suite.getNumberOfErrors());
            reportTest.setFailures(suite.getNumberOfFailures());
            reportTest.setElapsedTime(suite.getTimeElapsed());
            reportTest.setChildren(suite.getTestCases());
            report.getChildren().add(reportTest);
            testsByPackage.put(suite.getPackageName(), report);
        }
        this.testPackageList = new ArrayList(testsByPackage.values());
    }

    public int getBuildId() {
        return this.buildId;
    }

    public void setBuildId(int buildId) {
        this.buildId = buildId;
    }

    public Project getProject() {
        return this.project;
    }

    public int getProjectId() {
        return this.projectId;
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    public List<ReportTestSuite> getTestSuites() {
        return this.testSuites;
    }

    public void setTestSuites(List<ReportTestSuite> testSuites) {
        this.testSuites = testSuites;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public List<ReportTest> getTestSummaryList() {
        return this.testSummaryList;
    }

    public void setTestSummaryList(List<ReportTest> testSummaryList) {
        this.testSummaryList = testSummaryList;
    }

    public List<ReportTest> getTestPackageList() {
        return this.testPackageList;
    }

    public void setTestPackageList(List<ReportTest> testPackageList) {
        this.testPackageList = testPackageList;
    }

    public Project getProjectById(int projectId) throws ContinuumException {
        return this.getContinuum().getProject(projectId);
    }

    public String getProjectGroupName() throws ContinuumException {
        return this.getProjectById(this.projectId).getProjectGroup().getName();
    }
}

