/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action;

import com.opensymphony.xwork2.Preparable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.continuum.web.util.AuditLog;
import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.model.project.BuildQueue;
import org.apache.maven.continuum.model.project.Schedule;
import org.apache.maven.continuum.web.action.ContinuumConfirmAction;
import org.apache.maven.continuum.web.exception.AuthenticationRequiredException;
import org.apache.maven.continuum.web.exception.AuthorizationRequiredException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduleAction
extends ContinuumConfirmAction
implements Preparable {
    private static final Logger logger = LoggerFactory.getLogger(ScheduleAction.class);
    private int id;
    private boolean active = false;
    private int delay;
    private String description;
    private String name;
    private Collection schedules;
    private Schedule schedule;
    private boolean confirmed;
    private int maxJobExecutionTime;
    private String second = "0";
    private String minute = "0";
    private String hour = "*";
    private String dayOfMonth = "*";
    private String month = "*";
    private String dayOfWeek = "?";
    private String year;
    private List<BuildQueue> availableBuildQueues;
    private List<BuildQueue> selectedBuildQueues = new ArrayList();
    private List<String> selectedBuildQueuesIds = new ArrayList();

    public void prepare() throws Exception {
        super.prepare();
        this.populateBuildQueues();
    }

    private void populateBuildQueues() throws ContinuumException {
        if (this.schedule != null) {
            this.selectedBuildQueues = this.schedule.getBuildQueues();
            for (BuildQueue bq : this.selectedBuildQueues) {
                this.selectedBuildQueuesIds.add(Integer.toString(bq.getId()));
            }
        }
        this.availableBuildQueues = this.getContinuum().getAllBuildQueues();
        for (BuildQueue buildQueue : this.selectedBuildQueues) {
            if (!this.availableBuildQueues.contains(buildQueue)) continue;
            this.availableBuildQueues.remove(buildQueue);
        }
    }

    public String summary() throws ContinuumException {
        try {
            this.checkManageSchedulesAuthorization();
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        catch (AuthenticationRequiredException e) {
            this.addActionError(e.getMessage());
            return "requires-authentication";
        }
        this.schedules = this.getContinuum().getSchedules();
        return "success";
    }

    public String input() throws ContinuumException {
        try {
            this.checkManageSchedulesAuthorization();
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        catch (AuthenticationRequiredException e) {
            this.addActionError(e.getMessage());
            return "requires-authentication";
        }
        if (this.id != 0) {
            this.schedule = this.getContinuum().getSchedule(this.id);
            this.active = this.schedule.isActive();
            String[] cronEx = this.schedule.getCronExpression().split(" ");
            this.second = cronEx[0];
            this.minute = cronEx[1];
            this.hour = cronEx[2];
            this.dayOfMonth = cronEx[3];
            this.month = cronEx[4];
            this.dayOfWeek = cronEx[5];
            if (cronEx.length > 6) {
                this.year = cronEx[6];
            }
            this.description = this.schedule.getDescription();
            this.name = this.schedule.getName();
            this.delay = this.schedule.getDelay();
            this.maxJobExecutionTime = this.schedule.getMaxJobExecutionTime();
            this.populateBuildQueues();
        } else {
            this.active = true;
        }
        return "success";
    }

    public String save() throws ContinuumException {
        try {
            this.checkManageSchedulesAuthorization();
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        catch (AuthenticationRequiredException e) {
            this.addActionError(e.getMessage());
            return "requires-authentication";
        }
        if (StringUtils.isBlank((String)this.name)) {
            logger.error("Can't create schedule. No schedule name was supplied.");
            this.addActionError(this.getText("buildDefinition.noname.save.error.message"));
        }
        if (!this.getContinuum().getConfiguration().isDistributedBuildEnabled() && (this.selectedBuildQueuesIds == null || this.selectedBuildQueuesIds.isEmpty())) {
            this.addActionError(this.getText("schedule.buildqueues.empty.error"));
        }
        if (this.hasErrors()) {
            return "error";
        }
        try {
            Schedule s = this.getContinuum().getScheduleByName(this.name);
            if (s != null && this.id != s.getId()) {
                this.addActionError(this.getText("schedule.name.already.exists"));
                return "error";
            }
        }
        catch (ContinuumException e) {
            logger.debug("Unexpected error getting schedule");
        }
        AuditLog event = new AuditLog(this.getName(), "Added Build Schedule");
        event.setCategory("BUILD_SCHEDULE");
        event.setCurrentUser(this.getPrincipal());
        if (this.id == 0) {
            try {
                this.getContinuum().addSchedule(this.setFields(new Schedule()));
                event.log();
            }
            catch (ContinuumException e) {
                this.addActionError(this.getText("schedule.buildqueues.add.error"));
                return "error";
            }
            return "success";
        }
        try {
            this.getContinuum().updateSchedule(this.setFields(this.getContinuum().getSchedule(this.id)));
            event.setAction("Modified Build Schedule");
            event.log();
        }
        catch (ContinuumException e) {
            this.addActionError(this.getText("schedule.buildqueues.add.error"));
            return "error";
        }
        return "success";
    }

    private Schedule setFields(Schedule schedule) throws ContinuumException {
        schedule.setActive(this.active);
        schedule.setCronExpression(this.getCronExpression());
        schedule.setDelay(this.delay);
        schedule.setDescription(this.description);
        schedule.setName(this.name);
        schedule.setMaxJobExecutionTime(this.maxJobExecutionTime);
        if (!this.getContinuum().getConfiguration().isDistributedBuildEnabled()) {
            schedule.setBuildQueues(null);
            for (String id : this.selectedBuildQueuesIds) {
                BuildQueue buildQueue = this.getContinuum().getBuildQueue(Integer.parseInt(id));
                schedule.addBuildQueue(buildQueue);
            }
        }
        return schedule;
    }

    public String confirm() throws ContinuumException {
        try {
            this.checkManageSchedulesAuthorization();
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        catch (AuthenticationRequiredException e) {
            this.addActionError(e.getMessage());
            return "requires-authentication";
        }
        this.schedule = this.getContinuum().getSchedule(this.id);
        return "success";
    }

    public String remove() throws ContinuumException {
        try {
            this.checkManageSchedulesAuthorization();
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        catch (AuthenticationRequiredException e) {
            this.addActionError(e.getMessage());
            return "requires-authentication";
        }
        if (this.confirmed) {
            try {
                this.getContinuum().removeSchedule(this.id);
            }
            catch (ContinuumException e) {
                this.addActionError(this.getText("schedule.remove.error"));
                return "error";
            }
        } else {
            this.setConfirmationInfo("Schedule Removal", "removeSchedule", this.name, "id", "" + this.id);
            this.name = this.getContinuum().getSchedule(this.id).getName();
            return "confirm";
        }
        AuditLog event = new AuditLog(this.name, "Removed Build Schedule");
        event.setCategory("BUILD_SCHEDULE");
        event.setCurrentUser(this.getPrincipal());
        event.log();
        return "success";
    }

    public Collection getSchedules() {
        return this.schedules;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    public void setSchedule(Schedule schedule) {
        this.schedule = schedule;
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    public int getMaxJobExecutionTime() {
        return this.maxJobExecutionTime;
    }

    public void setMaxJobExecutionTime(int maxJobExecutionTime) {
        this.maxJobExecutionTime = maxJobExecutionTime;
    }

    public String getSecond() {
        return this.second;
    }

    public void setSecond(String second) {
        this.second = second;
    }

    public String getMinute() {
        return this.minute;
    }

    public void setMinute(String minute) {
        this.minute = minute;
    }

    public String getHour() {
        return this.hour;
    }

    public void setHour(String hour) {
        this.hour = hour;
    }

    public String getDayOfMonth() {
        return this.dayOfMonth;
    }

    public void setDayOfMonth(String dayOfMonth) {
        this.dayOfMonth = dayOfMonth;
    }

    public String getYear() {
        return this.year;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public String getMonth() {
        return this.month;
    }

    public void setMonth(String month) {
        this.month = month;
    }

    public String getDayOfWeek() {
        return this.dayOfWeek;
    }

    public void setDayOfWeek(String dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
    }

    private String getCronExpression() {
        return (this.second + " " + this.minute + " " + this.hour + " " + this.dayOfMonth + " " + this.month + " " + this.dayOfWeek + " " + this.year).trim();
    }

    public List<BuildQueue> getAvailableBuildQueues() {
        return this.availableBuildQueues;
    }

    public void setAvailableBuildQueues(List<BuildQueue> availableBuildQueues) {
        this.availableBuildQueues = availableBuildQueues;
    }

    public List<BuildQueue> getSelectedBuildQueues() {
        return this.selectedBuildQueues;
    }

    public void setSelectedBuildQueues(List<BuildQueue> selectedBuildQueues) {
        this.selectedBuildQueues = selectedBuildQueues;
    }

    public List<String> getSelectedBuildQueuesIds() {
        return this.selectedBuildQueuesIds;
    }

    public void setSelectedBuildQueuesIds(List<String> selectedBuildQueuesIds) {
        this.selectedBuildQueuesIds = selectedBuildQueuesIds;
    }
}

