/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.continuum.configuration.BuildAgentConfigurationException;
import org.apache.continuum.release.distributed.DistributedReleaseUtil;
import org.apache.continuum.release.distributed.manager.DistributedReleaseManager;
import org.apache.continuum.web.action.AbstractReleaseAction;
import org.apache.continuum.web.util.AuditLog;
import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.model.system.Profile;
import org.apache.maven.continuum.release.ContinuumReleaseManager;
import org.apache.maven.continuum.release.ContinuumReleaseManagerListener;
import org.apache.maven.continuum.release.DefaultReleaseManagerListener;
import org.apache.maven.continuum.web.exception.AuthorizationRequiredException;
import org.apache.maven.continuum.web.model.ReleaseListenerSummary;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.versions.DefaultVersionInfo;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReleasePrepareAction
extends AbstractReleaseAction {
    private static final String SCM_SVN_PROTOCOL_PREFIX = "scm:svn";
    private static final String SNAPSHOT_VERSION_SUFFIX = "-SNAPSHOT";
    private int projectId;
    private String releaseId;
    private String name;
    private String scmUsername;
    private String scmPassword;
    private String scmTag;
    private String scmTagBase;
    private String scmCommentPrefix;
    private boolean scmUseEditMode = false;
    private List<Map<String, String>> projects = new ArrayList();
    private List<String> projectKeys;
    private List<String> devVersions;
    private List<String> relVersions;
    private String prepareGoals;
    private String arguments;
    private ReleaseResult result;
    private ContinuumReleaseManagerListener listener;
    private String projectGroupName = "";
    private List<Profile> profiles;
    private int profileId;
    private boolean autoVersionSubmodules = false;
    private boolean addSchema = true;
    private ReleaseListenerSummary listenerSummary;

    public String input() throws Exception {
        String scmUrl;
        try {
            this.checkBuildProjectInGroupAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException e) {
            return "requires-authorization";
        }
        Project project = this.getContinuum().getProject(this.projectId);
        this.scmUsername = project.getScmUsername();
        this.scmPassword = project.getScmPassword();
        this.scmTag = project.getScmTag();
        if (this.scmTag == null) {
            String version = project.getVersion();
            int idx = version.indexOf(SNAPSHOT_VERSION_SUFFIX);
            this.scmTag = idx >= 0 ? project.getArtifactId() + "-" + version.substring(0, idx) : project.getArtifactId() + "-" + version;
        }
        if ((scmUrl = project.getScmUrl()).startsWith(SCM_SVN_PROTOCOL_PREFIX)) {
            this.scmTagBase = new SvnScmProviderRepository(scmUrl, this.scmUsername, this.scmPassword).getTagBase();
            this.scmTagBase = this.scmTagBase.substring(SCM_SVN_PROTOCOL_PREFIX.length() + 1);
        } else {
            this.scmTagBase = "";
        }
        ContinuumReleaseManager releaseManager = this.getContinuum().getReleaseManager();
        releaseManager.sanitizeTagName(scmUrl, this.scmTag);
        this.prepareGoals = "clean integration-test";
        if (this.getContinuum().getConfiguration().isDistributedBuildEnabled()) {
            DistributedReleaseManager distributedReleaseManager = this.getContinuum().getDistributedReleaseManager();
            try {
                this.getReleasePluginParameters(distributedReleaseManager.getReleasePluginParameters(this.projectId, "pom.xml"));
                this.projects = distributedReleaseManager.processProject(this.projectId, "pom.xml", this.autoVersionSubmodules);
            }
            catch (BuildAgentConfigurationException e) {
                ArrayList<String> args = new ArrayList<String>();
                args.add(e.getMessage());
                this.addActionError(this.getText("distributedBuild.releasePrepare.input.error", args));
                return "error";
            }
        }
        try {
            String workingDirectory = this.getContinuum().getWorkingDirectory(project.getId()).getPath();
            this.getReleasePluginParameters(workingDirectory, "pom.xml");
            this.processProject(workingDirectory, "pom.xml");
        }
        catch (Exception e) {
            ArrayList<String> args = new ArrayList<String>();
            args.add(e.getMessage());
            this.addActionError(this.getText("releasePrepare.input.error", args));
            return "error";
        }
        this.profiles = this.getContinuum().getProfileService().getAllProfiles();
        return "success";
    }

    private void getReleasePluginParameters(String workingDirectory, String pomFilename) throws Exception {
        MavenXpp3Reader pomReader = new MavenXpp3Reader();
        Model model = pomReader.read((Reader)new FileReader(new File(workingDirectory, pomFilename)));
        if (model.getBuild() != null && model.getBuild().getPlugins() != null) {
            for (Plugin plugin : model.getBuild().getPlugins()) {
                Xpp3Dom dom;
                if (plugin.getGroupId() == null || !plugin.getGroupId().equals("org.apache.maven.plugins") || plugin.getArtifactId() == null || !plugin.getArtifactId().equals("maven-release-plugin") || (dom = (Xpp3Dom)plugin.getConfiguration()) == null) continue;
                Xpp3Dom configuration = dom.getChild("releaseLabel");
                if (configuration != null) {
                    this.scmTag = configuration.getValue();
                }
                if ((configuration = dom.getChild("tag")) != null) {
                    this.scmTag = configuration.getValue();
                }
                if ((configuration = dom.getChild("tagBase")) != null) {
                    this.scmTagBase = configuration.getValue();
                }
                if ((configuration = dom.getChild("preparationGoals")) != null) {
                    this.prepareGoals = configuration.getValue();
                }
                if ((configuration = dom.getChild("arguments")) != null) {
                    this.arguments = configuration.getValue();
                }
                if ((configuration = dom.getChild("scmCommentPrefix")) != null) {
                    this.scmCommentPrefix = configuration.getValue();
                }
                if ((configuration = dom.getChild("autoVersionSubmodules")) != null) {
                    this.autoVersionSubmodules = Boolean.valueOf(configuration.getValue());
                }
                if ((configuration = dom.getChild("addSchema")) == null) continue;
                this.addSchema = Boolean.valueOf(configuration.getValue());
            }
        }
    }

    public String execute() throws Exception {
        block9: {
            String m2Home;
            try {
                this.checkBuildProjectInGroupAuthorization(this.getProjectGroupName());
            }
            catch (AuthorizationRequiredException e) {
                return "requires-authorization";
            }
            Project project = this.getContinuum().getProject(this.projectId);
            this.name = project.getName();
            if (this.name == null) {
                this.name = project.getArtifactId();
            }
            Profile profile = null;
            if (this.profileId != -1) {
                profile = this.getContinuum().getProfileService().getProfile(this.profileId);
            }
            Map environments = this.getEnvironments(profile);
            if (this.getContinuum().getConfiguration().isDistributedBuildEnabled()) {
                DistributedReleaseManager distributedReleaseManager = this.getContinuum().getDistributedReleaseManager();
                try {
                    this.releaseId = distributedReleaseManager.releasePrepare(project, this.getReleaseProperties(), this.getRelVersionMap(), this.getDevVersionMap(), environments);
                    if (this.releaseId == null) {
                        this.addActionError("Failed to release project");
                        return "error";
                    }
                    break block9;
                }
                catch (BuildAgentConfigurationException e) {
                    ArrayList<String> args = new ArrayList<String>();
                    args.add(e.getMessage());
                    this.addActionError(this.getText("distributedBuild.releasePrepare.release.error", args));
                    return "error";
                }
            }
            this.listener = new DefaultReleaseManagerListener();
            String workingDirectory = this.getContinuum().getWorkingDirectory(this.projectId).getPath();
            ContinuumReleaseManager releaseManager = this.getContinuum().getReleaseManager();
            String executable = this.getContinuum().getInstallationService().getExecutorConfigurator("maven2").getExecutable();
            if (environments != null && StringUtils.isNotEmpty((String)(m2Home = (String)environments.get(this.getContinuum().getInstallationService().getEnvVar("maven2"))))) {
                executable = m2Home + File.separator + "bin" + File.separator + executable;
            }
            this.releaseId = releaseManager.prepare(project, this.getReleaseProperties(), this.getRelVersionMap(), this.getDevVersionMap(), this.listener, workingDirectory, environments, executable);
        }
        AuditLog event = new AuditLog("Release id=" + this.releaseId, "Prepare Project Release");
        event.setCategory("PROJECT");
        event.setCurrentUser(this.getPrincipal());
        event.log();
        return "success";
    }

    public String viewResult() throws Exception {
        try {
            this.checkBuildProjectInGroupAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException e) {
            return "requires-authorization";
        }
        if (this.getContinuum().getConfiguration().isDistributedBuildEnabled()) {
            DistributedReleaseManager distributedReleaseManager = this.getContinuum().getDistributedReleaseManager();
            try {
                this.result = distributedReleaseManager.getReleaseResult(this.releaseId);
            }
            catch (BuildAgentConfigurationException e) {
                this.addActionError("release");
                return "viewResultError";
            }
        } else {
            this.result = (ReleaseResult)this.getContinuum().getReleaseManager().getReleaseResults().get(this.releaseId);
        }
        return "viewResult";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String checkProgress() throws Exception {
        String status;
        try {
            this.checkBuildProjectInGroupAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException e) {
            return "requires-authorization";
        }
        this.listenerSummary = new ReleaseListenerSummary();
        if (this.getContinuum().getConfiguration().isDistributedBuildEnabled()) {
            Map listenerMap;
            DistributedReleaseManager distributedReleaseManager = this.getContinuum().getDistributedReleaseManager();
            try {
                listenerMap = distributedReleaseManager.getListener(this.releaseId);
            }
            catch (BuildAgentConfigurationException e) {
                this.addActionError("");
                return "";
            }
            if (listenerMap == null || listenerMap.isEmpty()) throw new Exception("There is no release on-going or finished with id: " + this.releaseId);
            int state = DistributedReleaseUtil.getReleaseState((Map)listenerMap);
            if (state == 3) {
                distributedReleaseManager.removeListener(this.releaseId);
                this.result = distributedReleaseManager.getReleaseResult(this.releaseId);
                status = "finished";
            } else {
                status = "inProgress";
            }
            this.listenerSummary.setPhases(DistributedReleaseUtil.getReleasePhases((Map)listenerMap));
            this.listenerSummary.setCompletedPhases(DistributedReleaseUtil.getCompletedReleasePhases((Map)listenerMap));
            this.listenerSummary.setInProgress(DistributedReleaseUtil.getReleaseInProgress((Map)listenerMap));
            this.listenerSummary.setError(DistributedReleaseUtil.getReleaseError((Map)listenerMap));
            return status;
        }
        ContinuumReleaseManager releaseManager = this.getContinuum().getReleaseManager();
        this.listener = (ContinuumReleaseManagerListener)releaseManager.getListeners().get(this.releaseId);
        if (this.listener == null) throw new Exception("There is no release on-going or finished with id: " + this.releaseId);
        if (this.listener.getState() == 3) {
            releaseManager.getListeners().remove(this.releaseId);
            this.result = (ReleaseResult)releaseManager.getReleaseResults().get(this.releaseId);
            status = "finished";
        } else {
            status = "inProgress";
        }
        this.listenerSummary.setPhases(this.listener.getPhases());
        this.listenerSummary.setCompletedPhases(this.listener.getCompletedPhases());
        this.listenerSummary.setInProgress(this.listener.getInProgress());
        this.listenerSummary.setError(this.listener.getError());
        return status;
    }

    private void processProject(String workingDirectory, String pomFilename) throws Exception {
        MavenXpp3Reader pomReader = new MavenXpp3Reader();
        Model model = pomReader.read((Reader)new FileReader(new File(workingDirectory, pomFilename)));
        if (model.getGroupId() == null) {
            model.setGroupId(model.getParent().getGroupId());
        }
        if (model.getVersion() == null) {
            model.setVersion(model.getParent().getVersion());
        }
        this.setProperties(model);
        if (!this.autoVersionSubmodules) {
            Iterator modules = model.getModules().iterator();
            while (modules.hasNext()) {
                this.processProject(workingDirectory + "/" + modules.next().toString(), "pom.xml");
            }
        }
    }

    private void setProperties(Model model) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key", model.getGroupId() + ":" + model.getArtifactId());
        if (model.getName() == null) {
            model.setName(model.getArtifactId());
        }
        params.put("name", model.getName());
        DefaultVersionInfo version = new DefaultVersionInfo(model.getVersion());
        params.put("release", version.getReleaseVersionString());
        params.put("dev", version.getNextVersion().getSnapshotVersionString());
        this.projects.add(params);
    }

    private Map<String, String> getDevVersionMap() {
        return this.getVersionMap(this.projectKeys, this.devVersions);
    }

    private Map<String, String> getRelVersionMap() {
        return this.getVersionMap(this.projectKeys, this.relVersions);
    }

    private Map<String, String> getVersionMap(List<String> keys, List<String> versions) {
        HashMap<String, String> versionMap = new HashMap<String, String>();
        for (int idx = 0; idx < keys.size(); ++idx) {
            String key = keys.get(idx);
            String version = !this.autoVersionSubmodules ? versions.get(idx) : versions.get(0);
            versionMap.put(key, version);
        }
        return versionMap;
    }

    private Properties getReleaseProperties() {
        Properties p = new Properties();
        if (StringUtils.isNotEmpty((String)this.scmUsername)) {
            p.setProperty("username", this.scmUsername);
        }
        if (StringUtils.isNotEmpty((String)this.scmPassword)) {
            p.setProperty("password", this.scmPassword);
        }
        if (StringUtils.isNotEmpty((String)this.scmTagBase)) {
            p.setProperty("tagBase", this.scmTagBase);
        }
        if (StringUtils.isNotEmpty((String)this.scmCommentPrefix)) {
            p.setProperty("commentPrefix", this.scmCommentPrefix);
        }
        p.setProperty("tag", this.scmTag);
        p.setProperty("prepareGoals", this.prepareGoals);
        p.setProperty("arguments", this.arguments);
        p.setProperty("useEditMode", Boolean.toString(this.scmUseEditMode));
        p.setProperty("addSchema", Boolean.toString(this.addSchema));
        p.setProperty("autoVersionSubmodules", Boolean.toString(this.autoVersionSubmodules));
        return p;
    }

    private void getReleasePluginParameters(Map context) {
        this.scmTag = DistributedReleaseUtil.getScmTag((Map)context, (String)this.scmTag);
        this.scmTagBase = DistributedReleaseUtil.getScmTagBase((Map)context, (String)this.scmTagBase);
        this.prepareGoals = DistributedReleaseUtil.getPrepareGoals((Map)context, (String)this.prepareGoals);
        this.arguments = DistributedReleaseUtil.getArguments((Map)context, (String)"");
        this.scmCommentPrefix = DistributedReleaseUtil.getScmCommentPrefix((Map)context, (String)"");
        this.autoVersionSubmodules = DistributedReleaseUtil.getAutoVersionSubmodules((Map)context, (boolean)false);
        this.addSchema = DistributedReleaseUtil.getAddSchema((Map)context, (boolean)true);
    }

    public List<String> getProjectKeys() {
        return this.projectKeys;
    }

    public void setProjectKeys(List<String> projectKeys) {
        this.projectKeys = projectKeys;
    }

    public List<String> getDevVersions() {
        return this.devVersions;
    }

    public void setDevVersions(List<String> devVersions) {
        this.devVersions = devVersions;
    }

    public List<String> getRelVersions() {
        return this.relVersions;
    }

    public void setRelVersions(List<String> relVersions) {
        this.relVersions = relVersions;
    }

    public int getProjectId() {
        return this.projectId;
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    public String getScmUsername() {
        return this.scmUsername;
    }

    public void setScmUsername(String scmUsername) {
        this.scmUsername = scmUsername;
    }

    public String getScmPassword() {
        return this.scmPassword;
    }

    public void setScmPassword(String scmPassword) {
        this.scmPassword = scmPassword;
    }

    public String getScmTag() {
        return this.scmTag;
    }

    public void setScmTag(String scmTag) {
        this.scmTag = scmTag;
    }

    public String getScmTagBase() {
        return this.scmTagBase;
    }

    public void setScmTagBase(String scmTagBase) {
        this.scmTagBase = scmTagBase;
    }

    public List<Map<String, String>> getProjects() {
        return this.projects;
    }

    public void setProjects(List<Map<String, String>> projects) {
        this.projects = projects;
    }

    public ContinuumReleaseManagerListener getListener() {
        return this.listener;
    }

    public void setListener(DefaultReleaseManagerListener listener) {
        this.listener = listener;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getReleaseId() {
        return this.releaseId;
    }

    public void setReleaseId(String releaseId) {
        this.releaseId = releaseId;
    }

    public ReleaseResult getResult() {
        return this.result;
    }

    public void setResult(ReleaseResult result) {
        this.result = result;
    }

    public String getPrepareGoals() {
        return this.prepareGoals;
    }

    public void setPrepareGoals(String prepareGoals) {
        this.prepareGoals = prepareGoals;
    }

    public String getArguments() {
        return this.arguments;
    }

    public void setArguments(String arguments) {
        this.arguments = arguments;
    }

    public void validate() {
    }

    public String getProjectGroupName() throws ContinuumException {
        if (StringUtils.isEmpty((String)this.projectGroupName)) {
            this.projectGroupName = this.getContinuum().getProjectGroupByProjectId(this.projectId).getName();
        }
        return this.projectGroupName;
    }

    public List<Profile> getProfiles() {
        return this.profiles;
    }

    public void setProfiles(List<Profile> profiles) {
        this.profiles = profiles;
    }

    public int getProfileId() {
        return this.profileId;
    }

    public void setProfileId(int profileId) {
        this.profileId = profileId;
    }

    public boolean isScmUseEditMode() {
        return this.scmUseEditMode;
    }

    public void setScmUseEditMode(boolean scmUseEditMode) {
        this.scmUseEditMode = scmUseEditMode;
    }

    public String getScmCommentPrefix() {
        return this.scmCommentPrefix;
    }

    public void setScmCommentPrefix(String scmCommentPrefix) {
        this.scmCommentPrefix = scmCommentPrefix;
    }

    public boolean isAutoVersionSubmodules() {
        return this.autoVersionSubmodules;
    }

    public void setAutoVersionSubmodules(boolean autoVersionSubmodules) {
        this.autoVersionSubmodules = autoVersionSubmodules;
    }

    public boolean isAddSchema() {
        return this.addSchema;
    }

    public void setAddSchema(boolean addSchema) {
        this.addSchema = addSchema;
    }

    public ReleaseListenerSummary getListenerSummary() {
        return this.listenerSummary;
    }

    public void setListenerSummary(ReleaseListenerSummary listenerSummary) {
        this.listenerSummary = listenerSummary;
    }
}

