/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.continuum.configuration.BuildAgentConfigurationException;
import org.apache.continuum.model.repository.LocalRepository;
import org.apache.continuum.release.config.ContinuumReleaseDescriptor;
import org.apache.continuum.release.distributed.DistributedReleaseUtil;
import org.apache.continuum.release.distributed.manager.DistributedReleaseManager;
import org.apache.continuum.web.action.AbstractReleaseAction;
import org.apache.continuum.web.util.AuditLog;
import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.model.system.Profile;
import org.apache.maven.continuum.release.ContinuumReleaseManager;
import org.apache.maven.continuum.release.ContinuumReleaseManagerListener;
import org.apache.maven.continuum.release.DefaultReleaseManagerListener;
import org.apache.maven.continuum.web.exception.AuthorizationRequiredException;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.shared.release.ReleaseResult;
import org.codehaus.plexus.util.xml.Xpp3Dom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReleasePerformAction
extends AbstractReleaseAction {
    private int projectId;
    private String releaseId;
    private String scmUrl;
    private String scmUsername;
    private String scmPassword;
    private String scmTag;
    private String scmTagBase;
    private String goals = "clean deploy";
    private String arguments;
    private boolean useReleaseProfile = true;
    private ContinuumReleaseManagerListener listener;
    private ReleaseResult result;
    private String projectGroupName = "";
    private List<Profile> profiles;
    private int profileId;

    private void init() throws Exception {
        if (this.getContinuum().getConfiguration().isDistributedBuildEnabled()) {
            DistributedReleaseManager distributedReleaseManager = this.getContinuum().getDistributedReleaseManager();
            this.getReleasePluginParameters(distributedReleaseManager.getReleasePluginParameters(this.projectId, "pom.xml"));
        } else {
            Project project = this.getContinuum().getProject(this.projectId);
            String workingDirectory = this.getContinuum().getWorkingDirectory(project.getId()).getPath();
            this.getReleasePluginParameters(workingDirectory, "pom.xml");
        }
    }

    public String inputFromScm() throws Exception {
        try {
            this.checkBuildProjectInGroupAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException e) {
            return "requires-authorization";
        }
        try {
            this.init();
        }
        catch (BuildAgentConfigurationException e) {
            ArrayList<String> args = new ArrayList<String>();
            args.add(e.getMessage());
            this.addActionError(this.getText("distributedBuild.releasePerform.input.error", args));
            return "error";
        }
        this.populateFromProject();
        this.releaseId = "";
        this.profiles = this.getContinuum().getProfileService().getAllProfiles();
        return "success";
    }

    public String input() throws Exception {
        try {
            this.checkBuildProjectInGroupAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException e) {
            return "requires-authorization";
        }
        try {
            this.init();
        }
        catch (BuildAgentConfigurationException e) {
            ArrayList<String> args = new ArrayList<String>();
            args.add(e.getMessage());
            this.addActionError(this.getText("distributedBuild.releasePerform.input.error", args));
            return "error";
        }
        return "success";
    }

    private void getReleasePluginParameters(String workingDirectory, String pomFilename) throws Exception {
        MavenXpp3Reader pomReader = new MavenXpp3Reader();
        Model model = pomReader.read((Reader)new FileReader(new File(workingDirectory, pomFilename)));
        if (model.getBuild() != null && model.getBuild().getPlugins() != null) {
            for (Plugin plugin : model.getBuild().getPlugins()) {
                Xpp3Dom dom;
                if (plugin.getGroupId() == null || !plugin.getGroupId().equals("org.apache.maven.plugins") || plugin.getArtifactId() == null || !plugin.getArtifactId().equals("maven-release-plugin") || (dom = (Xpp3Dom)plugin.getConfiguration()) == null) continue;
                Xpp3Dom configuration = dom.getChild("useReleaseProfile");
                if (configuration != null) {
                    this.useReleaseProfile = Boolean.valueOf(configuration.getValue());
                }
                if ((configuration = dom.getChild("goals")) != null) {
                    this.goals = configuration.getValue();
                    if (model.getDistributionManagement() != null && model.getDistributionManagement().getSite() != null) {
                        this.goals = this.goals + " site-deploy";
                    }
                }
                if ((configuration = dom.getChild("arguments")) == null) continue;
                this.arguments = configuration.getValue();
            }
        }
    }

    public String execute() throws Exception {
        DistributedReleaseManager releaseManager;
        try {
            this.checkBuildProjectInGroupAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException e) {
            return "requires-authorization";
        }
        Project project = this.getContinuum().getProject(this.projectId);
        LocalRepository repository = project.getProjectGroup().getLocalRepository();
        if (this.getContinuum().getConfiguration().isDistributedBuildEnabled()) {
            releaseManager = this.getContinuum().getDistributedReleaseManager();
            try {
                releaseManager.releasePerform(this.projectId, this.releaseId, this.goals, this.arguments, this.useReleaseProfile, repository);
            }
            catch (BuildAgentConfigurationException e) {
                ArrayList<String> args = new ArrayList<String>();
                args.add(e.getMessage());
                this.addActionError(this.getText("distributedBuild.releasePerform.release.error", args));
                return "error";
            }
        } else {
            this.listener = new DefaultReleaseManagerListener();
            releaseManager = this.getContinuum().getReleaseManager();
            File performDirectory = new File(this.getContinuum().getConfiguration().getWorkingDirectory(), "releases-" + System.currentTimeMillis());
            performDirectory.mkdirs();
            releaseManager.perform(this.releaseId, performDirectory, this.goals, this.arguments, this.useReleaseProfile, this.listener, repository);
        }
        AuditLog event = new AuditLog("ReleaseId=" + this.releaseId, "Perform Project Release");
        event.setCategory("PROJECT");
        event.setCurrentUser(this.getPrincipal());
        event.log();
        return "success";
    }

    public String executeFromScm() throws Exception {
        if (this.getContinuum().getConfiguration().isDistributedBuildEnabled()) {
            Project project = this.getContinuum().getProject(this.projectId);
            LocalRepository repository = project.getProjectGroup().getLocalRepository();
            DistributedReleaseManager releaseManager = this.getContinuum().getDistributedReleaseManager();
            Map environments = new HashMap();
            if (this.profileId != -1) {
                Profile profile = this.getContinuum().getProfileService().getProfile(this.profileId);
                environments = this.getEnvironments(profile);
            }
            try {
                releaseManager.releasePerformFromScm(this.projectId, this.goals, this.arguments, this.useReleaseProfile, repository, this.scmUrl, this.scmUsername, this.scmPassword, this.scmTag, this.scmTagBase, environments);
            }
            catch (BuildAgentConfigurationException e) {
                ArrayList<String> args = new ArrayList<String>();
                args.add(e.getMessage());
                this.addActionError(this.getText("distributedBuild.releasePerform.release.error", args));
                return "error";
            }
            return "success";
        }
        ContinuumReleaseManager releaseManager = this.getContinuum().getReleaseManager();
        ContinuumReleaseDescriptor descriptor = new ContinuumReleaseDescriptor();
        descriptor.setScmSourceUrl(this.scmUrl);
        descriptor.setScmUsername(this.scmUsername);
        descriptor.setScmPassword(this.scmPassword);
        descriptor.setScmReleaseLabel(this.scmTag);
        descriptor.setScmTagBase(this.scmTagBase);
        if (this.profileId != -1) {
            Profile profile = this.getContinuum().getProfileService().getProfile(this.profileId);
            descriptor.setEnvironments(this.getEnvironments(profile));
        }
        do {
            this.releaseId = String.valueOf(System.currentTimeMillis());
        } while (releaseManager.getPreparedReleases().containsKey(this.releaseId));
        releaseManager.getPreparedReleases().put(this.releaseId, descriptor);
        return this.execute();
    }

    private void populateFromProject() throws Exception {
        Project project = this.getContinuum().getProjectWithAllDetails(this.projectId);
        this.scmUrl = project.getScmUrl();
        this.scmUsername = project.getScmUsername();
        this.scmPassword = project.getScmPassword();
        this.scmTagBase = this.scmUrl.startsWith("scm:svn:") ? new SvnScmProviderRepository(this.scmUrl, this.scmUsername, this.scmPassword).getTagBase() : "";
        this.releaseId = "";
    }

    private void getReleasePluginParameters(Map context) {
        this.useReleaseProfile = DistributedReleaseUtil.getUseReleaseProfile((Map)context, (boolean)this.useReleaseProfile);
        this.goals = DistributedReleaseUtil.getGoals((Map)context, (String)this.goals);
        this.arguments = DistributedReleaseUtil.getArguments((Map)context, (String)"");
    }

    public String getReleaseId() {
        return this.releaseId;
    }

    public void setReleaseId(String releaseId) {
        this.releaseId = releaseId;
    }

    public String getScmUrl() {
        return this.scmUrl;
    }

    public void setScmUrl(String scmUrl) {
        this.scmUrl = scmUrl;
    }

    public String getScmUsername() {
        return this.scmUsername;
    }

    public void setScmUsername(String scmUsername) {
        this.scmUsername = scmUsername;
    }

    public String getScmPassword() {
        return this.scmPassword;
    }

    public void setScmPassword(String scmPassword) {
        this.scmPassword = scmPassword;
    }

    public String getScmTag() {
        return this.scmTag;
    }

    public void setScmTag(String scmTag) {
        this.scmTag = scmTag;
    }

    public String getScmTagBase() {
        return this.scmTagBase;
    }

    public void setScmTagBase(String scmTagBase) {
        this.scmTagBase = scmTagBase;
    }

    public String getGoals() {
        return this.goals;
    }

    public void setGoals(String goals) {
        this.goals = goals;
    }

    public boolean isUseReleaseProfile() {
        return this.useReleaseProfile;
    }

    public void setUseReleaseProfile(boolean useReleaseProfile) {
        this.useReleaseProfile = useReleaseProfile;
    }

    public ContinuumReleaseManagerListener getListener() {
        return this.listener;
    }

    public void setListener(ContinuumReleaseManagerListener listener) {
        this.listener = listener;
    }

    public ReleaseResult getResult() {
        return this.result;
    }

    public void setResult(ReleaseResult result) {
        this.result = result;
    }

    public int getProjectId() {
        return this.projectId;
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    public String getProjectGroupName() throws ContinuumException {
        if (this.projectGroupName == null || "".equals(this.projectGroupName)) {
            this.projectGroupName = this.getContinuum().getProjectGroupByProjectId(this.projectId).getName();
        }
        return this.projectGroupName;
    }

    public List<Profile> getProfiles() {
        return this.profiles;
    }

    public void setProfiles(List<Profile> profiles) {
        this.profiles = profiles;
    }

    public int getProfileId() {
        return this.profileId;
    }

    public void setProfileId(int profileId) {
        this.profileId = profileId;
    }

    public String getArguments() {
        return this.arguments;
    }

    public void setArguments(String arguments) {
        this.arguments = arguments;
    }
}

